/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.core.serialization.JsonEntitySerializer;
import org.apache.olingo.client.core.serialization.JsonSerializer;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.format.ContentType;

public class JsonEntitySetSerializer
extends JsonSerializer {
    public JsonEntitySetSerializer(boolean serverMode, ContentType contentType) {
        super(serverMode, contentType);
    }

    protected void doSerialize(EntityCollection entitySet, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        this.doContainerSerialize(new ResWrap<EntityCollection>(null, null, entitySet), jgen);
    }

    protected void doContainerSerialize(ResWrap<EntityCollection> container, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        EntityCollection entitySet = container.getPayload();
        jgen.writeStartObject();
        if (this.serverMode && !this.isODataMetadataNone) {
            if (container.getContextURL() != null) {
                jgen.writeStringField("@odata.context", container.getContextURL().toASCIIString());
            }
            if (container.getMetadataETag() != null) {
                jgen.writeStringField("@odata.metadataEtag", container.getMetadataETag());
            }
        }
        if (entitySet.getId() != null && this.isODataMetadataFull) {
            jgen.writeStringField("@odata.id", entitySet.getId().toASCIIString());
        }
        Integer count = entitySet.getCount() == null ? entitySet.getEntities().size() : entitySet.getCount().intValue();
        if (this.isIEEE754Compatible) {
            jgen.writeStringField("@odata.count", Integer.toString(count));
        } else {
            jgen.writeNumberField("@odata.count", count.intValue());
        }
        if (this.serverMode) {
            if (entitySet.getNext() != null) {
                jgen.writeStringField("@odata.nextLink", entitySet.getNext().toASCIIString());
            }
            if (entitySet.getDeltaLink() != null && !this.isODataMetadataNone) {
                jgen.writeStringField("@odata.deltaLink", entitySet.getDeltaLink().toASCIIString());
            }
        }
        for (Annotation annotation : entitySet.getAnnotations()) {
            this.valuable(jgen, annotation, "@" + annotation.getTerm());
        }
        jgen.writeArrayFieldStart("value");
        JsonEntitySerializer entitySerializer = new JsonEntitySerializer(this.serverMode, this.contentType);
        for (Entity entity : entitySet.getEntities()) {
            entitySerializer.doSerialize(entity, jgen);
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }
}

