/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.data;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;

public final class GeoUtils {
    public static Geospatial.Dimension getDimension(EdmPrimitiveTypeKind type) {
        return switch (type) {
            case EdmPrimitiveTypeKind.Geography, EdmPrimitiveTypeKind.GeographyCollection, EdmPrimitiveTypeKind.GeographyLineString, EdmPrimitiveTypeKind.GeographyMultiLineString, EdmPrimitiveTypeKind.GeographyPoint, EdmPrimitiveTypeKind.GeographyMultiPoint, EdmPrimitiveTypeKind.GeographyPolygon, EdmPrimitiveTypeKind.GeographyMultiPolygon -> Geospatial.Dimension.GEOGRAPHY;
            default -> Geospatial.Dimension.GEOMETRY;
        };
    }

    public static EdmPrimitiveTypeKind getType(Geospatial.Dimension dimension, String elementName) {
        EdmPrimitiveTypeKind type = null;
        if ("Point".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyPoint : EdmPrimitiveTypeKind.GeometryPoint;
        } else if ("MultiPoint".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyMultiPoint : EdmPrimitiveTypeKind.GeometryMultiPoint;
        } else if ("LineString".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyLineString : EdmPrimitiveTypeKind.GeometryLineString;
        } else if ("MultiCurve".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyMultiLineString : EdmPrimitiveTypeKind.GeometryMultiLineString;
        } else if ("Polygon".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyPolygon : EdmPrimitiveTypeKind.GeometryPolygon;
        } else if ("MultiSurface".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyMultiPolygon : EdmPrimitiveTypeKind.GeometryMultiPolygon;
        } else if ("MultiGeometry".equals(elementName) || "geometryMembers".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyCollection : EdmPrimitiveTypeKind.GeometryCollection;
        }
        return type;
    }

    private GeoUtils() {
    }
}

