/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Parameter;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.server.api.deserializer.DeserializerResult;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;

public class DeserializerResultImpl
implements DeserializerResult {
    private Entity entity;
    private EntityCollection entitySet;
    private ExpandOption expandOption;
    private Property property;
    private Map<String, Parameter> actionParameters;
    private List<URI> entityReferences;
    private Delta delta;

    private DeserializerResultImpl() {
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public EntityCollection getEntityCollection() {
        return this.entitySet;
    }

    @Override
    public ExpandOption getExpandTree() {
        return this.expandOption;
    }

    @Override
    public Map<String, Parameter> getActionParameters() {
        return this.actionParameters;
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public List<URI> getEntityReferences() {
        return this.entityReferences;
    }

    @Override
    public Delta getDelta() {
        return this.delta;
    }

    public static DeserializerResultBuilder with() {
        return new DeserializerResultBuilder();
    }

    public static class DeserializerResultBuilder {
        private Entity entity;
        private EntityCollection entitySet;
        private ExpandOption expandOption;
        private Property property;
        private Map<String, Parameter> actionParameters;
        private List<URI> entityReferences;
        private Delta delta;

        public DeserializerResult build() {
            DeserializerResultImpl result = new DeserializerResultImpl();
            result.entity = this.entity;
            result.entitySet = this.entitySet;
            result.expandOption = this.expandOption;
            result.property = this.property;
            result.entityReferences = this.entityReferences == null ? new ArrayList() : this.entityReferences;
            result.actionParameters = this.actionParameters == null ? new LinkedHashMap() : this.actionParameters;
            result.delta = this.delta;
            return result;
        }

        public DeserializerResultBuilder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public DeserializerResultBuilder entityCollection(EntityCollection entitySet) {
            this.entitySet = entitySet;
            return this;
        }

        public DeserializerResultBuilder delta(Delta delta) {
            this.delta = delta;
            return this;
        }

        public DeserializerResultBuilder expandOption(ExpandOption expandOption) {
            this.expandOption = expandOption;
            return this;
        }

        public DeserializerResultBuilder property(Property property) {
            this.property = property;
            return this;
        }

        public DeserializerResultBuilder entityReferences(List<URI> entityReferences) {
            this.entityReferences = entityReferences;
            return this;
        }

        public DeserializerResultBuilder actionParameters(Map<String, Parameter> actionParameters) {
            this.actionParameters = actionParameters;
            return this;
        }
    }
}

