/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.client.api.domain.AbstractClientValue;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientValue;

public class ClientCollectionValueImpl<OV extends ClientValue>
extends AbstractClientValue
implements ClientCollectionValue<OV> {
    protected final List<OV> values = new ArrayList<OV>();

    public ClientCollectionValueImpl(String typeName) {
        super((String)(typeName == null || typeName.startsWith("Collection(") ? typeName : "Collection(" + typeName + ")"));
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public ClientEnumValue asEnum() {
        return null;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public Collection<Object> asJavaCollection() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ClientValue value : this.values) {
            if (value.isPrimitive()) {
                result.add(value.asPrimitive().toValue());
                continue;
            }
            if (value.isComplex()) {
                result.add(value.asComplex().asJavaMap());
                continue;
            }
            if (value.isCollection()) {
                result.add(value.asCollection().asJavaCollection());
                continue;
            }
            if (!value.isEnum()) continue;
            result.add(value.asEnum().toString());
        }
        return result;
    }

    @Override
    public ClientCollectionValue<OV> add(ClientValue value) {
        this.values.add(value);
        return this;
    }

    @Override
    public Iterator<OV> iterator() {
        return this.values.iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClientCollectionValueImpl)) {
            return false;
        }
        ClientCollectionValueImpl other = (ClientCollectionValueImpl)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public String toString() {
        return "ClientCollectionValueImpl [values=" + this.values + "super[" + super.toString() + "]]";
    }
}

