/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlOperationImport;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmActionImportImpl;
import org.apache.olingo.commons.core.edm.EdmEntitySetImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImportImpl;
import org.apache.olingo.commons.core.edm.EdmProviderImpl;
import org.apache.olingo.commons.core.edm.EdmSingletonImpl;

public class EdmEntityContainerImpl
extends AbstractEdmNamed
implements EdmEntityContainer {
    private final CsdlEdmProvider provider;
    private CsdlEntityContainer container;
    private final FullQualifiedName entityContainerName;
    private final FullQualifiedName parentContainerName;
    private List<EdmSingleton> singletons;
    private final Map<String, EdmSingleton> singletonCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmEntitySet> entitySets;
    private final Map<String, EdmEntitySet> entitySetCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmActionImport> actionImports;
    private final Map<String, EdmActionImport> actionImportCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmFunctionImport> functionImports;
    private final Map<String, EdmFunctionImport> functionImportCache = Collections.synchronizedMap(new LinkedHashMap());
    private final String SLASH = "/";
    private final String DOT = ".";

    public EdmEntityContainerImpl(Edm edm, CsdlEdmProvider provider, CsdlEntityContainerInfo entityContainerInfo) {
        super(edm, entityContainerInfo.getContainerName().getName(), null);
        this.provider = provider;
        this.entityContainerName = entityContainerInfo.getContainerName();
        this.parentContainerName = entityContainerInfo.getExtendsContainer();
    }

    public EdmEntityContainerImpl(Edm edm, CsdlEdmProvider provider, FullQualifiedName containerFQN, CsdlEntityContainer entityContainer) {
        super(edm, containerFQN.getName(), entityContainer);
        this.provider = provider;
        this.container = entityContainer;
        this.entityContainerName = containerFQN;
        this.parentContainerName = entityContainer == null ? null : entityContainer.getExtendsContainerFQN();
    }

    @Override
    public String getNamespace() {
        return this.entityContainerName.getNamespace();
    }

    @Override
    public FullQualifiedName getFullQualifiedName() {
        return this.entityContainerName;
    }

    @Override
    public EdmSingleton getSingleton(String singletonName) {
        EdmSingleton singleton = this.singletonCache.get(singletonName);
        if (singleton == null && (singleton = this.createSingleton(singletonName)) != null) {
            this.singletonCache.put(singletonName, singleton);
        }
        return singleton;
    }

    @Override
    public EdmEntitySet getEntitySet(String entitySetName) {
        EdmEntitySet entitySet = this.entitySetCache.get(entitySetName);
        if (entitySet == null && (entitySet = this.createEntitySet(entitySetName)) != null) {
            this.entitySetCache.put(entitySetName, entitySet);
        }
        ((EdmProviderImpl)this.edm).setIsPreviousES(true);
        return entitySet;
    }

    @Override
    public EdmActionImport getActionImport(String actionImportName) {
        EdmActionImport actionImport = this.actionImportCache.get(actionImportName);
        if (actionImport == null && (actionImport = this.createActionImport(actionImportName)) != null) {
            this.actionImportCache.put(actionImportName, actionImport);
        }
        return actionImport;
    }

    @Override
    public EdmFunctionImport getFunctionImport(String functionImportName) {
        EdmFunctionImport functionImport = this.functionImportCache.get(functionImportName);
        if (functionImport == null && (functionImport = this.createFunctionImport(functionImportName)) != null) {
            this.functionImportCache.put(functionImportName, functionImport);
        }
        return functionImport;
    }

    @Override
    public List<EdmEntitySet> getEntitySets() {
        if (this.entitySets == null) {
            this.loadAllEntitySets();
        }
        return Collections.unmodifiableList(this.entitySets);
    }

    @Override
    public List<EdmEntitySet> getEntitySetsWithAnnotations() {
        this.loadAllEntitySets();
        return Collections.unmodifiableList(this.entitySets);
    }

    @Override
    public List<EdmFunctionImport> getFunctionImports() {
        if (this.functionImports == null) {
            this.loadAllFunctionImports();
        }
        return Collections.unmodifiableList(this.functionImports);
    }

    @Override
    public List<EdmSingleton> getSingletons() {
        if (this.singletons == null) {
            this.loadAllSingletons();
        }
        return Collections.unmodifiableList(this.singletons);
    }

    @Override
    public List<EdmActionImport> getActionImports() {
        if (this.actionImports == null) {
            this.loadAllActionImports();
        }
        return Collections.unmodifiableList(this.actionImports);
    }

    @Override
    public FullQualifiedName getParentContainerName() {
        return this.parentContainerName;
    }

    protected EdmSingleton createSingleton(String singletonName) {
        EdmSingletonImpl singleton = null;
        try {
            CsdlSingleton providerSingleton = this.provider.getSingleton(this.entityContainerName, singletonName);
            if (providerSingleton != null) {
                this.addSingletonAnnotations(providerSingleton, this.entityContainerName);
                singleton = new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, providerSingleton);
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return singleton;
    }

    private void addSingletonAnnotations(CsdlSingleton singleton, FullQualifiedName entityContainerName) {
        CsdlEntityType entityType = this.fetchEntityTypeFromSingleton(singleton);
        if (entityType == null) {
            return;
        }
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName + "/" + singleton.getName());
        this.addAnnotations(singleton, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "/" + singleton.getName());
        this.addAnnotations(singleton, annotationsOnAlias);
        this.addAnnotationsToPropertiesDerivedFromSingleton(singleton, entityType, entityContainerName);
    }

    private String getAliasInfo(String namespace) {
        try {
            if (null != this.provider.getAliasInfos()) {
                for (CsdlAliasInfo aliasInfo : this.provider.getAliasInfos()) {
                    if (null == aliasInfo.getNamespace() || !aliasInfo.getNamespace().equalsIgnoreCase(namespace)) continue;
                    return aliasInfo.getAlias();
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return null;
    }

    private void addAnnotationsToPropertiesDerivedFromSingleton(CsdlSingleton singleton, CsdlEntityType entityType, FullQualifiedName entityContainerName) {
        String entitySetName = null;
        String schemaName = null;
        String containerName = null;
        try {
            List<Object> entitySets = this.provider.getEntityContainer() != null ? this.provider.getEntityContainer().getEntitySets() : new ArrayList();
            for (CsdlEntitySet csdlEntitySet : entitySets) {
                entitySetName = csdlEntitySet.getName();
                String entityTypeName = csdlEntitySet.getTypeFQN().getFullQualifiedNameAsString();
                if (null == entityTypeName || !entityTypeName.equalsIgnoreCase(csdlEntitySet.getTypeFQN().getNamespace() + "." + entityType.getName())) continue;
                containerName = this.provider.getEntityContainer().getName();
                schemaName = csdlEntitySet.getTypeFQN().getNamespace();
                for (CsdlProperty property : entityType.getProperties()) {
                    if (this.isPropertyComplex(property)) {
                        CsdlComplexType complexType = this.getComplexTypeFromProperty(property);
                        this.addAnnotationsToComplexTypeIncludedFromSingleton(singleton, property, complexType);
                    }
                    this.removeAnnotationsAddedToPropertiesOfEntityType(entityType, property, entityContainerName);
                    this.removeAnnotationsAddedToPropertiesViaEntitySet(entityType, property, schemaName, containerName, entitySetName);
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    private void removeAnnotationsAddedToPropertiesViaEntitySet(CsdlEntityType entityType, CsdlProperty property, String schemaName, String containerName, String entitySetName) {
        List<CsdlAnnotation> annotPropDerivedFromES = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(schemaName + "." + containerName + "/" + entitySetName + "/" + property.getName());
        this.removeAnnotations(property, annotPropDerivedFromES);
        String aliasName = this.getAliasInfo(schemaName);
        List<CsdlAnnotation> annotPropDerivedFromESOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + containerName + "/" + entitySetName + "/" + property.getName());
        this.removeAnnotations(property, annotPropDerivedFromESOnAlias);
    }

    private CsdlEntityType fetchEntityTypeFromSingleton(CsdlSingleton singleton) {
        CsdlEntityType entityType;
        try {
            entityType = singleton.getTypeFQN() != null ? this.provider.getEntityType(new FullQualifiedName(singleton.getTypeFQN().getFullQualifiedNameAsString())) : null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return entityType;
    }

    private void addAnnotationsToComplexTypeIncludedFromSingleton(CsdlSingleton singleton, CsdlProperty propertyName, CsdlComplexType complexType) {
        List<CsdlAnnotation> annotationsOnAlias;
        List<CsdlAnnotation> annotations;
        String aliasName = this.getAliasInfo(this.entityContainerName.getNamespace());
        for (CsdlProperty complexPropertyName : complexType.getProperties()) {
            this.removeAnnotationAddedToPropertiesOfComplexType(complexType, complexPropertyName, this.entityContainerName);
            annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(this.entityContainerName + "/" + singleton.getName() + "/" + propertyName.getName() + "/" + complexPropertyName.getName());
            this.addAnnotations(complexPropertyName, annotations);
            annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + this.entityContainerName.getName() + "/" + singleton.getName() + "/" + propertyName.getName() + "/" + complexPropertyName.getName());
            this.addAnnotations(complexPropertyName, annotationsOnAlias);
        }
        for (CsdlNavigationProperty complexNavPropertyName : complexType.getNavigationProperties()) {
            this.checkAnnotationAddedToNavPropertiesOfComplexType(complexType, complexNavPropertyName, this.entityContainerName);
            annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(this.entityContainerName + "/" + singleton.getName() + "/" + propertyName.getName() + "/" + complexNavPropertyName.getName());
            this.addAnnotations(complexNavPropertyName, annotations);
            annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + this.entityContainerName.getName() + "/" + singleton.getName() + "/" + propertyName.getName() + "/" + complexNavPropertyName.getName());
            this.addAnnotations(complexNavPropertyName, annotationsOnAlias);
        }
    }

    private void addAnnotations(CsdlAnnotatable property, List<CsdlAnnotation> annotations) {
        if (null != annotations && !annotations.isEmpty()) {
            for (CsdlAnnotation annotation : annotations) {
                if (this.compareAnnotations(property.getAnnotations(), annotation)) continue;
                property.getAnnotations().add(annotation);
            }
        }
    }

    protected EdmEntitySet createEntitySet(String entitySetName) {
        EdmEntitySetImpl entitySet = null;
        try {
            CsdlEntitySet providerEntitySet = this.provider.getEntitySet(this.entityContainerName, entitySetName);
            if (providerEntitySet != null) {
                this.addEntitySetAnnotations(providerEntitySet, this.entityContainerName);
                entitySet = new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, providerEntitySet);
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return entitySet;
    }

    private void addEntitySetAnnotations(CsdlEntitySet entitySet, FullQualifiedName entityContainerName) {
        CsdlEntityType entityType = this.getCsdlEntityTypeFromEntitySet(entitySet);
        if (entityType == null) {
            return;
        }
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName + "/" + entitySet.getName());
        this.addAnnotations(entitySet, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "/" + entitySet.getName());
        this.addAnnotations(entitySet, annotationsOnAlias);
        this.addAnnotationsToPropertiesIncludedFromES(entitySet, entityContainerName, entityType);
    }

    private CsdlEntityType getCsdlEntityTypeFromEntitySet(CsdlEntitySet entitySet) {
        CsdlEntityType entityType;
        try {
            entityType = entitySet.getTypeFQN() != null ? this.provider.getEntityType(new FullQualifiedName(entitySet.getTypeFQN().getFullQualifiedNameAsString())) : null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return entityType;
    }

    private void addAnnotationsToPropertiesIncludedFromES(CsdlEntitySet entitySet, FullQualifiedName entityContainerName, CsdlEntityType entityType) {
        for (CsdlProperty property : entityType.getProperties()) {
            this.removeAnnotationsAddedToPropertiesOfEntityType(entityType, property, entityContainerName);
            if (this.isPropertyComplex(property)) {
                CsdlComplexType complexType = this.getComplexTypeFromProperty(property);
                this.addAnnotationsToComplexTypeIncludedFromES(entitySet, entityContainerName, property, complexType);
                continue;
            }
            this.addAnnotationsToETProperties(entitySet, entityContainerName, entityType, property);
        }
        for (CsdlNavigationProperty navProperty : entityType.getNavigationProperties()) {
            this.removeAnnotationsAddedToNavProperties(entityType, navProperty, entityContainerName);
            this.addAnnotationsToETNavProperties(entitySet, entityContainerName, entityType, navProperty);
        }
    }

    private void addAnnotationsToETProperties(CsdlEntitySet entitySet, FullQualifiedName entityContainerName, CsdlEntityType entityType, CsdlProperty property) {
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName + "/" + entitySet.getName() + "/" + property.getName());
        this.addAnnotations(property, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "/" + entitySet.getName() + "/" + property.getName());
        this.addAnnotations(property, annotationsOnAlias);
    }

    private void addAnnotationsToETNavProperties(CsdlEntitySet entitySet, FullQualifiedName entityContainerName, CsdlEntityType entityType, CsdlNavigationProperty navProperty) {
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName + "/" + entitySet.getName() + "/" + navProperty.getName());
        this.addAnnotations(navProperty, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "/" + entitySet.getName() + "/" + navProperty.getName());
        this.addAnnotations(navProperty, annotationsOnAlias);
    }

    private void removeAnnotationsAddedToPropertiesOfEntityType(CsdlEntityType type, CsdlProperty property, FullQualifiedName entityContainerName) {
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName.getNamespace() + "." + type.getName() + "/" + property.getName());
        this.removeAnnotations(property, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "." + type.getName() + "/" + property.getName());
        this.removeAnnotations(property, annotationsOnAlias);
    }

    private void removeAnnotations(CsdlAnnotatable property, List<CsdlAnnotation> annotations) {
        if (null != annotations && !annotations.isEmpty()) {
            property.getAnnotations().removeAll(annotations);
        }
    }

    private void removeAnnotationsAddedToNavProperties(CsdlEntityType entityType, CsdlNavigationProperty navProperty, FullQualifiedName entityContainerName) {
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName.getNamespace() + "." + entityType.getName() + "/" + navProperty.getName());
        this.removeAnnotations(navProperty, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "." + entityType.getName() + "/" + navProperty.getName());
        this.removeAnnotations(navProperty, annotationsOnAlias);
    }

    private CsdlComplexType getComplexTypeFromProperty(CsdlProperty propertyName) {
        CsdlComplexType complexType;
        try {
            complexType = this.provider.getComplexType(propertyName.getTypeAsFQNObject());
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return complexType;
    }

    private void addAnnotationsToComplexTypeIncludedFromES(CsdlEntitySet entitySet, FullQualifiedName entityContainerName, CsdlProperty complexProperty, CsdlComplexType complexType) {
        List<CsdlAnnotation> annotationsOnAlias;
        List<CsdlAnnotation> annotations;
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        for (CsdlProperty complexPropertyName : complexType.getProperties()) {
            this.removeAnnotationAddedToPropertiesOfComplexType(complexType, complexPropertyName, entityContainerName);
            annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName + "/" + entitySet.getName() + "/" + complexProperty.getName() + "/" + complexPropertyName.getName());
            this.addAnnotations(complexPropertyName, annotations);
            annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "/" + entitySet.getName() + "/" + complexProperty.getName() + "/" + complexPropertyName.getName());
            this.addAnnotations(complexPropertyName, annotationsOnAlias);
        }
        for (CsdlNavigationProperty complexNavProperty : complexType.getNavigationProperties()) {
            this.checkAnnotationAddedToNavPropertiesOfComplexType(complexType, complexNavProperty, entityContainerName);
            annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName + "/" + entitySet.getName() + "/" + complexProperty.getName() + "/" + complexNavProperty.getName());
            this.addAnnotations(complexNavProperty, annotations);
            annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "/" + entitySet.getName() + "/" + complexProperty.getName() + "/" + complexNavProperty.getName());
            this.addAnnotations(complexNavProperty, annotationsOnAlias);
        }
    }

    private void checkAnnotationAddedToNavPropertiesOfComplexType(CsdlComplexType complexType, CsdlNavigationProperty complexNavProperty, FullQualifiedName entityContainerName) {
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName.getNamespace() + "." + complexType.getName() + "/" + complexNavProperty.getName());
        this.removeAnnotations(complexNavProperty, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + complexType.getName() + "/" + complexNavProperty.getName());
        this.removeAnnotations(complexNavProperty, annotationsOnAlias);
    }

    private void removeAnnotationAddedToPropertiesOfComplexType(CsdlComplexType complexType, CsdlProperty complexPropertyName, FullQualifiedName entityContainerName) {
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName.getNamespace() + "." + complexType.getName() + "/" + complexPropertyName.getName());
        this.removeAnnotations(complexPropertyName, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "." + complexType.getName() + "/" + complexPropertyName.getName());
        this.removeAnnotations(complexPropertyName, annotationsOnAlias);
    }

    private boolean isPropertyComplex(CsdlProperty propertyName) {
        try {
            return this.provider.getComplexType(propertyName.getTypeAsFQNObject()) != null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    protected EdmActionImport createActionImport(String actionImportName) {
        EdmActionImportImpl actionImport = null;
        try {
            CsdlActionImport providerImport = this.provider.getActionImport(this.entityContainerName, actionImportName);
            if (providerImport != null) {
                this.addOperationImportAnnotations(providerImport, this.entityContainerName);
                actionImport = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, providerImport);
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return actionImport;
    }

    private void addOperationImportAnnotations(CsdlOperationImport actionImport, FullQualifiedName entityContainerName) {
        List<CsdlAnnotation> annotations = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(entityContainerName + "/" + actionImport.getName());
        this.addAnnotations(actionImport, annotations);
        String aliasName = this.getAliasInfo(entityContainerName.getNamespace());
        List<CsdlAnnotation> annotationsOnAlias = ((EdmProviderImpl)this.edm).getAnnotationsMap().get(aliasName + "." + entityContainerName.getName() + "/" + actionImport.getName());
        this.addAnnotations(actionImport, annotationsOnAlias);
    }

    protected EdmFunctionImport createFunctionImport(String functionImportName) {
        EdmFunctionImportImpl functionImport = null;
        try {
            CsdlFunctionImport providerImport = this.provider.getFunctionImport(this.entityContainerName, functionImportName);
            if (providerImport != null) {
                this.addOperationImportAnnotations(providerImport, this.entityContainerName);
                functionImport = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, providerImport);
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return functionImport;
    }

    protected void loadAllEntitySets() {
        this.loadContainer();
        List<CsdlEntitySet> providerEntitySets = this.container.getEntitySets();
        ArrayList<EdmEntitySet> entitySetsLocal = new ArrayList<EdmEntitySet>();
        if (providerEntitySets != null) {
            for (CsdlEntitySet entitySet : providerEntitySets) {
                this.addEntitySetAnnotations(entitySet, this.entityContainerName);
                EdmEntitySetImpl impl = new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, entitySet);
                this.entitySetCache.put(impl.getName(), impl);
                entitySetsLocal.add(impl);
            }
            this.entitySets = entitySetsLocal;
            ((EdmProviderImpl)this.edm).setIsPreviousES(true);
        }
    }

    protected void loadAllFunctionImports() {
        this.loadContainer();
        List<CsdlFunctionImport> providerFunctionImports = this.container.getFunctionImports();
        ArrayList<EdmFunctionImport> functionImportsLocal = new ArrayList<EdmFunctionImport>();
        if (providerFunctionImports != null) {
            for (CsdlFunctionImport functionImport : providerFunctionImports) {
                this.addOperationImportAnnotations(functionImport, this.entityContainerName);
                EdmFunctionImportImpl impl = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, functionImport);
                this.functionImportCache.put(impl.getName(), impl);
                functionImportsLocal.add(impl);
            }
            this.functionImports = functionImportsLocal;
        }
    }

    protected void loadAllSingletons() {
        this.loadContainer();
        List<CsdlSingleton> providerSingletons = this.container.getSingletons();
        ArrayList<EdmSingleton> singletonsLocal = new ArrayList<EdmSingleton>();
        if (providerSingletons != null) {
            for (CsdlSingleton singleton : providerSingletons) {
                this.addSingletonAnnotations(singleton, this.entityContainerName);
                EdmSingletonImpl impl = new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, singleton);
                this.singletonCache.put(singleton.getName(), impl);
                singletonsLocal.add(impl);
            }
            this.singletons = singletonsLocal;
        }
    }

    protected void loadAllActionImports() {
        this.loadContainer();
        List<CsdlActionImport> providerActionImports = this.container.getActionImports();
        ArrayList<EdmActionImport> actionImportsLocal = new ArrayList<EdmActionImport>();
        if (providerActionImports != null) {
            for (CsdlActionImport actionImport : providerActionImports) {
                this.addOperationImportAnnotations(actionImport, this.entityContainerName);
                EdmActionImportImpl impl = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, actionImport);
                this.actionImportCache.put(actionImport.getName(), impl);
                actionImportsLocal.add(impl);
            }
            this.actionImports = actionImportsLocal;
        }
    }

    private void loadContainer() {
        if (this.container == null) {
            try {
                CsdlEntityContainer containerLocal = this.provider.getEntityContainer();
                if (containerLocal == null) {
                    containerLocal = new CsdlEntityContainer().setName(this.getName());
                }
                ((EdmProviderImpl)this.edm).addEntityContainerAnnotations(containerLocal, this.entityContainerName);
                this.container = containerLocal;
            }
            catch (ODataException e) {
                throw new EdmException(e);
            }
        }
    }

    private boolean compareAnnotations(List<CsdlAnnotation> annotations, CsdlAnnotation annotation) {
        for (CsdlAnnotation annot : annotations) {
            if (!annot.equals(annotation)) continue;
            return true;
        }
        return false;
    }
}

