/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmMember;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumMember;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.core.edm.EdmMemberImpl;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmEnumTypeImpl
extends EdmTypeImpl
implements EdmEnumType {
    private final EdmPrimitiveType underlyingType;
    private final CsdlEnumType enumType;
    private final FullQualifiedName enumName;
    private List<String> memberNames;
    private Map<String, EdmMember> membersMap;

    public EdmEnumTypeImpl(Edm edm, FullQualifiedName enumName, CsdlEnumType enumType) {
        super(edm, enumName, EdmTypeKind.ENUM, enumType);
        if (enumType.getUnderlyingType() == null) {
            this.underlyingType = EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int32);
        } else {
            EdmPrimitiveTypeKind underlyingTypeKind = EdmPrimitiveTypeKind.valueOfFQN(enumType.getUnderlyingType());
            if (underlyingTypeKind == EdmPrimitiveTypeKind.Byte || underlyingTypeKind == EdmPrimitiveTypeKind.SByte || underlyingTypeKind == EdmPrimitiveTypeKind.Int16 || underlyingTypeKind == EdmPrimitiveTypeKind.Int32 || underlyingTypeKind == EdmPrimitiveTypeKind.Int64) {
                this.underlyingType = EdmPrimitiveTypeFactory.getInstance(underlyingTypeKind);
            } else {
                throw new EdmException("Not allowed as underlying type: " + underlyingTypeKind);
            }
        }
        this.enumType = enumType;
        this.enumName = enumName;
    }

    @Override
    public EdmPrimitiveType getUnderlyingType() {
        return this.underlyingType;
    }

    @Override
    public EdmMember getMember(String name) {
        if (this.membersMap == null) {
            this.createEdmMembers();
        }
        return this.membersMap.get(name);
    }

    @Override
    public List<String> getMemberNames() {
        if (this.memberNames == null) {
            this.createEdmMembers();
        }
        return Collections.unmodifiableList(this.memberNames);
    }

    private void createEdmMembers() {
        LinkedHashMap<String, EdmMember> membersMapLocal = new LinkedHashMap<String, EdmMember>();
        ArrayList<String> memberNamesLocal = new ArrayList<String>();
        if (this.enumType.getMembers() != null) {
            for (CsdlEnumMember member : this.enumType.getMembers()) {
                membersMapLocal.put(member.getName(), new EdmMemberImpl(this.edm, member));
                memberNamesLocal.add(member.getName());
            }
            this.membersMap = membersMapLocal;
            this.memberNames = memberNamesLocal;
        }
    }

    @Override
    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return this.equals(primitiveType);
    }

    @Override
    public Class<?> getDefaultType() {
        return this.getUnderlyingType().getDefaultType();
    }

    @Override
    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        try {
            this.valueOfString(value, isNullable, maxLength, precision, scale, isUnicode, this.getDefaultType());
            return true;
        }
        catch (EdmPrimitiveTypeException e) {
            return false;
        }
    }

    private Long parseEnumValue(String value) throws EdmPrimitiveTypeException {
        Long result = null;
        for (String memberValue : value.split(",", this.isFlags() ? -1 : 1)) {
            Long memberValueLong = null;
            long count = 0L;
            for (EdmMember member : this.getMembers()) {
                ++count;
                if (!memberValue.equals(member.getName()) && !memberValue.equals(member.getValue())) continue;
                memberValueLong = member.getValue() == null ? count - 1L : Long.decode(member.getValue());
            }
            if (memberValueLong == null) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
            result = result == null ? memberValueLong : result | memberValueLong;
        }
        return result;
    }

    @Override
    public <T> T valueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && !isNullable.booleanValue()) {
                throw new EdmPrimitiveTypeException("The literal 'null' is not allowed.");
            }
            return null;
        }
        try {
            return EdmInt64.convertNumber(this.parseEnumValue(value), returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".", e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", e);
        }
    }

    private String constructEnumValue(long value) throws EdmPrimitiveTypeException {
        long remaining = value;
        StringBuilder result = new StringBuilder();
        boolean flags = this.isFlags();
        long memberValue = -1L;
        for (EdmMember member : this.getMembers()) {
            long l = memberValue = member.getValue() == null ? memberValue + 1L : Long.parseLong(member.getValue());
            if (flags) {
                if ((memberValue & remaining) != memberValue) continue;
                if (result.length() > 0) {
                    result.append(',');
                }
                result.append(member.getName());
                remaining ^= memberValue;
                continue;
            }
            if (value != memberValue) continue;
            return member.getName();
        }
        if (remaining != 0L) {
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        return result.toString();
    }

    private Collection<EdmMember> getMembers() {
        if (this.membersMap == null) {
            this.createEdmMembers();
        }
        return this.membersMap.values();
    }

    @Override
    public String valueToString(Object value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && !isNullable.booleanValue()) {
                throw new EdmPrimitiveTypeException("The value NULL is not allowed.");
            }
            return null;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return this.constructEnumValue(((Number)value).longValue());
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }

    @Override
    public String toUriLiteral(String literal) {
        return literal == null ? null : this.enumName.getFullQualifiedNameAsString() + "'" + literal + "'";
    }

    @Override
    public String fromUriLiteral(String literal) throws EdmPrimitiveTypeException {
        if (literal == null) {
            return null;
        }
        String uriPrefix = this.enumName.getFullQualifiedNameAsString() + "'";
        String uriSuffix = "'";
        if (literal.length() >= uriPrefix.length() + uriSuffix.length() && literal.startsWith(uriPrefix) && literal.endsWith(uriSuffix)) {
            return literal.substring(uriPrefix.length(), literal.length() - uriSuffix.length());
        }
        if (literal.endsWith(uriSuffix)) {
            int indexSingleQuote = literal.indexOf(39);
            String fqn = literal.substring(0, indexSingleQuote);
            FullQualifiedName typeFqn = null;
            try {
                typeFqn = new FullQualifiedName(fqn);
            }
            catch (IllegalArgumentException e) {
                throw new EdmPrimitiveTypeException("The literal '" + literal + "' has illegal content.", e);
            }
            EdmEnumType prospect = this.edm.getEnumType(typeFqn);
            if (prospect != null && this.enumName.equals(prospect.getFullQualifiedName()) && literal.length() >= fqn.length() + 2) {
                return literal.substring(fqn.length() + 1, literal.length() - 1);
            }
        }
        throw new EdmPrimitiveTypeException("The literal '" + literal + "' has illegal content.");
    }

    @Override
    public boolean isFlags() {
        return this.enumType.isFlags();
    }

    public int hashCode() {
        return this.getFullQualifiedName().getFullQualifiedNameAsString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && (obj == this || obj instanceof EdmEnumType && this.getFullQualifiedName().equals(((EdmEnumType)obj).getFullQualifiedName()));
    }
}

