/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.annotation.EdmCollection;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCollection;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmDynamicExpression;

public class EdmCollectionImpl
extends AbstractEdmDynamicExpression
implements EdmCollection {
    private List<EdmExpression> items;
    private CsdlCollection csdlCollection;

    public EdmCollectionImpl(Edm edm, CsdlCollection csdlExp) {
        super(edm, "Collection");
        this.csdlCollection = csdlExp;
    }

    @Override
    public List<EdmExpression> getItems() {
        if (this.items == null) {
            ArrayList<EdmExpression> localItems = new ArrayList<EdmExpression>();
            if (this.csdlCollection.getItems() != null) {
                for (CsdlExpression item : this.csdlCollection.getItems()) {
                    localItems.add(EdmCollectionImpl.getExpression(this.edm, item));
                }
            }
            this.items = Collections.unmodifiableList(localItems);
        }
        return this.items;
    }

    @Override
    public EdmExpression.EdmExpressionType getExpressionType() {
        return EdmExpression.EdmExpressionType.Collection;
    }
}

