/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.batchhandler.referenceRewriting;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;

public class BatchReferenceRewriter {
    private static final String REG_EX_REFERENCE = "\\$(.*)(/.*)?";
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$(.*)(/.*)?");
    private Map<String, String> contentIdMapping = new HashMap<String, String>();

    public String getReferenceInURI(ODataRequest request) {
        Matcher matcher = REFERENCE_PATTERN.matcher(this.removeSlash(this.removeSlash(request.getRawODataPath(), true), false));
        return matcher.matches() ? matcher.group(1) : null;
    }

    public void replaceReference(ODataRequest request) {
        String reference = this.getReferenceInURI(request);
        if (reference != null) {
            String replacement = this.contentIdMapping.get(reference);
            if (replacement != null) {
                this.replaceContentIdReference(request, reference, replacement);
            } else {
                throw new ODataRuntimeException("Required Content-Id for reference \"" + reference + "\" not found.");
            }
        }
    }

    private void replaceContentIdReference(ODataRequest request, String contentId, String resourceUri) {
        String newUri = request.getRawODataPath().replace("/$" + contentId, resourceUri);
        request.setRawODataPath(newUri);
        request.setRawRequestUri(request.getRawBaseUri() + "/" + newUri);
    }

    public void addMapping(ODataRequest request, ODataResponse response) throws BatchDeserializerException {
        String resourceUri = this.getODataPath(request, response);
        String contentId = request.getHeader("Content-ID");
        this.contentIdMapping.put(contentId, resourceUri);
    }

    private String getODataPath(ODataRequest request, ODataResponse response) throws BatchDeserializerException {
        String locationHeader;
        String resourceUri = null;
        resourceUri = request.getMethod() == HttpMethod.POST ? ((locationHeader = response.getHeader("Location")) == null ? null : this.parseODataPath(locationHeader, request.getRawBaseUri())) : request.getRawODataPath();
        return resourceUri;
    }

    private String parseODataPath(String uri, String rawBaseUri) throws BatchDeserializerException {
        if (uri.indexOf(rawBaseUri) == 0) {
            return uri.substring(rawBaseUri.length());
        }
        throw new BatchDeserializerException("Invalid base uri or uri", BatchDeserializerException.MessageKeys.INVALID_URI, "0");
    }

    private String removeSlash(String rawODataPath, boolean first) {
        int indexOfSlash = rawODataPath.indexOf(47);
        if (first) {
            return indexOfSlash == 0 ? rawODataPath.substring(1) : rawODataPath;
        }
        return indexOfSlash != -1 ? rawODataPath.substring(0, indexOfSlash) : rawODataPath;
    }
}

