/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser.search;

import java.util.Iterator;
import java.util.List;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.search.SearchBinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.search.SearchExpression;
import org.apache.olingo.server.api.uri.queryoption.search.SearchTerm;
import org.apache.olingo.server.core.uri.parser.search.SearchBinaryImpl;
import org.apache.olingo.server.core.uri.parser.search.SearchParserException;
import org.apache.olingo.server.core.uri.parser.search.SearchQueryToken;
import org.apache.olingo.server.core.uri.parser.search.SearchTermImpl;
import org.apache.olingo.server.core.uri.parser.search.SearchTokenizer;
import org.apache.olingo.server.core.uri.parser.search.SearchTokenizerException;
import org.apache.olingo.server.core.uri.parser.search.SearchUnaryImpl;
import org.apache.olingo.server.core.uri.queryoption.SearchOptionImpl;

public class SearchParser {
    private Iterator<SearchQueryToken> tokens;
    private SearchQueryToken token;

    public SearchOption parse(String searchQuery) throws SearchParserException, SearchTokenizerException {
        SearchExpression searchExpression;
        SearchTokenizer tokenizer = new SearchTokenizer();
        try {
            searchExpression = this.parse(tokenizer.tokenize(searchQuery));
        }
        catch (SearchTokenizerException e) {
            String message = e.getMessage();
            throw new SearchParserException("Tokenizer exception with message: " + message, (Throwable)e, SearchParserException.MessageKeys.TOKENIZER_EXCEPTION, message);
        }
        SearchOptionImpl searchOption = new SearchOptionImpl();
        searchOption.setSearchExpression(searchExpression);
        return searchOption;
    }

    protected SearchExpression parse(List<SearchQueryToken> tokens) throws SearchParserException {
        this.tokens = tokens.iterator();
        this.nextToken();
        if (this.token == null) {
            throw new SearchParserException("No search String", SearchParserException.MessageKeys.NO_EXPRESSION_FOUND, new String[0]);
        }
        SearchExpression searchExpression = this.processSearchExpression();
        if (!this.isEof()) {
            throw new SearchParserException("Token left after end of search query parsing.", SearchParserException.MessageKeys.INVALID_END_OF_QUERY, this.getTokenAsString());
        }
        return searchExpression;
    }

    private SearchExpression processSearchExpression() throws SearchParserException {
        return this.processExprOr();
    }

    private SearchExpression processExprOr() throws SearchParserException {
        SearchExpression left = this.processExprAnd();
        while (this.isToken(SearchQueryToken.Token.OR)) {
            this.nextToken();
            SearchExpression right = this.processExprAnd();
            left = new SearchBinaryImpl(left, SearchBinaryOperatorKind.OR, right);
        }
        return left;
    }

    private SearchExpression processExprAnd() throws SearchParserException {
        SearchExpression left = this.processTerm();
        while (this.isToken(SearchQueryToken.Token.AND) || this.isTerm()) {
            if (this.isToken(SearchQueryToken.Token.AND)) {
                this.nextToken();
            }
            SearchExpression right = this.processTerm();
            left = new SearchBinaryImpl(left, SearchBinaryOperatorKind.AND, right);
        }
        return left;
    }

    private SearchExpression processTerm() throws SearchParserException {
        if (this.isToken(SearchQueryToken.Token.OPEN)) {
            this.nextToken();
            SearchExpression expr = this.processExprOr();
            this.processClose();
            return expr;
        }
        if (this.isToken(SearchQueryToken.Token.NOT)) {
            return this.processNot();
        }
        return this.processWordOrPhrase();
    }

    private void processClose() throws SearchParserException {
        if (!this.isToken(SearchQueryToken.Token.CLOSE)) {
            throw new SearchParserException("Missing close bracket after open bracket.", SearchParserException.MessageKeys.MISSING_CLOSE, new String[0]);
        }
        this.nextToken();
    }

    private SearchExpression processNot() throws SearchParserException {
        this.nextToken();
        if (this.isToken(SearchQueryToken.Token.WORD) || this.isToken(SearchQueryToken.Token.PHRASE)) {
            return new SearchUnaryImpl(this.processWordOrPhrase());
        }
        String tokenAsString = this.getTokenAsString();
        throw new SearchParserException("NOT must be followed by a term not a " + tokenAsString, SearchParserException.MessageKeys.INVALID_NOT_OPERAND, tokenAsString);
    }

    private SearchTerm processWordOrPhrase() throws SearchParserException {
        if (this.isToken(SearchQueryToken.Token.PHRASE)) {
            return this.processPhrase();
        }
        if (this.isToken(SearchQueryToken.Token.WORD)) {
            return this.processWord();
        }
        String tokenName = this.getTokenAsString();
        throw new SearchParserException("Expected PHRASE||WORD found: " + tokenName, SearchParserException.MessageKeys.EXPECTED_DIFFERENT_TOKEN, SearchQueryToken.Token.PHRASE.name() + SearchQueryToken.Token.WORD.name(), tokenName);
    }

    private SearchTerm processWord() {
        String literal = this.token.getLiteral();
        this.nextToken();
        return new SearchTermImpl(literal);
    }

    private SearchTerm processPhrase() {
        String literal = this.token.getLiteral();
        this.nextToken();
        return new SearchTermImpl(literal.substring(1, literal.length() - 1));
    }

    private boolean isTerm() {
        return this.isToken(SearchQueryToken.Token.NOT) || this.isToken(SearchQueryToken.Token.PHRASE) || this.isToken(SearchQueryToken.Token.WORD) || this.isToken(SearchQueryToken.Token.OPEN);
    }

    private boolean isEof() {
        return this.token == null;
    }

    private boolean isToken(SearchQueryToken.Token toCheckToken) {
        return this.token != null && this.token.getToken() == toCheckToken;
    }

    private void nextToken() {
        this.token = this.tokens.hasNext() ? this.tokens.next() : null;
    }

    private String getTokenAsString() {
        return this.token == null ? "<EOF>" : this.token.getToken().name();
    }
}

