/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.olingo.client.core.edm.xml;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.edm.geo.SRID;

// Internal usage only
public class EdmFacetValuesParserHelper {

	private EdmFacetValuesParserHelper() {
		//hidden
	}

	public static Integer parseMaxLength(String from) {
		return "max".equalsIgnoreCase(from) ? Integer.MAX_VALUE : Integer.parseInt(from);
	}

	public static Integer parsePrecision(String from) {
		return Integer.parseInt(from);
	}

	public static Integer parseScale(String from) {
		if ("variable".equalsIgnoreCase(from)) {
			return Constants.VARIABLE_SCALE;
		} else if ("floating".equalsIgnoreCase(from)) {
			return 0;
		} else {
			return Integer.parseInt(from);
		}
	}

	public static boolean parseIsUnicode(String from) {
		//NB: More advanced than Boolean.parseBoolean()
		return BooleanUtils.toBoolean(from);
	}

	public static SRID parseSrid(String from) {
		return from != null ? SRID.valueOf(from) : null;
	}
}
