/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataPropertyUpdateRequest;
import org.apache.olingo.client.api.communication.response.ODataPropertyUpdateResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataPropertyUpdateRequestImpl
extends AbstractODataBasicRequest<ODataPropertyUpdateResponse>
implements ODataPropertyUpdateRequest {
    private final ClientProperty property;

    ODataPropertyUpdateRequestImpl(ODataClient odataClient, HttpMethod method, URI targetURI, ClientProperty property) {
        super(odataClient, method, targetURI);
        this.property = property;
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultFormat();
    }

    @Override
    public ODataPropertyUpdateResponse execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataPropertyUpdateResponseImpl oDataPropertyUpdateResponseImpl = new ODataPropertyUpdateResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataPropertyUpdateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    public InputStream getPayload() {
        try {
            return this.odataClient.getWriter().writeProperty(this.property, ContentType.parse(this.getContentType()));
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private class ODataPropertyUpdateResponseImpl
    extends AbstractODataResponse
    implements ODataPropertyUpdateResponse {
        private ClientProperty resProperty;

        private ODataPropertyUpdateResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.resProperty = null;
        }

        @Override
        public ClientProperty getBody() {
            if (this.resProperty == null) {
                try {
                    ResWrap<Property> resource = this.odataClient.getDeserializer(ContentType.parse(ODataPropertyUpdateRequestImpl.this.getAccept())).toProperty(this.getRawResponse());
                    this.resProperty = this.odataClient.getBinder().getODataProperty(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.resProperty;
        }
    }
}

