/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.apache.olingo.commons.api.IConstants;
import org.apache.olingo.commons.api.constants.Constantsv00;
import org.apache.olingo.commons.api.constants.Constantsv01;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHandler;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.debug.DebugResponseHelper;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.FixedFormatDeserializer;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.etag.ETagHelper;
import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializer;
import org.apache.olingo.server.api.serializer.EdmDeltaSerializer;
import org.apache.olingo.server.api.serializer.FixedFormatSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.core.ODataHandlerImpl;
import org.apache.olingo.server.core.ODataHttpHandlerImpl;
import org.apache.olingo.server.core.ServiceMetadataImpl;
import org.apache.olingo.server.core.debug.DebugResponseHelperImpl;
import org.apache.olingo.server.core.debug.ServerCoreDebugger;
import org.apache.olingo.server.core.deserializer.FixedFormatDeserializerImpl;
import org.apache.olingo.server.core.deserializer.json.ODataJsonDeserializer;
import org.apache.olingo.server.core.etag.ETagHelperImpl;
import org.apache.olingo.server.core.prefer.PreferencesImpl;
import org.apache.olingo.server.core.serializer.FixedFormatSerializerImpl;
import org.apache.olingo.server.core.serializer.json.EdmAssistedJsonSerializer;
import org.apache.olingo.server.core.serializer.json.JsonDeltaSerializer;
import org.apache.olingo.server.core.serializer.json.JsonDeltaSerializerWithNavigations;
import org.apache.olingo.server.core.serializer.json.ODataJsonSerializer;
import org.apache.olingo.server.core.serializer.xml.ODataXmlSerializer;
import org.apache.olingo.server.core.uri.UriHelperImpl;

public class ODataImpl
extends OData {
    @Override
    public ODataSerializer createSerializer(ContentType contentType) throws SerializerException {
        ODataSerializer serializer = null;
        if (contentType != null && contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            String metadata = contentType.getParameter("odata.metadata");
            if (metadata == null || "minimal".equalsIgnoreCase(metadata) || "none".equalsIgnoreCase(metadata) || "full".equalsIgnoreCase(metadata)) {
                serializer = new ODataJsonSerializer(contentType, new Constantsv00());
            }
        } else if (contentType != null && (contentType.isCompatible(ContentType.APPLICATION_XML) || contentType.isCompatible(ContentType.APPLICATION_ATOM_XML))) {
            serializer = new ODataXmlSerializer();
        }
        if (serializer == null) {
            throw new SerializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), SerializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
        }
        return serializer;
    }

    @Override
    public ODataSerializer createSerializer(ContentType contentType, List<String> versions) throws SerializerException {
        ODataSerializer serializer = null;
        IConstants constants = new Constantsv00();
        if (versions != null && !versions.isEmpty() && this.getMaxVersion(versions) > 4.0f) {
            constants = new Constantsv01();
        }
        if (contentType != null && contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            String metadata = contentType.getParameter("odata.metadata");
            if (metadata == null || "minimal".equalsIgnoreCase(metadata) || "none".equalsIgnoreCase(metadata) || "full".equalsIgnoreCase(metadata)) {
                serializer = new ODataJsonSerializer(contentType, constants);
            }
        } else if (contentType != null && (contentType.isCompatible(ContentType.APPLICATION_XML) || contentType.isCompatible(ContentType.APPLICATION_ATOM_XML))) {
            serializer = new ODataXmlSerializer();
        }
        if (serializer == null) {
            throw new SerializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), SerializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
        }
        return serializer;
    }

    @Override
    public FixedFormatSerializer createFixedFormatSerializer() {
        return new FixedFormatSerializerImpl();
    }

    @Override
    public EdmAssistedSerializer createEdmAssistedSerializer(ContentType contentType) throws SerializerException {
        if (contentType != null && contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            return new EdmAssistedJsonSerializer(contentType);
        }
        throw new SerializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), SerializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
    }

    @Override
    public EdmAssistedSerializer createEdmAssistedSerializer(ContentType contentType, List<String> versions) throws SerializerException {
        IConstants constants = new Constantsv00();
        if (versions != null && !versions.isEmpty() && this.getMaxVersion(versions) > 4.0f) {
            constants = new Constantsv01();
        }
        if (contentType != null && contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            return new EdmAssistedJsonSerializer(contentType, constants);
        }
        throw new SerializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), SerializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
    }

    @Override
    public EdmDeltaSerializer createEdmDeltaSerializer(ContentType contentType, List<String> versions) throws SerializerException {
        if (contentType != null && contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            if (versions != null && !versions.isEmpty()) {
                return this.getMaxVersion(versions) > 4.0f ? new JsonDeltaSerializerWithNavigations(contentType) : new JsonDeltaSerializer(contentType);
            }
            return new JsonDeltaSerializerWithNavigations(contentType);
        }
        throw new SerializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), SerializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
    }

    private float getMaxVersion(List<String> versions) {
        Float[] versionValue = new Float[versions.size()];
        int i = 0;
        Float max = Float.valueOf(0.0f);
        for (String version : versions) {
            Float ver = Float.valueOf(version);
            versionValue[i++] = ver;
            max = max.floatValue() > ver.floatValue() ? max : ver;
        }
        return max.floatValue();
    }

    @Override
    public ODataHttpHandler createHandler(ServiceMetadata serviceMetadata) {
        return new ODataHttpHandlerImpl(this, serviceMetadata);
    }

    @Override
    public ODataHandler createRawHandler(ServiceMetadata serviceMetadata) {
        return new ODataHandlerImpl(this, serviceMetadata, new ServerCoreDebugger(this));
    }

    @Override
    public ServiceMetadata createServiceMetadata(CsdlEdmProvider edmProvider, List<EdmxReference> references) {
        return this.createServiceMetadata(edmProvider, references, null);
    }

    @Override
    public ServiceMetadata createServiceMetadata(CsdlEdmProvider edmProvider, List<EdmxReference> references, ServiceMetadataETagSupport serviceMetadataETagSupport) {
        return new ServiceMetadataImpl(edmProvider, references, serviceMetadataETagSupport);
    }

    @Override
    public FixedFormatDeserializer createFixedFormatDeserializer() {
        return new FixedFormatDeserializerImpl();
    }

    @Override
    public UriHelper createUriHelper() {
        return new UriHelperImpl();
    }

    @Override
    public ODataDeserializer createDeserializer(ContentType contentType) throws DeserializerException {
        if (contentType != null && contentType.isCompatible(ContentType.JSON)) {
            return new ODataJsonDeserializer(contentType);
        }
        throw new DeserializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), DeserializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
    }

    @Override
    public ODataDeserializer createDeserializer(ContentType contentType, ServiceMetadata metadata) throws DeserializerException {
        if (contentType != null && contentType.isCompatible(ContentType.JSON)) {
            return new ODataJsonDeserializer(contentType, metadata);
        }
        throw new DeserializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), DeserializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
    }

    @Override
    public ODataDeserializer createDeserializer(ContentType contentType, List<String> versions) throws DeserializerException {
        IConstants constants = new Constantsv00();
        if (versions != null && !versions.isEmpty() && this.getMaxVersion(versions) > 4.0f) {
            constants = new Constantsv01();
        }
        if (contentType != null && contentType.isCompatible(ContentType.JSON)) {
            return new ODataJsonDeserializer(contentType, constants);
        }
        throw new DeserializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), DeserializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
    }

    @Override
    public ODataDeserializer createDeserializer(ContentType contentType, ServiceMetadata metadata, List<String> versions) throws DeserializerException {
        IConstants constants = new Constantsv00();
        if (versions != null && !versions.isEmpty() && this.getMaxVersion(versions) > 4.0f) {
            constants = new Constantsv01();
        }
        if (contentType != null && contentType.isCompatible(ContentType.JSON)) {
            return new ODataJsonDeserializer(contentType, metadata, constants);
        }
        throw new DeserializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), DeserializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
    }

    @Override
    public EdmPrimitiveType createPrimitiveTypeInstance(EdmPrimitiveTypeKind kind) {
        return EdmPrimitiveTypeFactory.getInstance(kind);
    }

    @Override
    public ETagHelper createETagHelper() {
        return new ETagHelperImpl();
    }

    @Override
    public Preferences createPreferences(Collection<String> preferHeaders) {
        return new PreferencesImpl(preferHeaders);
    }

    @Override
    public DebugResponseHelper createDebugResponseHelper(String debugFormat) {
        return new DebugResponseHelperImpl(debugFormat);
    }

    @Override
    public ODataSerializer createRxSerializer(ContentType contentType) throws SerializerException {
        ODataSerializer serializer = null;
        String serJson = "org.apache.olingo.server.rx.serializer.json.ODataJsonRxSerializer";
        try {
            String metadata;
            if (contentType.isCompatible(ContentType.APPLICATION_JSON) && ((metadata = contentType.getParameter("odata.metadata")) == null || "minimal".equalsIgnoreCase(metadata) || "none".equalsIgnoreCase(metadata) || "full".equalsIgnoreCase(metadata))) {
                Class<?> clazz = Class.forName("org.apache.olingo.server.rx.serializer.json.ODataJsonRxSerializer");
                Constructor<?> cons = clazz.getConstructor(ContentType.class);
                serializer = (ODataSerializer)cons.newInstance(contentType);
            }
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage() + (contentType != null ? contentType.toContentTypeString() : null), (Throwable)e, SerializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
        }
        if (serializer == null) {
            throw new SerializerException("Unsupported format: " + (contentType != null ? contentType.toContentTypeString() : null), SerializerException.MessageKeys.UNSUPPORTED_FORMAT, contentType != null ? contentType.toContentTypeString() : null);
        }
        return serializer;
    }
}

