/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.domain.AbstractClientValue;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientProperty;

public class ClientComplexValueImpl
extends AbstractClientValue
implements ClientComplexValue {
    private final List<ClientLink> navigationLinks = new ArrayList<ClientLink>();
    private final List<ClientLink> associationLinks = new ArrayList<ClientLink>();
    private final List<ClientAnnotation> annotations = new ArrayList<ClientAnnotation>();
    private final Map<String, ClientProperty> fields = new LinkedHashMap<String, ClientProperty>();

    public ClientComplexValueImpl(String typeName) {
        super(typeName);
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public ClientEnumValue asEnum() {
        return null;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean addLink(ClientLink link) {
        boolean result = false;
        switch (link.getType()) {
            case ASSOCIATION: {
                result = this.associationLinks.contains(link) ? false : this.associationLinks.add(link);
                break;
            }
            case ENTITY_NAVIGATION: 
            case ENTITY_SET_NAVIGATION: {
                result = this.navigationLinks.contains(link) ? false : this.navigationLinks.add(link);
                break;
            }
            case MEDIA_EDIT: 
            case MEDIA_READ: {
                throw new IllegalArgumentException("Complex values cannot have media links!");
            }
        }
        return result;
    }

    @Override
    public boolean removeLink(ClientLink link) {
        return this.associationLinks.remove(link) || this.navigationLinks.remove(link);
    }

    private ClientLink getLink(List<ClientLink> links, String name) {
        ClientLink result = null;
        for (ClientLink link : links) {
            if (!name.equals(link.getName())) continue;
            result = link;
            break;
        }
        return result;
    }

    @Override
    public ClientLink getNavigationLink(String name) {
        return this.getLink(this.navigationLinks, name);
    }

    @Override
    public List<ClientLink> getNavigationLinks() {
        return this.navigationLinks;
    }

    @Override
    public ClientLink getAssociationLink(String name) {
        return this.getLink(this.associationLinks, name);
    }

    @Override
    public List<ClientLink> getAssociationLinks() {
        return this.associationLinks;
    }

    @Override
    public Map<String, Object> asJavaMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ClientProperty> entry : this.fields.entrySet()) {
            Object value = null;
            if (entry.getValue().hasPrimitiveValue()) {
                value = entry.getValue().getPrimitiveValue().toValue();
            } else if (entry.getValue().hasComplexValue()) {
                value = entry.getValue().getComplexValue().asJavaMap();
            } else if (entry.getValue().hasCollectionValue()) {
                value = entry.getValue().getCollectionValue().asJavaCollection();
            } else if (entry.getValue().hasEnumValue()) {
                value = entry.getValue().getEnumValue().toString();
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    @Override
    public List<ClientAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ClientComplexValue add(ClientProperty field) {
        this.fields.put(field.getName(), field);
        return this;
    }

    @Override
    public ClientProperty get(String name) {
        return this.fields.get(name);
    }

    @Override
    public Iterator<ClientProperty> iterator() {
        return this.fields.values().iterator();
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.annotations.hashCode();
        result = 31 * result + this.associationLinks.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.navigationLinks.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClientComplexValueImpl)) {
            return false;
        }
        ClientComplexValueImpl other = (ClientComplexValueImpl)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.associationLinks == null ? other.associationLinks != null : !this.associationLinks.equals(other.associationLinks)) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        return !(this.navigationLinks == null ? other.navigationLinks != null : !this.navigationLinks.equals(other.navigationLinks));
    }

    @Override
    public String toString() {
        return "ClientComplexValueImpl [navigationLinks=" + this.navigationLinks + ", associationLinks=" + this.associationLinks + ", annotations=" + this.annotations + ", fields=" + this.fields + "super[" + super.toString() + "]]";
    }
}

