/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

abstract class AbstractPrimitiveType
implements EdmPrimitiveType {
    protected String uriPrefix = "";
    protected String uriSuffix = "";
    protected FullQualifiedName fqn = new FullQualifiedName(this.getNamespace(), this.getName());

    protected AbstractPrimitiveType() {
    }

    @Override
    public FullQualifiedName getFullQualifiedName() {
        return this.fqn;
    }

    @Override
    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return this.equals(primitiveType);
    }

    @Override
    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        try {
            this.valueOfString(value, isNullable, maxLength, precision, scale, isUnicode, this.getDefaultType());
            return true;
        }
        catch (EdmPrimitiveTypeException e) {
            return false;
        }
    }

    @Override
    public final <T> T valueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && !isNullable.booleanValue()) {
                throw new EdmPrimitiveTypeException("The literal 'null' is not allowed.");
            }
            return null;
        }
        return this.internalValueOfString(value, isNullable, maxLength, precision, scale, isUnicode, returnType);
    }

    protected abstract <T> T internalValueOfString(String var1, Boolean var2, Integer var3, Integer var4, Integer var5, Boolean var6, Class<T> var7) throws EdmPrimitiveTypeException;

    @Override
    public final String valueToString(Object value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value == null) {
            if (isNullable != null && !isNullable.booleanValue()) {
                throw new EdmPrimitiveTypeException("The value NULL is not allowed.");
            }
            return null;
        }
        return this.internalValueToString(value, isNullable, maxLength, precision, scale, isUnicode);
    }

    protected abstract <T> String internalValueToString(T var1, Boolean var2, Integer var3, Integer var4, Integer var5, Boolean var6) throws EdmPrimitiveTypeException;

    @Override
    public String toUriLiteral(String literal) {
        return literal == null ? null : (this.uriPrefix.isEmpty() && this.uriSuffix.isEmpty() ? literal : this.uriPrefix + literal + this.uriSuffix);
    }

    @Override
    public String fromUriLiteral(String literal) throws EdmPrimitiveTypeException {
        if (literal == null) {
            return null;
        }
        if (this.uriPrefix.isEmpty() && this.uriSuffix.isEmpty()) {
            return literal;
        }
        if (literal.length() >= this.uriPrefix.length() + this.uriSuffix.length() && literal.startsWith(this.uriPrefix) && literal.endsWith(this.uriSuffix)) {
            return literal.substring(this.uriPrefix.length(), literal.length() - this.uriSuffix.length());
        }
        throw new EdmPrimitiveTypeException("The literal '" + literal + "' has illegal content.");
    }

    public String toString() {
        return this.getFullQualifiedName().getFullQualifiedNameAsString();
    }
}

