/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.metadatavalidator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class EdmTypeValidator {
    private Map<String, String> aliasNamespaceMap = new HashMap<String, String>();
    private Map<FullQualifiedName, EdmEntityContainer> edmContainersMap = new HashMap<FullQualifiedName, EdmEntityContainer>();
    private Map<FullQualifiedName, EdmEntityType> edmEntityTypesMap = new HashMap<FullQualifiedName, EdmEntityType>();
    private Map<FullQualifiedName, EdmComplexType> edmComplexTypesMap = new HashMap<FullQualifiedName, EdmComplexType>();
    private Map<FullQualifiedName, EdmFunction> edmFunctionsMap = new HashMap<FullQualifiedName, EdmFunction>();

    public EdmTypeValidator(Map<String, String> aliasNamespaceMap, Map<FullQualifiedName, EdmEntityContainer> edmContainersMap, Map<FullQualifiedName, EdmEntityType> edmEntityTypesMap, Map<FullQualifiedName, EdmComplexType> edmComplexTypesMap, Map<FullQualifiedName, EdmFunction> edmFunctionsMap) {
        this.aliasNamespaceMap = aliasNamespaceMap;
        this.edmContainersMap = edmContainersMap;
        this.edmEntityTypesMap = edmEntityTypesMap;
        this.edmComplexTypesMap = edmComplexTypesMap;
        this.edmFunctionsMap = edmFunctionsMap;
    }

    public void validateEdm() {
        this.validateEdmEntityTypes();
        this.validateEdmEntitySet();
        this.validateEdmFunctionImport();
    }

    private void validateEdmEntityTypes() {
        for (Map.Entry<FullQualifiedName, EdmEntityType> entityTypes : this.edmEntityTypesMap.entrySet()) {
            if (entityTypes.getValue() == null || entityTypes.getKey() == null) continue;
            EdmEntityType entityType = entityTypes.getValue();
            if (entityType.getBaseType() != null) {
                FullQualifiedName baseTypeFQName = entityType.getBaseType().getFullQualifiedName();
                EdmEntityType baseEntityType = this.edmEntityTypesMap.get(baseTypeFQName);
                if (baseEntityType == null || !baseEntityType.getKeyPredicateNames().isEmpty()) continue;
                throw new RuntimeException("Missing key for EntityType " + baseEntityType.getName());
            }
            if (!entityType.getKeyPredicateNames().isEmpty()) continue;
            throw new RuntimeException("Missing key for EntityType " + entityType.getName());
        }
    }

    private void validateEdmEntitySet() {
        for (Map.Entry<FullQualifiedName, EdmEntityContainer> container : this.edmContainersMap.entrySet()) {
            for (EdmEntitySet entitySet : container.getValue().getEntitySets()) {
                this.validateNavigationBindingPaths(entitySet);
            }
        }
    }

    private void validateNavigationBindingPaths(EdmEntitySet entitySet) {
        List<EdmNavigationPropertyBinding> navigationPropertyBindings = entitySet.getNavigationPropertyBindings();
        if (!navigationPropertyBindings.isEmpty()) {
            for (EdmNavigationPropertyBinding navigationPropertyBinding : navigationPropertyBindings) {
                String navBindingPath = navigationPropertyBinding.getPath();
                EdmBindingTarget edmBindingTarget = entitySet.getRelatedBindingTarget(navBindingPath);
                EdmEntityType sourceEntityType = this.edmEntityTypesMap.get(entitySet.getEntityType().getFullQualifiedName());
                if (edmBindingTarget instanceof EdmSingleton) {
                    throw new RuntimeException("Validations of Singletons are not supported: " + edmBindingTarget.getName());
                }
                EdmEntityType targetEntityType = edmBindingTarget.getEntityType();
                EdmNavigationProperty navProperty = null;
                navProperty = navBindingPath.contains("/") ? this.findLastQualifiedNameHavingNavigationProperty(navBindingPath, sourceEntityType) : (EdmNavigationProperty)sourceEntityType.getProperty(navBindingPath);
                FullQualifiedName navFQName = this.fetchCorrectNamespaceFromAlias(navProperty.getType().getFullQualifiedName());
                this.validateReferentialConstraint(sourceEntityType, targetEntityType, navProperty);
                String targetType = targetEntityType.getFullQualifiedName().getFullQualifiedNameAsString();
                if (navFQName.getFullQualifiedNameAsString().equals(targetType) || navProperty.getType().compatibleTo(targetEntityType)) continue;
                throw new RuntimeException("Navigation Property Type " + navProperty.getType().getFullQualifiedName() + " does not match the binding target type " + targetType);
            }
        }
    }

    private void validateReferentialConstraint(EdmEntityType sourceEntityType, EdmEntityType targetEntityType, EdmNavigationProperty navProperty) {
        if (!navProperty.getReferentialConstraints().isEmpty()) {
            String propertyName = navProperty.getReferentialConstraints().get(0).getPropertyName();
            if (sourceEntityType.getProperty(propertyName) == null) {
                throw new RuntimeException("Property name " + propertyName + " not part of the source entity.");
            }
            String referencedPropertyName = navProperty.getReferentialConstraints().get(0).getReferencedPropertyName();
            if (targetEntityType.getProperty(referencedPropertyName) == null) {
                throw new RuntimeException("Property name " + referencedPropertyName + " not part of the target entity.");
            }
        }
    }

    private EdmNavigationProperty findLastQualifiedNameHavingNavigationProperty(String navBindingPath, EdmEntityType sourceEntityType) {
        EdmEntityType sourceEntityTypeHavingNavProp;
        String[] paths = navBindingPath.split("/");
        String lastFullQualifiedName = "";
        for (String path : paths) {
            if (!path.contains(".")) continue;
            lastFullQualifiedName = path;
        }
        String strNavProperty = paths[paths.length - 1];
        String remainingPath = navBindingPath.substring(navBindingPath.indexOf(lastFullQualifiedName) + lastFullQualifiedName.length() + (lastFullQualifiedName.length() == 0 ? 0 : 1), navBindingPath.lastIndexOf(strNavProperty));
        if (remainingPath.length() > 0) {
            remainingPath = remainingPath.substring(0, remainingPath.length() - 1);
        }
        EdmNavigationProperty navProperty = null;
        EdmEntityType edmEntityType = lastFullQualifiedName.length() == 0 ? sourceEntityType : (sourceEntityTypeHavingNavProp = this.edmEntityTypesMap.containsKey(new FullQualifiedName(lastFullQualifiedName)) ? this.edmEntityTypesMap.get(new FullQualifiedName(lastFullQualifiedName)) : this.edmEntityTypesMap.get(this.fetchCorrectNamespaceFromAlias(new FullQualifiedName(lastFullQualifiedName))));
        if (sourceEntityTypeHavingNavProp == null) {
            EdmComplexType sourceComplexTypeHavingNavProp;
            EdmComplexType edmComplexType = sourceComplexTypeHavingNavProp = this.edmComplexTypesMap.containsKey(new FullQualifiedName(lastFullQualifiedName)) ? this.edmComplexTypesMap.get(new FullQualifiedName(lastFullQualifiedName)) : this.edmComplexTypesMap.get(this.fetchCorrectNamespaceFromAlias(new FullQualifiedName(lastFullQualifiedName)));
            if (sourceComplexTypeHavingNavProp == null) {
                throw new RuntimeException("The fully Qualified type " + lastFullQualifiedName + " mentioned in navigation binding path not found ");
            }
            navProperty = remainingPath.length() > 0 ? this.fetchNavigationProperty(remainingPath, strNavProperty, sourceComplexTypeHavingNavProp) : sourceComplexTypeHavingNavProp.getNavigationProperty(strNavProperty);
        } else {
            navProperty = remainingPath.length() > 0 ? this.fetchNavigationProperty(remainingPath, strNavProperty, sourceEntityTypeHavingNavProp) : sourceEntityTypeHavingNavProp.getNavigationProperty(strNavProperty);
        }
        return navProperty;
    }

    private EdmNavigationProperty fetchNavigationProperty(String remainingPath, String strNavProperty, EdmStructuredType sourceTypeHavingNavProp) {
        String[] paths;
        for (String path : paths = remainingPath.split("/")) {
            FullQualifiedName fqName = null;
            if (sourceTypeHavingNavProp instanceof EdmComplexType) {
                fqName = ((EdmComplexType)sourceTypeHavingNavProp).getProperty(path).getType().getFullQualifiedName();
            } else if (sourceTypeHavingNavProp instanceof EdmEntityType) {
                fqName = ((EdmEntityType)sourceTypeHavingNavProp).getProperty(path).getType().getFullQualifiedName();
            }
            if (fqName != null) {
                String namespace = this.aliasNamespaceMap.get(fqName.getNamespace());
                fqName = namespace != null ? new FullQualifiedName(namespace, fqName.getName()) : fqName;
            }
            sourceTypeHavingNavProp = this.edmEntityTypesMap.containsKey(fqName) ? (EdmStructuredType)this.edmEntityTypesMap.get(fqName) : (EdmStructuredType)this.edmComplexTypesMap.get(fqName);
        }
        return sourceTypeHavingNavProp.getNavigationProperty(strNavProperty);
    }

    private FullQualifiedName fetchCorrectNamespaceFromAlias(FullQualifiedName fqName) {
        if (this.aliasNamespaceMap.containsKey(fqName.getNamespace())) {
            String namespace = this.aliasNamespaceMap.get(fqName.getNamespace());
            fqName = new FullQualifiedName(namespace, fqName.getName());
        }
        return fqName;
    }

    private void validateEdmFunctionImport() {
        for (Map.Entry<FullQualifiedName, EdmEntityContainer> container : this.edmContainersMap.entrySet()) {
            for (EdmFunctionImport functionImport : container.getValue().getFunctionImports()) {
                FullQualifiedName fqFunction = functionImport.getFunctionFqn();
                if (this.edmFunctionsMap.containsKey(fqFunction)) continue;
                this.validateEdmFunctionsWithAlias(fqFunction);
            }
        }
    }

    private FullQualifiedName validateEdmFunctionsWithAlias(FullQualifiedName aliasName) {
        String namespace = this.aliasNamespaceMap.get(aliasName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, aliasName.getName());
        if (!this.edmFunctionsMap.containsKey(fqName)) {
            throw new RuntimeException("Invalid Function " + aliasName);
        }
        return fqName;
    }
}

