/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceRef;
import org.apache.olingo.server.api.uri.UriResourceValue;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.QueryOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceStartingTypeFilterImpl;
import org.apache.olingo.server.core.uri.parser.ApplyParser;
import org.apache.olingo.server.core.uri.parser.ExpandParser;
import org.apache.olingo.server.core.uri.parser.FilterParser;
import org.apache.olingo.server.core.uri.parser.OrderByParser;
import org.apache.olingo.server.core.uri.parser.ParserHelper;
import org.apache.olingo.server.core.uri.parser.ResourcePathParser;
import org.apache.olingo.server.core.uri.parser.SelectParser;
import org.apache.olingo.server.core.uri.parser.UriDecoder;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.parser.search.SearchParser;
import org.apache.olingo.server.core.uri.queryoption.AliasQueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.ApplyOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.CountOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.DeltaTokenOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.FilterOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.FormatOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.IdOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.OrderByOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipTokenOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SystemQueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.TopOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.DynamicStructuredType;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class Parser {
    private static final String ATOM = "atom";
    private static final String JSON = "json";
    private static final String XML = "xml";
    private static final String DOLLAR = "$";
    private static final String AT = "@";
    private static final String NULL = "null";
    private static final String ENTITY = "$entity";
    private static final String HTTP = "http";
    private static final String REST = "REST";
    private final Map<String, Object> options;
    private final Edm edm;
    private final OData odata;
    private final String protocolType;
    private boolean keyAsSegment;

    public Parser(Edm edm, OData odata) {
        this(edm, odata, null, Collections.emptyMap());
    }

    public Parser(Edm edm, OData odata, String protocolType, Map<String, Object> options) {
        this.edm = edm;
        this.odata = odata;
        this.protocolType = protocolType;
        this.options = options;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UriInfo parseUri(String path, String query, String fragment, String baseUri) throws UriParserException, UriValidationException {
        void var8_22;
        void var7_15;
        void var7_13;
        String firstSegment;
        UriInfoImpl contextUriInfo = new UriInfoImpl();
        List<Object> options = query == null ? Collections.emptyList() : UriDecoder.splitAndDecodeOptions(query);
        for (QueryOption queryOption : options) {
            String optionName = queryOption.getName();
            String value = queryOption.getText();
            if (UriDecoder.isFormEncoding()) {
                value = this.getFormEncodedValue(value);
            }
            QueryOption parsedOption = this.parseOption(optionName, value);
            try {
                contextUriInfo.setQueryOption(parsedOption == null ? queryOption : parsedOption);
            }
            catch (ODataRuntimeException e) {
                throw new UriParserSyntaxException((String)(parsedOption instanceof SystemQueryOption ? "Double system query option!" : "Alias already specified! Name: " + optionName), (Throwable)e, parsedOption instanceof SystemQueryOption ? UriParserSyntaxException.MessageKeys.DOUBLE_SYSTEM_QUERY_OPTION : UriParserSyntaxException.MessageKeys.DUPLICATED_ALIAS, optionName);
            }
        }
        Object var7_8 = null;
        boolean bl = false;
        List<String> pathSegmentsDecoded = UriDecoder.splitAndDecodePath(path);
        int numberOfSegments = pathSegmentsDecoded.size();
        if (numberOfSegments > 1 && pathSegmentsDecoded.get(0).isEmpty()) {
            pathSegmentsDecoded.remove(0);
            --numberOfSegments;
        }
        if ((firstSegment = pathSegmentsDecoded.get(0)).isEmpty()) {
            this.ensureLastSegment(firstSegment, 1, numberOfSegments);
            contextUriInfo.setKind(UriInfoKind.service);
        } else if ("$batch".equals(firstSegment)) {
            this.ensureLastSegment(firstSegment, 1, numberOfSegments);
            contextUriInfo.setKind(UriInfoKind.batch);
        } else if ("$metadata".equals(firstSegment)) {
            this.ensureLastSegment(firstSegment, 1, numberOfSegments);
            contextUriInfo.setKind(UriInfoKind.metadata);
            contextUriInfo.setFragment(fragment);
        } else if ("$all".equals(firstSegment)) {
            this.ensureLastSegment(firstSegment, 1, numberOfSegments);
            contextUriInfo.setKind(UriInfoKind.all);
            boolean bl2 = true;
        } else if (ENTITY.equals(firstSegment)) {
            if (null == contextUriInfo.getIdOption()) {
                this.ensureLastSegment(firstSegment, 2, numberOfSegments);
                throw new UriParserSyntaxException("The entity-id MUST be specified using the system query option $id", UriParserSyntaxException.MessageKeys.ENTITYID_MISSING_SYSTEM_QUERY_OPTION_ID, new String[0]);
            }
            String idOptionText = contextUriInfo.getIdOption().getText();
            if (idOptionText.startsWith(HTTP)) {
                if (!idOptionText.contains(baseUri = UriDecoder.decode(baseUri))) {
                    throw new UriParserSemanticException("$id cannot have an absolute path", UriParserSemanticException.MessageKeys.NOT_IMPLEMENTED_SYSTEM_QUERY_OPTION, new String[0]);
                }
                idOptionText = idOptionText.substring(baseUri.length() + 1);
            }
            if (numberOfSegments > 1) {
                ResourcePathParser resourcePathParser = new ResourcePathParser(this.edm, contextUriInfo.getAliasMap());
                String typeCastSegment = pathSegmentsDecoded.get(1);
                this.ensureLastSegment(typeCastSegment, 2, numberOfSegments);
                EdmEntityType edmEntityType = resourcePathParser.parseDollarEntityTypeCast(typeCastSegment);
                contextUriInfo = (UriInfoImpl)new Parser(this.edm, this.odata).parseUri("/" + idOptionText, query, fragment, baseUri);
                contextUriInfo.setEntityTypeCast(edmEntityType);
            } else if (numberOfSegments == 1) {
                contextUriInfo = (UriInfoImpl)new Parser(this.edm, this.odata).parseUri("/" + idOptionText, query, fragment, baseUri);
            }
            EdmEntityType edmEntityType = contextUriInfo.getEntityTypeCast();
            contextUriInfo.setKind(UriInfoKind.entityId);
            boolean bl3 = false;
        } else if (firstSegment.startsWith("$crossjoin")) {
            this.ensureLastSegment(firstSegment, 1, numberOfSegments);
            contextUriInfo.setKind(UriInfoKind.crossjoin);
            List<String> entitySetNames = new ResourcePathParser(this.edm, contextUriInfo.getAliasMap()).parseCrossjoinSegment(firstSegment);
            for (String name : entitySetNames) {
                contextUriInfo.addEntitySetName(name);
            }
            boolean bl4 = true;
        } else {
            contextUriInfo.setKind(UriInfoKind.resource);
            ResourcePathParser resourcePathParser = this.protocolType != null && this.protocolType.equalsIgnoreCase(REST) ? new ResourcePathParser(this.edm, contextUriInfo.getAliasMap(), this.protocolType) : new ResourcePathParser(this.edm, contextUriInfo.getAliasMap());
            int count = 0;
            UriResource lastSegment = null;
            ArrayList<UriResource> resourceParts = new ArrayList<UriResource>(pathSegmentsDecoded.size());
            for (String pathSegment : pathSegmentsDecoded) {
                UriResource last;
                ++count;
                if (pathSegment.startsWith(ENTITY)) {
                    throw new UriParserSyntaxException("The entity-id MUST be specified using the system query option $id", UriParserSyntaxException.MessageKeys.ENTITYID_MISSING_SYSTEM_QUERY_OPTION_ID, new String[0]);
                }
                UriResource segment = resourcePathParser.parsePathSegment(pathSegment, lastSegment);
                this.keyAsSegment = resourcePathParser.isKeyAsSegmentMode();
                if (segment == null) continue;
                if (segment instanceof UriResourceCount || segment instanceof UriResourceRef || segment instanceof UriResourceValue) {
                    this.ensureLastSegment(pathSegment, count, numberOfSegments);
                } else if (segment instanceof UriResourceAction || segment instanceof UriResourceFunction && !((UriResourceFunction)segment).getFunction().isComposable()) {
                    if (count < numberOfSegments) {
                        throw new UriValidationException("The segment of an action or of a non-composable function must be the last resource-path segment.", UriValidationException.MessageKeys.UNALLOWED_RESOURCE_PATH, pathSegmentsDecoded.get(count));
                    }
                    lastSegment = segment;
                } else {
                    if (segment instanceof UriResourceStartingTypeFilterImpl) {
                        throw new UriParserSemanticException("First resource-path segment must not be namespace-qualified.", UriParserSemanticException.MessageKeys.NAMESPACE_NOT_ALLOWED_AT_FIRST_ELEMENT, new String[0]);
                    }
                    lastSegment = segment;
                }
                if (this.protocolType != null && this.protocolType.equalsIgnoreCase(REST)) {
                    if (count == 1 && pathSegmentsDecoded.size() > 1 && segment instanceof UriResourceEntitySet || pathSegmentsDecoded.size() > 1 && segment instanceof UriResourceNavigation && ((UriResourceNavigation)segment).getKeyPredicates().isEmpty() && count != pathSegmentsDecoded.size()) continue;
                    resourceParts.add(segment);
                    continue;
                }
                int idx = resourceParts.size() - 1;
                if (this.keyAsSegment && idx >= 0 && ParserHelper.checkSameResource(last = (UriResource)resourceParts.get(idx), segment)) {
                    resourceParts.remove(idx);
                    resourceParts.add(segment);
                    continue;
                }
                resourceParts.add(segment);
            }
            ParserHelper.checkNavigationKeys(resourceParts);
            for (UriResource r : resourceParts) {
                contextUriInfo.addResourcePart(r);
            }
            if (lastSegment instanceof UriResourcePartTyped) {
                UriResourcePartTyped typed = (UriResourcePartTyped)lastSegment;
                EdmType edmType = ParserHelper.getTypeInformation(typed);
                if (edmType != null && (lastSegment instanceof UriResourceEntitySet && (((UriResourceEntitySet)lastSegment).getTypeFilterOnCollection() != null || ((UriResourceEntitySet)lastSegment).getTypeFilterOnEntry() != null) || contextUriInfo.getIdOption() != null) && edmType instanceof EdmEntityType) {
                    contextUriInfo.setEntityTypeCast((EdmEntityType)edmType);
                }
                boolean bl5 = typed.isCollection();
            }
        }
        if (var7_13 instanceof EdmStructuredType && contextUriInfo.getApplyOption() != null) {
            DynamicStructuredType dynamicStructuredType = new DynamicStructuredType((EdmStructuredType)var7_13);
        }
        this.parseApplyOption(contextUriInfo.getApplyOption(), (EdmType)var7_15, contextUriInfo.getEntitySetNames(), contextUriInfo.getAliasMap());
        this.parseFilterOption(contextUriInfo.getFilterOption(), (EdmType)var7_15, contextUriInfo.getEntitySetNames(), contextUriInfo.getAliasMap());
        this.parseOrderByOption(contextUriInfo.getOrderByOption(), (EdmType)var7_15, contextUriInfo.getEntitySetNames(), contextUriInfo.getAliasMap());
        this.parseExpandOption(contextUriInfo.getExpandOption(), (EdmType)var7_15, contextUriInfo.getKind() == UriInfoKind.all, contextUriInfo.getEntitySetNames(), contextUriInfo.getAliasMap());
        this.parseSelectOption(contextUriInfo.getSelectOption(), (EdmType)var7_15, (boolean)var8_22);
        return contextUriInfo;
    }

    private String getFormEncodedValue(String value) {
        if (value.contains("+")) {
            value = value.replaceAll("\\+", " ");
        }
        return value;
    }

    private QueryOption parseOption(String optionName, String optionValue) throws UriParserException, UriValidationException {
        if (optionName.startsWith(DOLLAR)) {
            SystemQueryOptionKind kind = SystemQueryOptionKind.get(optionName);
            if (kind == null) {
                throw new UriParserSyntaxException("Unknown system query option!", UriParserSyntaxException.MessageKeys.UNKNOWN_SYSTEM_QUERY_OPTION, optionName);
            }
            SystemQueryOption systemOption = switch (kind) {
                case SystemQueryOptionKind.SEARCH -> {
                    String searchMode = (String)this.options.getOrDefault("searchMode", "odata-strict");
                    yield new SearchParser(searchMode).parse(optionValue);
                }
                case SystemQueryOptionKind.FILTER -> new FilterOptionImpl();
                case SystemQueryOptionKind.COUNT -> {
                    if ("true".equals(optionValue) || "false".equals(optionValue)) {
                        yield new CountOptionImpl().setValue(Boolean.parseBoolean(optionValue));
                    }
                    throw new UriParserSyntaxException("Illegal value of $count option!", UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION, optionName, optionValue);
                }
                case SystemQueryOptionKind.ORDERBY -> new OrderByOptionImpl();
                case SystemQueryOptionKind.SKIP -> new SkipOptionImpl().setValue(ParserHelper.parseNonNegativeInteger(optionName, optionValue, true));
                case SystemQueryOptionKind.SKIPTOKEN -> {
                    if (optionValue.isEmpty()) {
                        throw new UriParserSyntaxException("Illegal value of $skiptoken option!", UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION, optionName, optionValue);
                    }
                    yield new SkipTokenOptionImpl().setValue(optionValue);
                }
                case SystemQueryOptionKind.DELTATOKEN -> {
                    if (optionValue.isEmpty()) {
                        throw new UriParserSyntaxException("Illegal value of $deltatoken option!", UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION, optionName, optionValue);
                    }
                    yield new DeltaTokenOptionImpl().setValue(optionValue);
                }
                case SystemQueryOptionKind.TOP -> new TopOptionImpl().setValue(ParserHelper.parseNonNegativeInteger(optionName, optionValue, true));
                case SystemQueryOptionKind.EXPAND -> new ExpandOptionImpl();
                case SystemQueryOptionKind.SELECT -> new SelectOptionImpl();
                case SystemQueryOptionKind.FORMAT -> {
                    if (optionValue.equalsIgnoreCase(JSON) || optionValue.equalsIgnoreCase(XML) || optionValue.equalsIgnoreCase(ATOM) || this.isFormatSyntaxValid(optionValue)) {
                        yield new FormatOptionImpl().setFormat(optionValue);
                    }
                    throw new UriParserSyntaxException("Illegal value of $format option!", UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION_FORMAT, optionValue);
                }
                case SystemQueryOptionKind.ID -> {
                    if (optionValue.isEmpty()) {
                        throw new UriParserSyntaxException("Illegal value of $id option!", UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION, optionName, optionValue);
                    }
                    yield new IdOptionImpl().setValue(optionValue);
                }
                case SystemQueryOptionKind.LEVELS -> throw new UriParserSyntaxException("System query option '$levels' is allowed only inside '$expand'!", UriParserSyntaxException.MessageKeys.SYSTEM_QUERY_OPTION_LEVELS_NOT_ALLOWED_HERE, new String[0]);
                case SystemQueryOptionKind.APPLY -> new ApplyOptionImpl();
                default -> throw new UriParserSyntaxException("System query option '" + kind + "' is not known!", UriParserSyntaxException.MessageKeys.UNKNOWN_SYSTEM_QUERY_OPTION, optionName);
            };
            ((SystemQueryOptionImpl)systemOption).setText(optionValue);
            return systemOption;
        }
        if (optionName.startsWith(AT)) {
            return new AliasQueryOptionImpl().setName(optionName).setText(NULL.equals(optionValue) ? null : optionValue);
        }
        return null;
    }

    private void parseFilterOption(FilterOption filterOption, EdmType contextType, List<String> entitySetNames, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        if (filterOption != null) {
            String optionValue = filterOption.getText();
            UriTokenizer filterTokenizer = new UriTokenizer(optionValue);
            ((FilterOptionImpl)filterOption).setExpression(new FilterParser(this.edm, this.odata).parse(filterTokenizer, contextType, entitySetNames, aliases).getExpression());
            this.checkOptionEOF(filterTokenizer, filterOption.getName(), optionValue);
        }
    }

    private void parseOrderByOption(OrderByOption orderByOption, EdmType contextType, List<String> entitySetNames, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        if (orderByOption != null) {
            String optionValue = orderByOption.getText();
            UriTokenizer orderByTokenizer = new UriTokenizer(optionValue);
            OrderByOption option = new OrderByParser(this.edm, this.odata).parse(orderByTokenizer, contextType instanceof EdmStructuredType ? (EdmStructuredType)contextType : null, entitySetNames, aliases);
            this.checkOptionEOF(orderByTokenizer, orderByOption.getName(), optionValue);
            for (OrderByItem item : option.getOrders()) {
                ((OrderByOptionImpl)orderByOption).addOrder(item);
            }
        }
    }

    private void parseExpandOption(ExpandOption expandOption, EdmType contextType, boolean isAll, List<String> entitySetNames, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        if (expandOption != null) {
            if (!(contextType instanceof EdmStructuredType || isAll || entitySetNames != null && !entitySetNames.isEmpty())) {
                throw new UriValidationException("Expand is only allowed on structured types!", UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED, expandOption.getName());
            }
            String optionValue = expandOption.getText();
            UriTokenizer expandTokenizer = new UriTokenizer(optionValue);
            ExpandOption option = new ExpandParser(this.edm, this.odata, aliases, entitySetNames).parse(expandTokenizer, contextType instanceof EdmStructuredType ? (EdmStructuredType)contextType : null);
            this.checkOptionEOF(expandTokenizer, expandOption.getName(), optionValue);
            for (ExpandItem item : option.getExpandItems()) {
                ((ExpandOptionImpl)expandOption).addExpandItem(item);
            }
        }
    }

    private void parseSelectOption(SelectOption selectOption, EdmType contextType, boolean contextIsCollection) throws UriParserException, UriValidationException {
        if (selectOption != null) {
            String optionValue = selectOption.getText();
            UriTokenizer selectTokenizer = new UriTokenizer(optionValue);
            ((SelectOptionImpl)selectOption).setSelectItems(new SelectParser(this.edm).parse(selectTokenizer, contextType instanceof EdmStructuredType ? (EdmStructuredType)contextType : null, contextIsCollection).getSelectItems());
            this.checkOptionEOF(selectTokenizer, selectOption.getName(), optionValue);
        }
    }

    private void parseApplyOption(ApplyOption applyOption, EdmType contextType, List<String> entitySetNames, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        if (applyOption != null) {
            String optionValue = applyOption.getText();
            UriTokenizer applyTokenizer = new UriTokenizer(optionValue);
            ApplyOption option = new ApplyParser(this.edm, this.odata).parse(applyTokenizer, contextType instanceof EdmStructuredType ? (EdmStructuredType)contextType : null, entitySetNames, aliases);
            this.checkOptionEOF(applyTokenizer, applyOption.getName(), optionValue);
            for (ApplyItem item : option.getApplyItems()) {
                ((ApplyOptionImpl)applyOption).add(item);
            }
        }
    }

    private void ensureLastSegment(String segment, int pos, int size) throws UriParserSyntaxException {
        if (pos < size) {
            throw new UriParserSyntaxException(segment + " must be the last segment.", UriParserSyntaxException.MessageKeys.MUST_BE_LAST_SEGMENT, segment);
        }
    }

    private boolean isFormatSyntaxValid(String value) {
        int index = value.indexOf(47);
        return index > 0 && index < value.length() - 1 && index == value.lastIndexOf(47);
    }

    private void checkOptionEOF(UriTokenizer tokenizer, String optionName, String optionValue) throws UriParserException {
        if (!tokenizer.next(UriTokenizer.TokenKind.EOF)) {
            throw new UriParserSyntaxException("Illegal value of '" + optionName + "' option!", UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION, optionName, optionValue);
        }
    }
}

