/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.apache.olingo.client.api.http.HttpUriRequestFactory;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.client.core.http.DefaultHttpUriRequestFactory;
import org.apache.olingo.commons.api.format.ContentType;

public class ConfigurationImpl
implements Configuration {
    private static final String DEFAULT_PUB_FORMAT = "pubFormat";
    private static final String DEFAULT_VALUE_FORMAT = "valueFormat";
    private static final String DEFAULT_BATCH_ACCEPT_FORMAT = "batchAcceptFormat";
    private static final String DEFAULT_MEDIA_FORMAT = "valueFormat";
    private static final String HTTP_CLIENT_FACTORY = "httpClientFactory";
    private static final String HTTP_URI_REQUEST_FACTORY = "httpUriRequestFactory";
    private static final String USE_XHTTP_METHOD = "useHTTPMethod";
    private static final String KEY_AS_SEGMENT = "keyAsSegment";
    private static final String ADDRESS_DERIVED_TYPE = "addressDerivedType";
    private static final String USE_OPERATION_FQN_IN_URL = "useOperationFqnInUrl";
    private static final String GZIP_COMPRESSION = "gzipCompression";
    private static final String CHUNKING = "chunking";
    private static final String CONTINUE_ON_ERROR = "continueOnError";
    public static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private final Map<String, Object> CONF = new HashMap<String, Object>();
    private transient ExecutorService executor = this.createExecutor(10);

    private ExecutorService createExecutor(int threads) {
        ThreadPoolExecutor tp = new ThreadPoolExecutor(threads, threads, 5L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        tp.allowCoreThreadTimeOut(true);
        return tp;
    }

    protected Object getProperty(String key, Object defaultValue) {
        return this.CONF.containsKey(key) ? this.CONF.get(key) : defaultValue;
    }

    protected Object setProperty(String key, Object value) {
        return this.CONF.put(key, value);
    }

    @Override
    public ContentType getDefaultBatchAcceptFormat() {
        return (ContentType)this.getProperty(DEFAULT_BATCH_ACCEPT_FORMAT, ContentType.MULTIPART_MIXED);
    }

    @Override
    public void setDefaultBatchAcceptFormat(ContentType contentType) {
        this.setProperty(DEFAULT_BATCH_ACCEPT_FORMAT, contentType);
    }

    @Override
    public ContentType getDefaultPubFormat() {
        return (ContentType)this.getProperty(DEFAULT_PUB_FORMAT, ContentType.JSON_FULL_METADATA);
    }

    @Override
    public void setDefaultPubFormat(ContentType contentType) {
        this.setProperty(DEFAULT_PUB_FORMAT, contentType);
    }

    @Override
    public ContentType getDefaultFormat() {
        ContentType contenType = this.getDefaultPubFormat();
        return contenType == ContentType.APPLICATION_ATOM_XML ? ContentType.APPLICATION_XML : contenType;
    }

    @Override
    public ContentType getDefaultValueFormat() {
        return (ContentType)this.getProperty("valueFormat", ContentType.TEXT_PLAIN);
    }

    @Override
    public void setDefaultValueFormat(ContentType contentType) {
        this.setProperty("valueFormat", contentType);
    }

    @Override
    public ContentType getDefaultMediaFormat() {
        return (ContentType)this.getProperty("valueFormat", ContentType.APPLICATION_OCTET_STREAM);
    }

    @Override
    public void setDefaultMediaFormat(ContentType contentType) {
        this.setProperty("valueFormat", contentType);
    }

    @Override
    public HttpClientFactory getHttpClientFactory() {
        return (HttpClientFactory)this.getProperty(HTTP_CLIENT_FACTORY, new DefaultHttpClientFactory());
    }

    @Override
    public void setHttpClientFactory(HttpClientFactory factory) {
        this.setProperty(HTTP_CLIENT_FACTORY, factory);
    }

    @Override
    public HttpUriRequestFactory getHttpUriRequestFactory() {
        return (HttpUriRequestFactory)this.getProperty(HTTP_URI_REQUEST_FACTORY, new DefaultHttpUriRequestFactory());
    }

    @Override
    public void setHttpUriRequestFactory(HttpUriRequestFactory factory) {
        this.setProperty(HTTP_URI_REQUEST_FACTORY, factory);
    }

    @Override
    public boolean isUseXHTTPMethod() {
        return (Boolean)this.getProperty(USE_XHTTP_METHOD, false);
    }

    @Override
    public void setUseXHTTPMethod(boolean value) {
        this.setProperty(USE_XHTTP_METHOD, value);
    }

    @Override
    public boolean isGzipCompression() {
        return (Boolean)this.getProperty(GZIP_COMPRESSION, false);
    }

    @Override
    public void setGzipCompression(boolean value) {
        this.setProperty(GZIP_COMPRESSION, value);
    }

    @Override
    public boolean isUseChuncked() {
        return (Boolean)this.getProperty(CHUNKING, true);
    }

    @Override
    public void setUseChuncked(boolean value) {
        this.setProperty(CHUNKING, value);
    }

    @Override
    public boolean isKeyAsSegment() {
        return (Boolean)this.getProperty(KEY_AS_SEGMENT, false);
    }

    @Override
    public void setKeyAsSegment(boolean value) {
        this.setProperty(KEY_AS_SEGMENT, value);
    }

    @Override
    public boolean isAddressingDerivedTypes() {
        return (Boolean)this.getProperty(ADDRESS_DERIVED_TYPE, true);
    }

    @Override
    public void setAddressingDerivedTypes(boolean value) {
        this.setProperty(ADDRESS_DERIVED_TYPE, value);
    }

    @Override
    public boolean isUseUrlOperationFQN() {
        return (Boolean)this.getProperty(USE_OPERATION_FQN_IN_URL, true);
    }

    @Override
    public void setUseUrlOperationFQN(boolean value) {
        this.setProperty(USE_OPERATION_FQN_IN_URL, value);
    }

    @Override
    public boolean isContinueOnError() {
        return (Boolean)this.getProperty(CONTINUE_ON_ERROR, false);
    }

    @Override
    public void setContinueOnError(boolean value) {
        this.setProperty(CONTINUE_ON_ERROR, value);
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(ExecutorService executorService) {
        this.executor = executorService;
    }
}

