/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.queryoption;

import java.util.List;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.LevelsExpandOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;

public class ExpandItemImpl
implements ExpandItem {
    private LevelsExpandOption levelsExpandOption;
    private FilterOption filterOption;
    private SearchOption searchOption;
    private OrderByOption orderByOption;
    private SkipOption skipOption;
    private TopOption topOption;
    private CountOption inlineCountOption;
    private SelectOption selectOption;
    private ExpandOption expandOption;
    private ApplyOption applyOption;
    private UriInfoResource resourceInfo;
    private boolean isStar;
    private boolean isRef;
    private boolean hasCountPath;
    private EdmType startTypeFilter;

    public ExpandItemImpl setSystemQueryOption(SystemQueryOption sysItem) {
        if (sysItem instanceof ApplyOption) {
            this.validateDoubleSystemQueryOption(this.applyOption, sysItem);
            this.applyOption = (ApplyOption)sysItem;
        } else if (sysItem instanceof ExpandOption) {
            this.validateDoubleSystemQueryOption(this.expandOption, sysItem);
            this.expandOption = (ExpandOption)sysItem;
        } else if (sysItem instanceof FilterOption) {
            this.validateDoubleSystemQueryOption(this.filterOption, sysItem);
            this.filterOption = (FilterOption)sysItem;
        } else if (sysItem instanceof CountOption) {
            this.validateDoubleSystemQueryOption(this.inlineCountOption, sysItem);
            this.inlineCountOption = (CountOption)sysItem;
        } else if (sysItem instanceof OrderByOption) {
            this.validateDoubleSystemQueryOption(this.orderByOption, sysItem);
            this.orderByOption = (OrderByOption)sysItem;
        } else if (sysItem instanceof SearchOption) {
            this.validateDoubleSystemQueryOption(this.searchOption, sysItem);
            this.searchOption = (SearchOption)sysItem;
        } else if (sysItem instanceof SelectOption) {
            this.validateDoubleSystemQueryOption(this.selectOption, sysItem);
            this.selectOption = (SelectOption)sysItem;
        } else if (sysItem instanceof SkipOption) {
            this.validateDoubleSystemQueryOption(this.skipOption, sysItem);
            this.skipOption = (SkipOption)sysItem;
        } else if (sysItem instanceof TopOption) {
            this.validateDoubleSystemQueryOption(this.topOption, sysItem);
            this.topOption = (TopOption)sysItem;
        } else if (sysItem instanceof LevelsExpandOption) {
            if (this.levelsExpandOption != null) {
                throw new ODataRuntimeException("$levels");
            }
            this.levelsExpandOption = (LevelsExpandOption)((Object)sysItem);
        }
        return this;
    }

    private void validateDoubleSystemQueryOption(SystemQueryOption oldOption, SystemQueryOption newOption) {
        if (oldOption != null) {
            throw new ODataRuntimeException(newOption.getName());
        }
    }

    public ExpandItemImpl setSystemQueryOptions(List<SystemQueryOption> list) {
        for (SystemQueryOption item : list) {
            this.setSystemQueryOption(item);
        }
        return this;
    }

    @Override
    public LevelsExpandOption getLevelsOption() {
        return this.levelsExpandOption;
    }

    @Override
    public FilterOption getFilterOption() {
        return this.filterOption;
    }

    @Override
    public SearchOption getSearchOption() {
        return this.searchOption;
    }

    @Override
    public OrderByOption getOrderByOption() {
        return this.orderByOption;
    }

    @Override
    public SkipOption getSkipOption() {
        return this.skipOption;
    }

    @Override
    public TopOption getTopOption() {
        return this.topOption;
    }

    @Override
    public CountOption getCountOption() {
        return this.inlineCountOption;
    }

    @Override
    public SelectOption getSelectOption() {
        return this.selectOption;
    }

    @Override
    public ExpandOption getExpandOption() {
        return this.expandOption;
    }

    @Override
    public ApplyOption getApplyOption() {
        return this.applyOption;
    }

    public ExpandItemImpl setResourcePath(UriInfoResource resourceInfo) {
        this.resourceInfo = resourceInfo;
        return this;
    }

    @Override
    public UriInfoResource getResourcePath() {
        return this.resourceInfo;
    }

    @Override
    public boolean isStar() {
        return this.isStar;
    }

    public ExpandItemImpl setIsStar(boolean isStar) {
        this.isStar = isStar;
        return this;
    }

    @Override
    public boolean isRef() {
        return this.isRef;
    }

    public ExpandItemImpl setIsRef(boolean isRef) {
        this.isRef = isRef;
        return this;
    }

    @Override
    public EdmType getStartTypeFilter() {
        return this.startTypeFilter;
    }

    public ExpandItemImpl setTypeFilter(EdmType startTypeFilter) {
        this.startTypeFilter = startTypeFilter;
        return this;
    }

    @Override
    public boolean hasCountPath() {
        return this.hasCountPath;
    }

    public void setCountPath(boolean value) {
        this.hasCountPath = value;
    }
}

