/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.format.AcceptCharset;
import org.apache.olingo.commons.api.format.AcceptType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.core.AcceptHeaderContentNegotiatorException;
import org.apache.olingo.server.core.ContentNegotiatorException;

public final class ContentNegotiator {
    private static final String ATOM = "atom";
    private static final String JSON = "json";
    private static final String XML = "xml";
    private static final String APPLICATION_JSON = "application/json";
    private static final String METADATA = "METADATA";
    private static final String COLON = ":";
    private static final Pattern CHARSET_PATTERN = Pattern.compile("([^,][\\w!#$%&'*+-._`|~;^]*)");
    private static final List<ContentType> DEFAULT_SUPPORTED_CONTENT_TYPES = Collections.unmodifiableList(Arrays.asList(ContentType.JSON, ContentType.JSON_NO_METADATA, ContentType.APPLICATION_JSON, ContentType.JSON_FULL_METADATA, ContentType.APPLICATION_PDF));

    private ContentNegotiator() {
    }

    private static List<ContentType> getDefaultSupportedContentTypes(RepresentationType type) {
        switch (type) {
            case METADATA: {
                return Collections.unmodifiableList(Arrays.asList(ContentType.APPLICATION_XML, ContentType.APPLICATION_JSON));
            }
            case MEDIA: 
            case BINARY: {
                return Collections.singletonList(ContentType.APPLICATION_OCTET_STREAM);
            }
            case VALUE: 
            case COUNT: {
                return Collections.singletonList(ContentType.TEXT_PLAIN);
            }
            case BATCH: {
                return Collections.singletonList(ContentType.MULTIPART_MIXED);
            }
        }
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    private static List<ContentType> getSupportedContentTypes(CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        List<ContentType> result;
        List<ContentType> defaultSupportedContentTypes = ContentNegotiator.getDefaultSupportedContentTypes(representationType);
        List<ContentType> list = result = customContentTypeSupport == null ? defaultSupportedContentTypes : customContentTypeSupport.modifySupportedContentTypes(defaultSupportedContentTypes, representationType);
        if (result == null || result.isEmpty()) {
            throw new ContentNegotiatorException("No content type has been specified as supported.", ContentNegotiatorException.MessageKeys.NO_CONTENT_TYPE_SUPPORTED, new String[0]);
        }
        return result;
    }

    public static ContentType doContentNegotiation(FormatOption formatOption, ODataRequest request, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        List<ContentType> supportedContentTypes = ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType);
        List<String> acceptHeaderValueList = request.getHeaders("Accept");
        String acceptHeaderValue = acceptHeaderValueList != null ? acceptHeaderValueList.stream().collect(Collectors.joining(", ")) : null;
        List<String> acceptCharsetValueList = request.getHeaders("Accept-Charset");
        String acceptCharset = acceptCharsetValueList != null ? acceptCharsetValueList.stream().collect(Collectors.joining(", ")) : null;
        List<AcceptCharset> charsets = null;
        ContentType result = null;
        if (formatOption != null && formatOption.getFormat() != null) {
            String formatString = formatOption.getFormat().trim();
            ContentType contentType = ContentNegotiator.mapContentType(formatString, representationType);
            boolean isCharsetInFormat = false;
            List<AcceptType> formatTypes = null;
            try {
                formatTypes = AcceptType.fromContentType(contentType == null ? ContentType.create(formatOption.getFormat()) : contentType);
            }
            catch (IllegalArgumentException e) {
                throw new AcceptHeaderContentNegotiatorException("Unsupported $format=" + formatString, (Throwable)e, AcceptHeaderContentNegotiatorException.MessageKeys.UNSUPPORTED_FORMAT_OPTION, formatString);
            }
            Map<String, String> formatParameters = formatTypes.get(0).getParameters();
            if (!formatParameters.isEmpty() && null != formatParameters.get("charset")) {
                isCharsetInFormat = true;
            } else {
                isCharsetInFormat = false;
                charsets = ContentNegotiator.getAcceptCharset(acceptCharset);
            }
            try {
                if (isCharsetInFormat) {
                    charsets = ContentNegotiator.getAcceptCharset(formatParameters.get("charset"));
                }
                result = ContentNegotiator.getAcceptedType(formatTypes, supportedContentTypes, charsets);
            }
            catch (IllegalArgumentException e) {
                throw new AcceptHeaderContentNegotiatorException("Unsupported $format=" + formatString, (Throwable)e, AcceptHeaderContentNegotiatorException.MessageKeys.UNSUPPORTED_FORMAT_OPTION, formatString);
            }
            catch (AcceptHeaderContentNegotiatorException e) {
                throw new AcceptHeaderContentNegotiatorException("Unsupported $format=" + formatString, (Throwable)e, AcceptHeaderContentNegotiatorException.MessageKeys.UNSUPPORTED_FORMAT_OPTION, formatString);
            }
            catch (ContentNegotiatorException e) {
                throw new ContentNegotiatorException("Unsupported $format=" + formatString, (Throwable)e, ContentNegotiatorException.MessageKeys.UNSUPPORTED_FORMAT_OPTION, formatString);
            }
            if (result == null) {
                throw new ContentNegotiatorException("Unsupported $format = " + formatString, ContentNegotiatorException.MessageKeys.UNSUPPORTED_FORMAT_OPTION, formatString);
            }
        } else if (acceptHeaderValue != null) {
            charsets = ContentNegotiator.getAcceptCharset(acceptCharset);
            try {
                result = ContentNegotiator.getAcceptedType(AcceptType.create(acceptHeaderValue), supportedContentTypes, charsets);
            }
            catch (IllegalArgumentException e) {
                throw new AcceptHeaderContentNegotiatorException(e.getMessage(), (Throwable)e, AcceptHeaderContentNegotiatorException.MessageKeys.UNSUPPORTED_ACCEPT_TYPES, e.getMessage().substring(e.getMessage().lastIndexOf(COLON) + 1));
            }
            if (result == null) {
                List<AcceptType> types = AcceptType.create(acceptHeaderValue);
                throw new ContentNegotiatorException("The combination of type and subtype " + types.get(0) + " != " + supportedContentTypes, ContentNegotiatorException.MessageKeys.UNSUPPORTED_ACCEPT_TYPES, acceptHeaderValue);
            }
        } else {
            charsets = ContentNegotiator.getAcceptCharset(acceptCharset);
            ContentType requestedContentType = ContentNegotiator.getDefaultSupportedContentTypes(representationType).get(0);
            result = ContentNegotiator.getAcceptedType(AcceptType.fromContentType(requestedContentType), supportedContentTypes, charsets);
            if (result == null) {
                throw new ContentNegotiatorException("unsupported accept content type: " + requestedContentType + " != " + supportedContentTypes, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPE, requestedContentType.toContentTypeString());
            }
        }
        return result;
    }

    private static List<AcceptCharset> getAcceptCharset(String acceptCharset) throws ContentNegotiatorException, AcceptHeaderContentNegotiatorException {
        List<AcceptCharset> charsets = null;
        if (acceptCharset != null) {
            try {
                charsets = AcceptCharset.create(acceptCharset);
            }
            catch (UnsupportedCharsetException e) {
                throw new ContentNegotiatorException(e.getMessage(), (Throwable)e, ContentNegotiatorException.MessageKeys.UNSUPPORTED_ACCEPT_CHARSET, e.getMessage().substring(e.getMessage().lastIndexOf(COLON) + 1));
            }
            catch (IllegalArgumentException e) {
                throw new AcceptHeaderContentNegotiatorException(e.getMessage(), (Throwable)e, AcceptHeaderContentNegotiatorException.MessageKeys.UNSUPPORTED_ACCEPT_CHARSET_HEADER_OPTIONS, e.getMessage().substring(e.getMessage().lastIndexOf(COLON) + 1));
            }
        }
        return charsets;
    }

    private static ContentType mapContentType(String formatString, RepresentationType representationType) {
        if (representationType.name().equals(METADATA)) {
            return JSON.equalsIgnoreCase(formatString) || APPLICATION_JSON.equalsIgnoreCase(formatString) ? ContentType.APPLICATION_JSON : (XML.equalsIgnoreCase(formatString) ? ContentType.APPLICATION_XML : (ATOM.equalsIgnoreCase(formatString) ? ContentType.APPLICATION_ATOM_XML : null));
        }
        return JSON.equalsIgnoreCase(formatString) ? ContentType.JSON : (XML.equalsIgnoreCase(formatString) ? ContentType.APPLICATION_XML : (ATOM.equalsIgnoreCase(formatString) ? ContentType.APPLICATION_ATOM_XML : (APPLICATION_JSON.equalsIgnoreCase(formatString) ? ContentType.APPLICATION_JSON : null)));
    }

    private static ContentType getAcceptedType(List<AcceptType> acceptedContentTypes, List<ContentType> supportedContentTypes, List<AcceptCharset> charsets) throws ContentNegotiatorException {
        if (charsets != null) {
            Iterator<AcceptCharset> iterator = charsets.iterator();
            if (iterator.hasNext()) {
                AcceptCharset charset = iterator.next();
                return ContentNegotiator.getContentType(acceptedContentTypes, supportedContentTypes, charset);
            }
        } else {
            return ContentNegotiator.getContentType(acceptedContentTypes, supportedContentTypes, null);
        }
        return null;
    }

    private static ContentType getContentType(List<AcceptType> acceptedContentTypes, List<ContentType> supportedContentTypes, AcceptCharset charset) throws ContentNegotiatorException {
        for (AcceptType acceptedType : acceptedContentTypes) {
            Iterator<ContentType> iterator = supportedContentTypes.iterator();
            while (iterator.hasNext()) {
                ContentType supportedContentType;
                ContentType contentType = supportedContentType = iterator.next();
                String charSetValue = acceptedType.getParameter("charset");
                if (charset != null) {
                    contentType = "*".equals(charset.toString()) ? ContentType.create(contentType, "charset", "utf-8") : ContentType.create(contentType, "charset", charset.toString());
                } else if (charSetValue != null) {
                    if ("utf8".equalsIgnoreCase(charSetValue) || "utf-8".equalsIgnoreCase(charSetValue) || "*".equals(charSetValue)) {
                        contentType = ContentType.create(contentType, "charset", "utf-8");
                    } else {
                        if (CHARSET_PATTERN.matcher(charSetValue).matches()) {
                            throw new ContentNegotiatorException("Unsupported accept-header-charset = " + charSetValue, ContentNegotiatorException.MessageKeys.UNSUPPORTED_ACCEPT_HEADER_CHARSET, acceptedType.toString());
                        }
                        throw new AcceptHeaderContentNegotiatorException("Illegal charset in Accept header: " + charSetValue, AcceptHeaderContentNegotiatorException.MessageKeys.UNSUPPORTED_ACCEPT_HEADER_CHARSET, acceptedType.toString());
                    }
                }
                String ieee754compatibleValue = acceptedType.getParameter("IEEE754Compatible");
                if ("true".equalsIgnoreCase(ieee754compatibleValue)) {
                    contentType = ContentType.create(contentType, "IEEE754Compatible", "true");
                } else if ("false".equalsIgnoreCase(ieee754compatibleValue)) {
                    contentType = ContentType.create(contentType, "IEEE754Compatible", "false");
                } else if (ieee754compatibleValue != null) {
                    throw new IllegalArgumentException("Invalid IEEE754Compatible value in accept header:" + acceptedType.toString());
                }
                if (!acceptedType.matches(contentType)) continue;
                return contentType;
            }
        }
        return null;
    }

    public static void checkSupport(ContentType contentType, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        for (ContentType supportedContentType : ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType)) {
            if (!AcceptType.fromContentType(supportedContentType).get(0).matches(contentType)) continue;
            return;
        }
        throw new ContentNegotiatorException("unsupported content type: " + contentType, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPE, contentType.toContentTypeString());
    }

    public static boolean isSupported(ContentType contentType, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        for (ContentType supportedContentType : ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType)) {
            if (!AcceptType.fromContentType(supportedContentType).get(0).matches(contentType)) continue;
            return true;
        }
        return false;
    }
}

