/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.api.communication;

import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;

public class ODataClientErrorException
extends ODataRuntimeException {
    private static final long serialVersionUID = -2551523202755268162L;
    private final StatusLine statusLine;
    private final ODataError error;
    private final InputStream rawResponse;
    private Header[] headerInfo;

    public ODataClientErrorException(StatusLine statusLine) {
        this(statusLine, null, null);
    }

    public ODataClientErrorException(StatusLine statusLine, InputStream rawResponse) {
        this(statusLine, null, rawResponse);
    }

    public ODataClientErrorException(StatusLine statusLine, ODataError error) {
        this(statusLine, error, null);
    }

    public ODataClientErrorException(StatusLine statusLine, ODataError error, InputStream rawResponse) {
        super((String)(error == null ? statusLine.toString() : (String)(error.getCode() == null || error.getCode().isEmpty() ? "" : "(" + error.getCode() + ") ") + error.getMessage() + " [" + statusLine.toString() + "]"));
        this.statusLine = statusLine;
        this.error = error;
        this.rawResponse = rawResponse;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public ODataError getODataError() {
        return this.error;
    }

    public void setHeaderInfo(Header[] headerInfo) {
        this.headerInfo = headerInfo;
    }

    public Header[] getHeaderInfo() {
        return this.headerInfo;
    }

    public InputStream getRawResponse() {
        return this.rawResponse;
    }
}

