/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.DeltaLink;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EdmDeltaSerializer;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.apache.olingo.server.core.serializer.utils.OutputStreamHelper;
import org.apache.olingo.server.core.uri.UriHelperImpl;

public class JsonDeltaSerializer
implements EdmDeltaSerializer {
    private static final String LINK = "/$link";
    private static final String DELETEDLINK = "/$deletedLink";
    private static final String DELTA = "/$delta";
    private static final String HASH = "#";
    private static final String DELETEDENTITY = "/$deletedEntity";
    private static final String ENTITY = "/$entity";
    private static final String REASON = "Reason";
    private final boolean isIEEE754Compatible;
    private final boolean isODataMetadataNone;
    private final boolean isODataMetadataFull;

    public JsonDeltaSerializer(ContentType contentType) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.isODataMetadataNone = ContentTypeHelper.isODataMetadataNone(contentType);
        this.isODataMetadataFull = ContentTypeHelper.isODataMetadataFull(contentType);
    }

    @Override
    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType referencedEntityType, Delta delta, EntityCollectionSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            boolean pagination = false;
            json.writeStartObject();
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            this.writeContextURL(contextURL, json);
            if (options != null && options.getCount() != null && options.getCount().getValue()) {
                this.writeInlineCount(delta.getCount(), json);
            }
            json.writeFieldName("value");
            this.writeEntitySet(metadata, referencedEntityType, delta, options, json);
            pagination = this.writeNextLink(delta, json);
            this.writeDeltaLink(delta, json, pagination);
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                OutputStreamHelper.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        OutputStreamHelper.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    protected void writeEntitySet(ServiceMetadata metadata, EdmEntityType entityType, Delta entitySet, EntityCollectionSerializerOptions options, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        for (Entity entity : entitySet.getEntities()) {
            this.writeAddedUpdatedEntity(metadata, entityType, entity, options.getExpand(), options.getSelect(), options.getContextURL(), false, options.getContextURL().getEntitySetOrSingletonOrType(), json);
        }
        for (DeletedEntity deletedEntity : entitySet.getDeletedEntities()) {
            this.writeDeletedEntity(deletedEntity, json);
        }
        for (DeltaLink addedLink : entitySet.getAddedLinks()) {
            this.writeLink(addedLink, options, json, true);
        }
        for (DeltaLink deletedLink : entitySet.getDeletedLinks()) {
            this.writeLink(deletedLink, options, json, false);
        }
        json.writeEndArray();
    }

    private void writeLink(DeltaLink link, EntityCollectionSerializerOptions options, JsonGenerator json, boolean isAdded) throws IOException, SerializerException {
        try {
            json.writeStartObject();
            String entityId = options.getContextURL().getEntitySetOrSingletonOrType();
            String operation = isAdded ? LINK : DELETEDLINK;
            json.writeStringField("@odata.context", HASH + entityId + operation);
            if (link != null) {
                if (link.getSource() == null) {
                    throw new SerializerException("DeltaLink source is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Source");
                }
                json.writeStringField("source", link.getSource().toString());
                if (link.getRelationship() == null) {
                    throw new SerializerException("DeltaLink relationship is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Relationship");
                }
                json.writeStringField("relationship", link.getRelationship().toString());
                if (link.getTarget() == null) {
                    throw new SerializerException("DeltaLink target is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Target");
                }
            } else {
                throw new SerializerException("DeltaLink is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Delta Link");
            }
            json.writeStringField("target", link.getTarget().toString());
            json.writeEndObject();
        }
        catch (IOException e) {
            throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
        }
    }

    private void writeDeletedEntity(DeletedEntity deletedEntity, JsonGenerator json) throws IOException, SerializerException {
        if (deletedEntity.getId() == null) {
            throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
        }
        if (deletedEntity.getReason() == null) {
            throw new SerializerException("DeletedEntity reason is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, REASON);
        }
        json.writeStartObject();
        json.writeStringField("@odata.context", HASH + deletedEntity.getId().toASCIIString() + DELETEDENTITY);
        json.writeStringField("id", deletedEntity.getId().toASCIIString());
        json.writeStringField("reason", deletedEntity.getReason().name());
        json.writeEndObject();
    }

    public void writeAddedUpdatedEntity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, ExpandOption expand, SelectOption select, ContextURL url, boolean onlyReference, String name, JsonGenerator json) throws IOException, SerializerException {
        String entityName;
        String entityId;
        json.writeStartObject();
        if (entity.getId() != null && url != null && !(entityId = entity.getId().toString()).contains(name = url.getEntitySetOrSingletonOrType()) && !(entityName = entityId.substring(0, entityId.indexOf("("))).equals(name)) {
            json.writeStringField("@odata.context", HASH + entityName + ENTITY);
        }
        json.writeStringField("@odata.id", this.getEntityId(entity, entityType, name));
        this.writeProperties(metadata, entityType, entity.getProperties(), select, json);
        json.writeEndObject();
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    protected void writeProperty(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        boolean isStreamProperty = this.isStreamProperty(edmProperty);
        if (property != null) {
            if (!isStreamProperty) {
                json.writeFieldName(edmProperty.getName());
            }
            this.writePropertyValue(metadata, edmProperty, property, selectedPaths, json);
        }
    }

    private boolean isStreamProperty(EdmProperty edmProperty) {
        EdmType type = edmProperty.getType();
        return edmProperty.isPrimitive() && type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Stream);
    }

    private void writePropertyValue(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        block8: {
            EdmType type = edmProperty.getType();
            try {
                if (edmProperty.isPrimitive() || type.getKind() == EdmTypeKind.ENUM || type.getKind() == EdmTypeKind.DEFINITION) {
                    if (edmProperty.isCollection()) {
                        this.writePrimitiveCollection((EdmPrimitiveType)type, property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    } else {
                        this.writePrimitive((EdmPrimitiveType)type, property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    }
                    break block8;
                }
                if (property.isComplex()) {
                    if (edmProperty.isCollection()) {
                        this.writeComplexCollection(metadata, (EdmComplexType)type, property, selectedPaths, json);
                    } else {
                        this.writeComplex(metadata, (EdmComplexType)type, property, selectedPaths, json);
                    }
                    break block8;
                }
                throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, edmProperty.getName());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong value for property!", (Throwable)e, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, edmProperty.getName(), property.getValue().toString());
            }
        }
    }

    protected EdmComplexType resolveComplexType(ServiceMetadata metadata, EdmComplexType baseType, String derivedTypeName) throws SerializerException {
        String fullQualifiedName = baseType.getFullQualifiedName().getFullQualifiedNameAsString();
        if (derivedTypeName == null || fullQualifiedName.equals(derivedTypeName)) {
            return baseType;
        }
        EdmComplexType derivedType = metadata.getEdm().getComplexType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("Complex Type not found", SerializerException.MessageKeys.UNKNOWN_TYPE, derivedTypeName);
        }
        for (EdmComplexType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().equals(baseType.getFullQualifiedName())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", SerializerException.MessageKeys.WRONG_BASE_TYPE, derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString());
    }

    private void writeComplex(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartObject();
        String derivedName = property.getType();
        EdmComplexType resolvedType = this.resolveComplexType(metadata, type, derivedName);
        if (!this.isODataMetadataNone && !resolvedType.equals(type) || this.isODataMetadataFull) {
            json.writeStringField("@odata.type", HASH + property.getType());
        }
        this.writeComplexValue(metadata, resolvedType, property.asComplex().getValue(), selectedPaths, json);
        json.writeEndObject();
    }

    private void writePrimitiveCollection(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        block6: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_PRIMITIVE: 
                case COLLECTION_ENUM: {
                    try {
                        this.writePrimitiveValue(property.getName(), type, value, isNullable, maxLength, precision, scale, isUnicode, json);
                        continue block6;
                    }
                    catch (EdmPrimitiveTypeException e) {
                        throw new SerializerException("Wrong value for property!", (Throwable)e, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, property.getName(), property.getValue().toString());
                    }
                }
                case COLLECTION_GEOSPATIAL: {
                    throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
                }
            }
            throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
        }
        json.writeEndArray();
    }

    private void writeComplexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        block3: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_COMPLEX: {
                    json.writeStartObject();
                    if (this.isODataMetadataFull) {
                        json.writeStringField("@odata.type", HASH + type.getFullQualifiedName().getFullQualifiedNameAsString());
                    }
                    this.writeComplexValue(metadata, type, ((ComplexValue)value).getValue(), selectedPaths, json);
                    json.writeEndObject();
                    continue block3;
                }
            }
            throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
        }
        json.writeEndArray();
    }

    private void writePrimitive(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException, SerializerException {
        if (property.isPrimitive()) {
            this.writePrimitiveValue(property.getName(), type, property.asPrimitive(), isNullable, maxLength, precision, scale, isUnicode, json);
        } else {
            if (property.isGeospatial()) {
                throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
            }
            if (property.isEnum()) {
                this.writePrimitiveValue(property.getName(), type, property.asEnum(), isNullable, maxLength, precision, scale, isUnicode, json);
            } else {
                throw new SerializerException("Inconsistent property type!", SerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, property.getName());
            }
        }
    }

    protected void writePrimitiveValue(String name, EdmPrimitiveType type, Object primitiveValue, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException {
        String value = type.valueToString(primitiveValue, isNullable, maxLength, precision, scale, isUnicode);
        if (value == null) {
            json.writeNull();
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Boolean)) {
            json.writeBoolean(Boolean.parseBoolean(value));
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Byte) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Double) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int16) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int32) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.SByte) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Single) || (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Decimal) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int64)) && !this.isIEEE754Compatible) {
            json.writeNumber(value);
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Stream)) {
            if (primitiveValue instanceof Link) {
                Link stream = (Link)primitiveValue;
                if (!this.isODataMetadataNone) {
                    if (stream.getMediaETag() != null) {
                        json.writeStringField(name + "@odata.mediaEtag", stream.getMediaETag());
                    }
                    if (stream.getType() != null) {
                        json.writeStringField(name + "@odata.mediaContentType", stream.getType());
                    }
                }
                if (this.isODataMetadataFull) {
                    if (stream.getRel() != null && stream.getRel().equals("http://docs.oasis-open.org/odata/ns/mediaresource/")) {
                        json.writeStringField(name + "@odata.mediaReadLink", stream.getHref());
                    }
                    if (stream.getRel() == null || stream.getRel().equals("http://docs.oasis-open.org/odata/ns/edit-media/")) {
                        json.writeStringField(name + "@odata.mediaEditLink", stream.getHref());
                    }
                }
            }
        } else {
            json.writeString(value);
        }
    }

    protected void writeComplexValue(ServiceMetadata metadata, EdmComplexType type, List<Property> properties, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        for (String propertyName : type.getPropertyNames()) {
            Property property = this.findProperty(propertyName, properties);
            if (selectedPaths != null && !ExpandSelectHelper.isSelected(selectedPaths, propertyName)) continue;
            this.writeProperty(metadata, (EdmProperty)type.getProperty(propertyName), property, selectedPaths == null ? null : ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, propertyName), json);
        }
    }

    protected void writeProperties(ServiceMetadata metadata, EdmStructuredType type, List<Property> properties, SelectOption select, JsonGenerator json) throws IOException, SerializerException {
        boolean all = ExpandSelectHelper.isAll(select);
        Set<Object> selected = all ? new HashSet() : ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        for (String propertyName : type.getPropertyNames()) {
            if (!all && !selected.contains(propertyName)) continue;
            EdmProperty edmProperty = type.getStructuralProperty(propertyName);
            Property property = this.findProperty(propertyName, properties);
            Set<List<String>> selectedPaths = all || edmProperty.isPrimitive() ? null : ExpandSelectHelper.getSelectedPaths(select.getSelectItems(), propertyName);
            this.writeProperty(metadata, edmProperty, property, selectedPaths, json);
        }
    }

    private String getEntityId(Entity entity, EdmEntityType entityType, String name) throws SerializerException {
        try {
            if (entity != null) {
                if (entity.getId() == null) {
                    if (entityType == null || entityType.getKeyPredicateNames() == null || name == null) {
                        throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
                    }
                    UriHelperImpl uriHelper = new UriHelperImpl();
                    entity.setId(URI.create(name + "(" + uriHelper.buildKeyPredicate(entityType, entity) + ")"));
                    return entity.getId().toASCIIString();
                }
                return entity.getId().toASCIIString();
            }
            return null;
        }
        catch (Exception e) {
            throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
        }
    }

    void writeInlineCount(Integer count, JsonGenerator json) throws IOException {
        if (count != null) {
            String countValue = this.isIEEE754Compatible ? String.valueOf(count) : String.valueOf(count);
            json.writeStringField("@odata.count", countValue);
        }
    }

    ContextURL checkContextURL(ContextURL contextURL) throws SerializerException {
        if (this.isODataMetadataNone) {
            return null;
        }
        if (contextURL == null) {
            throw new SerializerException("ContextURL null!", SerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
        }
        return contextURL;
    }

    void writeContextURL(ContextURL contextURL, JsonGenerator json) throws IOException {
        if (!this.isODataMetadataNone && contextURL != null) {
            json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString() + DELTA);
        }
    }

    boolean writeNextLink(AbstractEntityCollection entitySet, JsonGenerator json) throws IOException {
        if (entitySet.getNext() != null) {
            json.writeStringField("@odata.nextLink", entitySet.getNext().toASCIIString());
            return true;
        }
        return false;
    }

    void writeDeltaLink(AbstractEntityCollection entitySet, JsonGenerator json, boolean pagination) throws IOException {
        if (entitySet.getDeltaLink() != null && !pagination) {
            json.writeStringField("@odata.deltaLink", entitySet.getDeltaLink().toASCIIString());
        }
    }
}

