/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.CustomQueryOption;
import org.apache.olingo.server.core.uri.UriResourceActionImpl;
import org.apache.olingo.server.core.uri.UriResourceComplexPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceCountImpl;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.UriResourceFunctionImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourcePrimitivePropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceRefImpl;
import org.apache.olingo.server.core.uri.UriResourceSingletonImpl;
import org.apache.olingo.server.core.uri.UriResourceTypedImpl;
import org.apache.olingo.server.core.uri.UriResourceValueImpl;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;
import org.apache.olingo.server.core.uri.parser.ParserHelper;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class ResourcePathParser {
    private final Edm edm;
    private final EdmEntityContainer edmEntityContainer;
    private final Map<String, AliasQueryOption> aliases;
    private final List<CustomQueryOption> customQueryOptions;
    private UriTokenizer tokenizer;
    private UriResource entitySetResource = null;
    private final String protocolType;
    private static final String REST = "REST";
    private KeyParseMode keyParseMode = KeyParseMode.INITIAL;

    public ResourcePathParser(Edm edm, Map<String, AliasQueryOption> aliases, List<CustomQueryOption> customQueryOptions) {
        this(edm, aliases, null, customQueryOptions);
    }

    public ResourcePathParser(Edm edm, Map<String, AliasQueryOption> aliases, String protocolType, List<CustomQueryOption> customQueryOptions) {
        this.edm = edm;
        this.aliases = aliases;
        this.protocolType = protocolType;
        this.customQueryOptions = customQueryOptions;
        this.edmEntityContainer = edm.getEntityContainer();
    }

    public UriResource parsePathSegment(String pathSegment, UriResource previous) throws UriParserException, UriValidationException {
        this.tokenizer = new UriTokenizer(pathSegment);
        if (previous == null) {
            if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
                throw new UriParserSemanticException("The initial segment must not be namespace-qualified.", UriParserSemanticException.MessageKeys.NAMESPACE_NOT_ALLOWED_AT_FIRST_ELEMENT, new FullQualifiedName(this.tokenizer.getText()).getNamespace());
            }
            if (this.tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
                return this.leadingResourcePathSegment();
            }
        } else {
            if (this.protocolType != null && this.protocolType.equalsIgnoreCase(REST)) {
                return this.navigationOrPrimitive(previous, pathSegment);
            }
            if (this.tokenizer.next(UriTokenizer.TokenKind.REF)) {
                return this.ref(previous);
            }
            if (this.tokenizer.next(UriTokenizer.TokenKind.VALUE)) {
                return this.value(previous);
            }
            if (this.tokenizer.next(UriTokenizer.TokenKind.COUNT)) {
                return this.count(previous);
            }
            if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
                return this.boundOperationOrTypeCast(previous);
            }
            if (this.isAllowedKeyAsSegment(previous, pathSegment)) {
                return this.primitiveProperty(this.tokenizer, previous, pathSegment, false);
            }
            if (this.tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
                return this.navigationOrProperty(previous);
            }
        }
        throw new UriParserSyntaxException("Unexpected start of resource-path segment.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
    }

    private UriResource navigationOrPrimitive(UriResource previous, String pathSegment) throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.EOF)) {
            throw new UriParserSyntaxException("Unexpected start of resource-path segment.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
            if (previous instanceof UriResourceEntitySet) {
                return this.entityOrpropertyOrProperties(previous, pathSegment);
            }
            if (previous instanceof UriResourceNavigation) {
                return this.navigationOrpropertyOrProperties(previous, pathSegment, false);
            }
        }
        return this.primitiveProperty(this.tokenizer, previous, pathSegment, false);
    }

    public EdmEntityType parseDollarEntityTypeCast(String pathSegment) throws UriParserException {
        this.tokenizer = new UriTokenizer(pathSegment);
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.QualifiedName);
        String name = this.tokenizer.getText();
        ParserHelper.requireTokenEnd(this.tokenizer);
        EdmEntityType type = this.edm.getEntityType(new FullQualifiedName(name));
        if (type == null) {
            throw new UriParserSemanticException("Type '" + name + "' not found.", UriParserSemanticException.MessageKeys.UNKNOWN_TYPE, name);
        }
        return type;
    }

    public List<String> parseCrossjoinSegment(String pathSegment) throws UriParserException {
        this.tokenizer = new UriTokenizer(pathSegment);
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CROSSJOIN);
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.OPEN);
        ArrayList<String> entitySetNames = new ArrayList<String>();
        do {
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
            String name = this.tokenizer.getText();
            EdmEntitySet edmEntitySet = this.edmEntityContainer.getEntitySet(name);
            if (edmEntitySet == null) {
                throw new UriParserSemanticException("Expected Entity Set Name.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, name);
            }
            entitySetNames.add(name);
        } while (this.tokenizer.next(UriTokenizer.TokenKind.COMMA));
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        ParserHelper.requireTokenEnd(this.tokenizer);
        return entitySetNames;
    }

    public boolean isKeyAsSegmentMode() {
        return this.keyParseMode == KeyParseMode.KEY_AS_SEGMENT;
    }

    private UriResource ref(UriResource previous) throws UriParserException {
        ParserHelper.requireTokenEnd(this.tokenizer);
        this.requireTyped(previous, "$ref");
        if (((UriResourcePartTyped)previous).getType() instanceof EdmEntityType) {
            return new UriResourceRefImpl();
        }
        throw new UriParserSemanticException("$ref is only allowed on entity types.", UriParserSemanticException.MessageKeys.ONLY_FOR_ENTITY_TYPES, "$ref");
    }

    private UriResource value(UriResource previous) throws UriParserException {
        ParserHelper.requireTokenEnd(this.tokenizer);
        this.requireTyped(previous, "$value");
        if (!((UriResourcePartTyped)previous).isCollection()) {
            this.requireMediaResourceInCaseOfEntity(previous);
            return new UriResourceValueImpl();
        }
        throw new UriParserSemanticException("$value is only allowed on typed path segments.", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "$value");
    }

    private void requireMediaResourceInCaseOfEntity(UriResource resource) throws UriParserSemanticException {
        EdmType returnType;
        if (resource instanceof UriResourceEntitySet && !((UriResourceEntitySet)resource).getEntityType().hasStream() || resource instanceof UriResourceNavigation && !((EdmEntityType)((UriResourceNavigation)resource).getType()).hasStream()) {
            throw new UriParserSemanticException("$value on entity is only allowed on media resources.", UriParserSemanticException.MessageKeys.NOT_A_MEDIA_RESOURCE, resource.getSegmentValue());
        }
        if (resource instanceof UriResourceFunction && (returnType = ((UriResourceFunction)resource).getFunction().getReturnType().getType()) instanceof EdmEntityType && !((EdmEntityType)returnType).hasStream()) {
            throw new UriParserSemanticException("$value on returned entity is only allowed on media resources.", UriParserSemanticException.MessageKeys.NOT_A_MEDIA_RESOURCE, resource.getSegmentValue());
        }
    }

    private UriResource count(UriResource previous) throws UriParserException {
        ParserHelper.requireTokenEnd(this.tokenizer);
        this.requireTyped(previous, "$count");
        if (((UriResourcePartTyped)previous).isCollection()) {
            return new UriResourceCountImpl();
        }
        throw new UriParserSemanticException("$count is only allowed on collections.", UriParserSemanticException.MessageKeys.ONLY_FOR_COLLECTIONS, "$count");
    }

    private UriResource leadingResourcePathSegment() throws UriParserException, UriValidationException {
        String oDataIdentifier = this.tokenizer.getText();
        EdmEntitySet edmEntitySet = this.edmEntityContainer.getEntitySet(oDataIdentifier);
        if (edmEntitySet != null) {
            UriResourceEntitySetImpl entitySetResource = new UriResourceEntitySetImpl(edmEntitySet);
            if (this.protocolType != null && this.protocolType.equalsIgnoreCase(REST)) {
                if (this.tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
                    throw new UriParserSyntaxException("Unexpected start of resource-path segment.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
                }
            } else if (this.tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
                this.switchMode(KeyParseMode.STANDARD, oDataIdentifier);
                List<UriParameter> keyPredicates = ParserHelper.parseKeyPredicate(this.tokenizer, entitySetResource.getEntityType(), null, this.edm, null, this.aliases);
                entitySetResource.setKeyPredicates(keyPredicates);
            }
            ParserHelper.requireTokenEnd(this.tokenizer);
            this.entitySetResource = entitySetResource;
            return entitySetResource;
        }
        EdmSingleton edmSingleton = this.edmEntityContainer.getSingleton(oDataIdentifier);
        if (edmSingleton != null) {
            ParserHelper.requireTokenEnd(this.tokenizer);
            return new UriResourceSingletonImpl(edmSingleton);
        }
        EdmActionImport edmActionImport = this.edmEntityContainer.getActionImport(oDataIdentifier);
        if (edmActionImport != null) {
            ParserHelper.requireTokenEnd(this.tokenizer);
            return new UriResourceActionImpl(edmActionImport);
        }
        EdmFunctionImport edmFunctionImport = this.edmEntityContainer.getFunctionImport(oDataIdentifier);
        if (edmFunctionImport != null) {
            return this.functionCall(edmFunctionImport, null, null, false);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.OPEN) || this.tokenizer.next(UriTokenizer.TokenKind.EOF)) {
            throw new UriParserSemanticException("Unexpected start of resource-path segment.", UriParserSemanticException.MessageKeys.RESOURCE_NOT_FOUND, oDataIdentifier);
        }
        throw new UriParserSyntaxException("Unexpected start of resource-path segment.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
    }

    private UriResource navigationOrProperty(UriResource previous) throws UriParserException, UriValidationException {
        String name = this.tokenizer.getText();
        UriResourcePartTyped previousTyped = null;
        EdmStructuredType structType = null;
        this.requireTyped(previous, name);
        if (!(((UriResourcePartTyped)previous).getType() instanceof EdmStructuredType)) {
            throw new UriParserSemanticException("Cannot parse '" + name + "'; previous path segment is not a structural type.", UriParserSemanticException.MessageKeys.RESOURCE_PART_MUST_BE_PRECEDED_BY_STRUCTURAL_TYPE, name);
        }
        previousTyped = (UriResourcePartTyped)previous;
        EdmType previousTypeFilter = this.getPreviousTypeFilter(previousTyped);
        structType = (EdmStructuredType)(previousTypeFilter == null ? previousTyped.getType() : previousTypeFilter);
        if (previousTyped.isCollection()) {
            if (this.isAllowedKeyAsSegment(previousTyped, name)) {
                return this.primitiveProperty(this.tokenizer, previous, name, false);
            }
            throw new UriParserSemanticException("Property '" + name + "' is not allowed after collection.", UriParserSemanticException.MessageKeys.PROPERTY_AFTER_COLLECTION, name);
        }
        EdmProperty property = structType.getStructuralProperty(name);
        if (property != null) {
            return property.isPrimitive() || property.getType().getKind() == EdmTypeKind.ENUM || property.getType().getKind() == EdmTypeKind.DEFINITION ? new UriResourcePrimitivePropertyImpl(property) : new UriResourceComplexPropertyImpl(property);
        }
        EdmNavigationProperty navigationProperty = structType.getNavigationProperty(name);
        if (navigationProperty == null) {
            throw new UriParserSemanticException("Property '" + name + "' not found in type '" + structType.getFullQualifiedName().getFullQualifiedNameAsString() + "'", UriParserSemanticException.MessageKeys.PROPERTY_NOT_IN_TYPE, structType.getFullQualifiedName().getFullQualifiedNameAsString(), name);
        }
        List<UriParameter> keyPredicate = ParserHelper.parseNavigationKeyPredicate(this.tokenizer, navigationProperty, this.edm, null, this.aliases, this.protocolType);
        ParserHelper.requireTokenEnd(this.tokenizer);
        return new UriResourceNavigationPropertyImpl(navigationProperty).setKeyPredicates(keyPredicate);
    }

    private UriResource boundOperationOrTypeCast(UriResource previous) throws UriParserException, UriValidationException {
        EdmStructuredType type;
        FullQualifiedName name = new FullQualifiedName(this.tokenizer.getText());
        this.requireTyped(previous, name.getFullQualifiedNameAsString());
        UriResourcePartTyped previousTyped = (UriResourcePartTyped)previous;
        EdmType previousTypeFilter = this.getPreviousTypeFilter(previousTyped);
        EdmType previousType = previousTypeFilter == null ? previousTyped.getType() : previousTypeFilter;
        EdmAction boundAction = this.edm.getBoundAction(name, previousType.getFullQualifiedName(), previousTyped.isCollection());
        if (boundAction != null) {
            ParserHelper.requireTokenEnd(this.tokenizer);
            this.switchMode(KeyParseMode.STANDARD, name.getName());
            return new UriResourceActionImpl(boundAction);
        }
        EdmStructuredType edmStructuredType = type = previousTyped.getType() instanceof EdmEntityType ? this.edm.getEntityType(name) : this.edm.getComplexType(name);
        if (type != null) {
            this.switchMode(KeyParseMode.STANDARD, name.getName());
            return this.typeCast(name, type, previousTyped);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.EOF) && this.customQueryOptions.isEmpty() && this.aliases.isEmpty()) {
            throw new UriParserSemanticException("Type '" + name.getFullQualifiedNameAsString() + "' not found.", UriParserSemanticException.MessageKeys.UNKNOWN_TYPE, name.getFullQualifiedNameAsString());
        }
        return this.functionCall(null, name, previousType.getFullQualifiedName(), previousTyped.isCollection());
    }

    private void requireTyped(UriResource previous, String forWhat) throws UriParserException {
        if (!(previous instanceof UriResourcePartTyped)) {
            throw new UriParserSemanticException("Path segment before '" + forWhat + "' is not typed.", UriParserSemanticException.MessageKeys.PREVIOUS_PART_NOT_TYPED, forWhat);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private UriResource typeCast(FullQualifiedName name, EdmStructuredType type, UriResourcePartTyped previousTyped) throws UriParserException, UriValidationException {
        if (!type.compatibleTo(previousTyped.getType())) throw new UriParserSemanticException("Type filter not compatible to previous path segment: " + name.getFullQualifiedNameAsString(), UriParserSemanticException.MessageKeys.INCOMPATIBLE_TYPE_FILTER, name.getFullQualifiedNameAsString());
        EdmType previousTypeFilter = null;
        if (previousTyped instanceof UriResourceWithKeysImpl) {
            if (previousTyped.isCollection()) {
                previousTypeFilter = ((UriResourceWithKeysImpl)previousTyped).getTypeFilterOnCollection();
                if (previousTypeFilter != null) {
                    throw new UriParserSemanticException("Type filters are not chainable.", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, previousTypeFilter.getName(), type.getName());
                }
                ((UriResourceWithKeysImpl)previousTyped).setCollectionTypeFilter(type);
            } else {
                previousTypeFilter = ((UriResourceWithKeysImpl)previousTyped).getTypeFilterOnEntry();
                if (previousTypeFilter != null) {
                    throw new UriParserSemanticException("Type filters are not chainable.", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, previousTypeFilter.getName(), type.getName());
                }
                ((UriResourceWithKeysImpl)previousTyped).setEntryTypeFilter(type);
            }
            if (this.tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
                List<UriParameter> keys = ParserHelper.parseKeyPredicate(this.tokenizer, (EdmEntityType)type, null, this.edm, null, this.aliases);
                if (!previousTyped.isCollection()) throw new UriParserSemanticException("Key not allowed here.", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]);
                ((UriResourceWithKeysImpl)previousTyped).setKeyPredicates(keys);
            }
        } else {
            previousTypeFilter = ((UriResourceTypedImpl)previousTyped).getTypeFilter();
            if (previousTypeFilter != null) {
                throw new UriParserSemanticException("Type filters are not chainable.", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, previousTypeFilter.getName(), type.getName());
            }
            ((UriResourceTypedImpl)previousTyped).setTypeFilter(type);
        }
        ParserHelper.requireTokenEnd(this.tokenizer);
        return null;
    }

    private EdmType getPreviousTypeFilter(UriResourcePartTyped previousTyped) {
        if (previousTyped instanceof UriResourceWithKeysImpl) {
            return ((UriResourceWithKeysImpl)previousTyped).getTypeFilterOnEntry() == null ? ((UriResourceWithKeysImpl)previousTyped).getTypeFilterOnCollection() : ((UriResourceWithKeysImpl)previousTyped).getTypeFilterOnEntry();
        }
        return ((UriResourceTypedImpl)previousTyped).getTypeFilter();
    }

    private UriResource functionCall(EdmFunctionImport edmFunctionImport, FullQualifiedName boundFunctionName, FullQualifiedName bindingParameterTypeName, boolean isBindingParameterCollection) throws UriParserException, UriValidationException {
        List<UriParameter> parameters = ParserHelper.parseFunctionParameters(this.tokenizer, this.edm, this.aliases, this.customQueryOptions);
        List<String> names = ParserHelper.getParameterNames(parameters);
        EdmFunction function = null;
        if (edmFunctionImport != null) {
            function = edmFunctionImport.getUnboundFunction(names);
            if (function == null) {
                throw new UriParserSemanticException("Function of function import '" + edmFunctionImport.getName() + "' with parameters " + names.toString() + " not found.", UriParserSemanticException.MessageKeys.FUNCTION_NOT_FOUND, edmFunctionImport.getName(), names.toString());
            }
        } else {
            function = this.edm.getBoundFunction(boundFunctionName, bindingParameterTypeName, isBindingParameterCollection, names);
            if (function == null) {
                throw new UriParserSemanticException("Function " + boundFunctionName + " not found.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, boundFunctionName.getFullQualifiedNameAsString());
            }
        }
        ParserHelper.validateFunctionParameters(function, parameters, this.edm, null, this.aliases);
        ParserHelper.validateFunctionParameterFacets(function, parameters, this.edm, this.aliases);
        UriResourceFunctionImpl resource = new UriResourceFunctionImpl(edmFunctionImport, function, parameters);
        if (this.tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
            if (function.getReturnType() != null && function.getReturnType().getType().getKind() == EdmTypeKind.ENTITY && function.getReturnType().isCollection()) {
                resource.setKeyPredicates(ParserHelper.parseKeyPredicate(this.tokenizer, (EdmEntityType)function.getReturnType().getType(), null, this.edm, null, this.aliases));
            } else {
                throw new UriParserSemanticException("A key is not allowed.", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]);
            }
        }
        ParserHelper.requireTokenEnd(this.tokenizer);
        this.switchMode(KeyParseMode.STANDARD, resource.getSegmentValue());
        return resource;
    }

    private UriResource entityOrpropertyOrProperties(UriResource previous, String pathSegment) throws UriParserException, UriValidationException {
        boolean propertyAfterCollection = false;
        EdmEntityType edmEntityType = null;
        UriResourceEntitySet entitySet = (UriResourceEntitySet)previous;
        edmEntityType = entitySet.getEntityType();
        List<EdmKeyPropertyRef> keyPropertyRefs = edmEntityType.getKeyPropertyRefs();
        String[] pathSegmentSplit = pathSegment.split(",");
        if (pathSegmentSplit.length == 1) {
            if (this.navigationCheck(previous)) {
                return this.navigationOrProperty(previous);
            }
            if (pathSegmentSplit[0].contains("=")) {
                if (pathSegmentSplit.length < keyPropertyRefs.size()) {
                    throw new UriParserSemanticException("Too many key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(keyPropertyRefs.size()), Integer.toString(pathSegmentSplit.length));
                }
                return this.primitiveProperty(this.tokenizer, previous, pathSegment, true);
            }
            return this.primitiveProperty(this.tokenizer, previous, pathSegment, false);
        }
        if (pathSegmentSplit.length > keyPropertyRefs.size()) {
            throw new UriParserSemanticException("Too many key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(keyPropertyRefs.size()), Integer.toString(keyPropertyRefs.size() + 1));
        }
        ArrayList<Boolean> keysValidaterList = new ArrayList<Boolean>();
        for (String pathSegmentvalue : pathSegmentSplit) {
            for (EdmKeyPropertyRef keyPropertyRef : keyPropertyRefs) {
                if (!keyPropertyRef.getName().equals(pathSegmentvalue.split("=")[0])) continue;
                keysValidaterList.add(true);
            }
        }
        if (keysValidaterList.size() == keyPropertyRefs.size() && !keysValidaterList.contains(false)) {
            propertyAfterCollection = true;
        }
        if (propertyAfterCollection) {
            ArrayList<UriParameter> keys = new ArrayList<UriParameter>();
            keys.addAll(ParserHelper.compoundKey(this.tokenizer, edmEntityType, this.edm, null, this.aliases, this.protocolType));
            ((UriResourceWithKeysImpl)((Object)entitySet)).setKeyPredicates(keys);
        }
        return entitySet;
    }

    private UriResource navigationOrpropertyOrProperties(UriResource previous, String pathSegment, boolean primitiveValueFlow) throws UriParserException, UriValidationException {
        String name = previous.getSegmentValue();
        UriResourcePartTyped previousTyped = null;
        EdmStructuredType structType = null;
        if (!(((UriResourcePartTyped)this.entitySetResource).getType() instanceof EdmStructuredType)) {
            throw new UriParserSemanticException("Cannot parse '" + name + "'; previous path segment is not a structural type.", UriParserSemanticException.MessageKeys.RESOURCE_PART_MUST_BE_PRECEDED_BY_STRUCTURAL_TYPE, name);
        }
        previousTyped = (UriResourcePartTyped)this.entitySetResource;
        EdmType previousTypeFilter = this.getPreviousTypeFilter(previousTyped);
        structType = (EdmStructuredType)(previousTypeFilter == null ? previousTyped.getType() : previousTypeFilter);
        EdmNavigationProperty navigationProperty = structType.getNavigationProperty(name);
        if (navigationProperty == null) {
            throw new UriParserSemanticException("Property '" + name + "' not found in type '" + structType.getFullQualifiedName().getFullQualifiedNameAsString() + "'", UriParserSemanticException.MessageKeys.PROPERTY_NOT_IN_TYPE, structType.getFullQualifiedName().getFullQualifiedNameAsString(), name);
        }
        List<UriParameter> keyPredicates = new ArrayList<UriParameter>();
        if (navigationProperty.isCollection()) {
            List<EdmKeyPropertyRef> keyPropertyRefs = navigationProperty.getType().getKeyPropertyRefs();
            if (keyPropertyRefs.size() == 1) {
                EdmProperty edmProperty;
                EdmProperty edmProperty2 = edmProperty = keyPropertyRefs.get(0) == null ? null : keyPropertyRefs.get(0).getProperty();
                if (primitiveValueFlow) {
                    if (edmProperty != null) {
                        keyPredicates = this.keyPredicates(edmProperty, keyPropertyRefs, pathSegment, this.edm, this.aliases);
                    }
                } else {
                    String[] pathSegmentSplit = pathSegment.split(",");
                    if (pathSegmentSplit[0].contains("=")) {
                        if (pathSegmentSplit.length < keyPropertyRefs.size()) {
                            throw new UriParserSemanticException("Too many key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(keyPropertyRefs.size()), Integer.toString(pathSegmentSplit.length));
                        }
                        if (pathSegmentSplit.length > keyPropertyRefs.size()) {
                            throw new UriParserSemanticException("Too many key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(keyPropertyRefs.size()), Integer.toString(keyPropertyRefs.size() + 1));
                        }
                        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.EQ);
                        String[] pathSegmentWithPropertySplit = pathSegment.split("=");
                        if (edmProperty != null) {
                            keyPredicates.addAll(this.keyPredicates(edmProperty, keyPropertyRefs, pathSegmentWithPropertySplit[pathSegmentWithPropertySplit.length - 1], this.edm, this.aliases));
                        }
                    } else if (edmProperty != null) {
                        keyPredicates = this.keyPredicates(edmProperty, keyPropertyRefs, pathSegment, this.edm, this.aliases);
                    }
                }
            } else if (this.isKeyAsSegmentMode()) {
                ArrayList<UriParameter> partialKeys = new ArrayList<UriParameter>(((UriResourceNavigation)previous).getKeyPredicates());
                int size = partialKeys.size();
                EdmKeyPropertyRef edmKeyPropertyRef = keyPropertyRefs.get(size);
                EdmProperty edmProperty = edmKeyPropertyRef == null ? null : edmKeyPropertyRef.getProperty();
                UriParameter key = this.keyPredicate(edmProperty, edmKeyPropertyRef, pathSegment, this.edm, this.aliases);
                partialKeys.add(key);
                keyPredicates.addAll(partialKeys);
            } else {
                keyPredicates.addAll(ParserHelper.compoundKey(this.tokenizer, navigationProperty.getType(), this.edm, null, this.aliases, this.protocolType));
                if (keyPredicates.size() < keyPropertyRefs.size()) {
                    throw new UriParserSemanticException("Expected " + keyPropertyRefs.size() + " key predicates but found " + keyPredicates.size() + ".", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(keyPropertyRefs.size()), Integer.toString(keyPredicates.size()));
                }
            }
        } else {
            throw new UriParserSemanticException("A key is not allowed on non-collection navigation properties.", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]);
        }
        return new UriResourceNavigationPropertyImpl(navigationProperty).setKeyPredicates(keyPredicates);
    }

    private UriResource primitiveProperty(UriTokenizer tokenizer, UriResource previous, String pathSegment, boolean primitiveWithPropertykey) throws UriParserException, UriValidationException {
        if (previous instanceof UriResourceEntitySet) {
            this.switchMode(KeyParseMode.KEY_AS_SEGMENT, pathSegment);
            UriResourceEntitySetImpl entitySet = (UriResourceEntitySetImpl)previous;
            EdmEntityType edmEntityType = entitySet.getEntityType();
            List<EdmKeyPropertyRef> keyPropertyRefs = edmEntityType.getKeyPropertyRefs();
            if (keyPropertyRefs.size() == 1) {
                EdmProperty edmProperty;
                EdmProperty edmProperty2 = edmProperty = keyPropertyRefs.get(0) == null ? null : keyPropertyRefs.get(0).getProperty();
                if (edmProperty != null) {
                    if (primitiveWithPropertykey) {
                        ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
                        String[] pathSegmentSplit = pathSegment.split("=");
                        entitySet.setKeyPredicates(this.keyPredicates(edmProperty, keyPropertyRefs, pathSegmentSplit[pathSegmentSplit.length - 1], this.edm, this.aliases));
                    } else if (entitySet.getKeyPredicates().isEmpty()) {
                        entitySet.setKeyPredicates(this.keyPredicates(edmProperty, keyPropertyRefs, pathSegment, this.edm, this.aliases));
                    } else {
                        throw new UriParserSyntaxException("Unable to parse key", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
                    }
                    if (!EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.String).equals((EdmPrimitiveType)edmProperty.getType())) {
                        ParserHelper.requireTokenEnd(tokenizer);
                    }
                }
            } else {
                ArrayList<UriParameter> partialKeys = new ArrayList<UriParameter>(entitySet.getKeyPredicates());
                int size = partialKeys.size();
                EdmKeyPropertyRef edmKeyPropertyRef = keyPropertyRefs.get(size);
                EdmProperty edmProperty = edmKeyPropertyRef == null ? null : edmKeyPropertyRef.getProperty();
                UriParameter key = this.keyPredicate(edmProperty, edmKeyPropertyRef, pathSegment, this.edm, this.aliases);
                partialKeys.add(key);
                entitySet.setKeyPredicates(partialKeys);
            }
            return entitySet;
        }
        if (previous instanceof UriResourceNavigation) {
            return this.navigationOrpropertyOrProperties(previous, pathSegment, true);
        }
        return previous;
    }

    private List<UriParameter> keyPredicates(EdmProperty edmProperty, List<EdmKeyPropertyRef> keyPropertyRefs, String pathSegment, Edm edm, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        ArrayList<UriParameter> keys = new ArrayList<UriParameter>(1);
        keys.add(this.keyPredicate(edmProperty, keyPropertyRefs.get(0), pathSegment, edm, aliases));
        return keys;
    }

    private UriParameter keyPredicate(EdmProperty edmProperty, EdmKeyPropertyRef keyPropertyRef, String pathSegment, Edm edm, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        EdmType type = edmProperty.getType();
        if (ParserHelper.nextPrimitiveTypeValue(this.tokenizer, (EdmPrimitiveType)type, edmProperty.isNullable(), null) || type == EdmString.getInstance()) {
            EdmPrimitiveType primType = (EdmPrimitiveType)type;
            UriParameter simpleKey = ParserHelper.createUriParameter(edmProperty, keyPropertyRef.getName(), primType.toUriLiteral(pathSegment), edm, null, aliases);
            if (simpleKey != null) {
                return simpleKey;
            }
        }
        throw new UriParserSemanticException("Wrong parameter value.", UriParserSemanticException.MessageKeys.INVALID_KEY_VALUE, "");
    }

    private boolean navigationCheck(UriResource previous) throws UriParserException, UriValidationException {
        String name = this.tokenizer.getText();
        UriResourcePartTyped previousTyped = null;
        EdmStructuredType structType = null;
        this.requireTyped(previous, name);
        if (!(((UriResourcePartTyped)previous).getType() instanceof EdmStructuredType)) {
            throw new UriParserSemanticException("Cannot parse '" + name + "'; previous path segment is not a structural type.", UriParserSemanticException.MessageKeys.RESOURCE_PART_MUST_BE_PRECEDED_BY_STRUCTURAL_TYPE, name);
        }
        previousTyped = (UriResourcePartTyped)previous;
        EdmType previousTypeFilter = this.getPreviousTypeFilter(previousTyped);
        structType = (EdmStructuredType)(previousTypeFilter == null ? previousTyped.getType() : previousTypeFilter);
        return structType.getNavigationProperty(name) != null;
    }

    private boolean isAllowedKeyAsSegment(UriResource previous, String pathSegment) throws UriParserException {
        if (this.keyParseMode == KeyParseMode.INITIAL || this.keyParseMode == KeyParseMode.KEY_AS_SEGMENT) {
            if (pathSegment.isEmpty() || pathSegment.trim().isEmpty() || pathSegment.indexOf(40) >= 0) {
                return false;
            }
            UriResourceKind kind = previous.getKind();
            switch (kind) {
                case singleton: 
                case action: 
                case function: {
                    return false;
                }
            }
            EdmStructuredType structType = null;
            this.requireTyped(previous, pathSegment);
            if (!(((UriResourcePartTyped)previous).getType() instanceof EdmStructuredType)) {
                throw new UriParserSemanticException("Cannot parse '" + pathSegment + "'; previous path segment is not a structural type.", UriParserSemanticException.MessageKeys.RESOURCE_PART_MUST_BE_PRECEDED_BY_STRUCTURAL_TYPE, pathSegment);
            }
            UriResourcePartTyped previousTyped = (UriResourcePartTyped)previous;
            EdmType previousTypeFilter = this.getPreviousTypeFilter(previousTyped);
            structType = (EdmStructuredType)(previousTypeFilter == null ? previousTyped.getType() : previousTypeFilter);
            return structType.getProperty(pathSegment) == null;
        }
        return false;
    }

    private void switchMode(KeyParseMode mode, String pathSegment) {
        if (this.keyParseMode == KeyParseMode.INITIAL) {
            this.keyParseMode = mode;
        }
    }

    static enum KeyParseMode {
        INITIAL,
        STANDARD,
        KEY_AS_SEGMENT;

    }
}

