/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataValueRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataValueRequestImpl
extends AbstractODataRetrieveRequest<ClientPrimitiveValue>
implements ODataValueRequest {
    ODataValueRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultValueFormat();
    }

    @Override
    public ODataRetrieveResponse<ClientPrimitiveValue> execute() {
        HttpResponse res = this.doExecute();
        return new ODataValueResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataValueResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ClientPrimitiveValue value;

        private ODataValueResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(ODataValueRequestImpl.this, odataClient, httpClient, res);
            this.value = null;
        }

        @Override
        public ClientPrimitiveValue getBody() {
            if (this.value == null) {
                ContentType contentType = ContentType.parse(this.getContentType());
                try {
                    this.value = this.odataClient.getObjectFactory().newPrimitiveValueBuilder().setType(contentType.isCompatible(ContentType.TEXT_PLAIN) ? EdmPrimitiveTypeKind.String : EdmPrimitiveTypeKind.Stream).setValue(IOUtils.toString((InputStream)this.getRawResponse())).build();
                }
                catch (Exception e) {
                    throw new HttpClientException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.value;
        }
    }
}

