/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.http;

import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.olingo.client.api.http.WrappingHttpClientFactory;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ProxyWrappingHttpClientFactory
implements WrappingHttpClientFactory {
    private final URI proxy;
    private String proxyUsername;
    private String proxyPassword;
    private final DefaultHttpClientFactory wrapped;

    public ProxyWrappingHttpClientFactory(URI proxy) {
        this(proxy, null, null, new DefaultHttpClientFactory());
    }

    public ProxyWrappingHttpClientFactory(URI proxy, String proxyUsername, String proxyPassword) {
        this(proxy, proxyUsername, proxyPassword, new DefaultHttpClientFactory());
    }

    public ProxyWrappingHttpClientFactory(URI proxy, DefaultHttpClientFactory wrapped) {
        this(proxy, null, null, wrapped);
    }

    public ProxyWrappingHttpClientFactory(URI proxy, String proxyUsername, String proxyPassword, DefaultHttpClientFactory wrapped) {
        this.proxy = proxy;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.wrapped = wrapped;
    }

    @Override
    public DefaultHttpClientFactory getWrappedHttpClientFactory() {
        return this.wrapped;
    }

    @Override
    public HttpClient create(HttpMethod method, URI uri) {
        try {
            Class.forName("org.apache.http.impl.client.HttpClientBuilder");
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setUserAgent(DefaultHttpClientFactory.USER_AGENT);
            HttpHost proxyHost = new HttpHost(this.proxy.getHost(), this.proxy.getPort());
            httpClientBuilder.setProxy(proxyHost);
            if (this.proxyUsername != null && this.proxyPassword != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            return httpClientBuilder.build();
        }
        catch (ClassNotFoundException e) {
            DefaultHttpClient httpclient = (DefaultHttpClient)this.wrapped.create(method, uri);
            HttpHost proxyHost = new HttpHost(this.proxy.getHost(), this.proxy.getPort());
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
            if (this.proxyUsername != null && this.proxyPassword != null) {
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
            }
            return httpclient;
        }
    }

    @Override
    public void close(HttpClient httpClient) {
        this.wrapped.close(httpClient);
    }
}

