/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;

public class ServiceDocumentJsonSerializer {
    public static final String KIND = "kind";
    public static final String FUNCTION_IMPORT = "FunctionImport";
    public static final String SINGLETON = "Singleton";
    public static final String SERVICE_DOCUMENT = "ServiceDocument";
    private final ServiceMetadata metadata;
    private final String serviceRoot;
    private final boolean isODataMetadataNone;

    public ServiceDocumentJsonSerializer(ServiceMetadata metadata, String serviceRoot, boolean isODataMetadataNone) throws SerializerException {
        if (metadata == null || metadata.getEdm() == null) {
            throw new SerializerException("Service Metadata and EDM must not be null for a service.", SerializerException.MessageKeys.NULL_METADATA_OR_EDM, new String[0]);
        }
        this.metadata = metadata;
        this.serviceRoot = serviceRoot;
        this.isODataMetadataNone = isODataMetadataNone;
    }

    public void writeServiceDocument(JsonGenerator gen) throws IOException {
        EdmEntityContainer container;
        gen.writeStartObject();
        if (!this.isODataMetadataNone) {
            String metadataUri = (String)(this.serviceRoot == null ? "" : (this.serviceRoot.endsWith("/") ? this.serviceRoot : this.serviceRoot + "/")) + "$metadata";
            gen.writeObjectField("@odata.context", (Object)metadataUri);
            if (this.metadata != null && this.metadata.getServiceMetadataETagSupport() != null && this.metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
                gen.writeStringField("@odata.metadataEtag", this.metadata.getServiceMetadataETagSupport().getMetadataETag());
            }
        }
        gen.writeArrayFieldStart("value");
        if (this.metadata != null && (container = this.metadata.getEdm().getEntityContainer()) != null) {
            this.writeEntitySets(gen, container);
            this.writeFunctionImports(gen, container);
            this.writeSingletons(gen, container);
        }
    }

    private void writeEntitySets(JsonGenerator gen, EdmEntityContainer container) throws IOException {
        for (EdmEntitySet edmEntitySet : container.getEntitySets()) {
            if (!edmEntitySet.isIncludeInServiceDocument()) continue;
            this.writeElement(gen, null, edmEntitySet.getName(), edmEntitySet.getName(), edmEntitySet.getTitle());
        }
    }

    private void writeFunctionImports(JsonGenerator gen, EdmEntityContainer container) throws IOException {
        for (EdmFunctionImport edmFI : container.getFunctionImports()) {
            if (!edmFI.isIncludeInServiceDocument()) continue;
            this.writeElement(gen, FUNCTION_IMPORT, edmFI.getName(), edmFI.getName(), edmFI.getTitle());
        }
    }

    private void writeSingletons(JsonGenerator gen, EdmEntityContainer container) throws IOException {
        for (EdmSingleton edmSingleton : container.getSingletons()) {
            this.writeElement(gen, SINGLETON, edmSingleton.getName(), edmSingleton.getName(), edmSingleton.getTitle());
        }
    }

    private void writeElement(JsonGenerator gen, String kind, String reference, String name, String title) throws IOException {
        gen.writeStartObject();
        gen.writeObjectField("name", (Object)name);
        if (title != null) {
            gen.writeObjectField("title", (Object)title);
        }
        gen.writeObjectField("url", (Object)reference);
        if (kind != null) {
            gen.writeObjectField(KIND, (Object)kind);
        }
        gen.writeEndObject();
    }
}

