/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntitySetRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataEntitySetRequestImpl<ES extends ClientEntitySet>
extends AbstractODataRetrieveRequest<ES>
implements ODataEntitySetRequest<ES> {
    private ES entitySet = null;

    public ODataEntitySetRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public ODataRetrieveResponse<ES> execute() {
        HttpResponse res = this.doExecute();
        return new ODataEntitySetResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataEntitySetResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ODataEntitySetResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(ODataEntitySetRequestImpl.this, odataClient, httpClient, res);
        }

        @Override
        public ES getBody() {
            if (ODataEntitySetRequestImpl.this.entitySet == null) {
                try {
                    ResWrap<EntityCollection> resource = this.odataClient.getDeserializer(ContentType.parse(this.getContentType())).toEntitySet(this.getRawResponse());
                    ODataEntitySetRequestImpl.this.entitySet = this.odataClient.getBinder().getODataEntitySet(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return ODataEntitySetRequestImpl.this.entitySet;
        }
    }
}

