/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.Include;
import org.apache.olingo.client.api.edm.xml.IncludeAnnotations;
import org.apache.olingo.client.api.edm.xml.Reference;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlInclude;
import org.apache.olingo.client.core.edm.xml.ClientCsdlIncludeAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmItem;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;

@JsonDeserialize(using=ReferenceDeserializer.class)
class ClientCsdlReference
extends CsdlAbstractEdmItem
implements Serializable,
Reference {
    private static final long serialVersionUID = 7720274712545267654L;
    private URI uri;
    private final List<Include> includes = new ArrayList<Include>();
    private final List<IncludeAnnotations> includeAnnotations = new ArrayList<IncludeAnnotations>();
    private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

    ClientCsdlReference() {
    }

    @Override
    public List<CsdlAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public List<Include> getIncludes() {
        return this.includes;
    }

    @Override
    public List<IncludeAnnotations> getIncludeAnnotations() {
        return this.includeAnnotations;
    }

    static class ReferenceDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlReference> {
        ReferenceDeserializer() {
        }

        @Override
        protected ClientCsdlReference doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlReference reference = new ClientCsdlReference();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Uri".equals(jp.getCurrentName())) {
                        reference.setUri(URI.create(jp.nextTextValue()));
                    } else if ("Include".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        reference.getIncludes().add((Include)jp.readValueAs(ClientCsdlInclude.class));
                    } else if ("IncludeAnnotations".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        reference.getIncludeAnnotations().add((IncludeAnnotations)jp.readValueAs(ClientCsdlIncludeAnnotations.class));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        reference.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return reference;
        }
    }
}

