/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.EdmFacetValuesParserHelper;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;

@JsonDeserialize(using=TypeDefinitionDeserializer.class)
class ClientCsdlTypeDefinition
extends CsdlTypeDefinition
implements Serializable {
    private static final long serialVersionUID = -902407149079419602L;

    ClientCsdlTypeDefinition() {
    }

    static class TypeDefinitionDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlTypeDefinition> {
        TypeDefinitionDeserializer() {
        }

        @Override
        protected ClientCsdlTypeDefinition doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlTypeDefinition typeDefinition = new ClientCsdlTypeDefinition();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        typeDefinition.setName(jp.nextTextValue());
                    } else if ("UnderlyingType".equals(jp.getCurrentName())) {
                        typeDefinition.setUnderlyingType(jp.nextTextValue());
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        typeDefinition.setMaxLength(EdmFacetValuesParserHelper.parseMaxLength(jp.nextTextValue()));
                    } else if ("Unicode".equals(jp.getCurrentName())) {
                        typeDefinition.setUnicode(EdmFacetValuesParserHelper.parseIsUnicode(jp.nextTextValue()));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        typeDefinition.setPrecision(EdmFacetValuesParserHelper.parsePrecision(jp.nextTextValue()));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        typeDefinition.setScale(EdmFacetValuesParserHelper.parseScale(jp.nextTextValue()));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        typeDefinition.setSrid(EdmFacetValuesParserHelper.parseSrid(jp.nextTextValue()));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        typeDefinition.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return typeDefinition;
        }
    }
}

