/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmPropertyImpl
extends AbstractEdmNamed
implements EdmProperty {
    private final CsdlProperty property;
    private EdmTypeInfo typeInfo;
    private EdmTypeInfo typeInfoWithAnnotations;
    private EdmType type;
    private EdmType typeWithAnnotations;

    public EdmPropertyImpl(Edm edm, CsdlProperty property) {
        super(edm, property.getName(), property);
        this.property = property;
    }

    @Override
    public EdmType getType() {
        if (this.type == null) {
            EdmType edType;
            if (this.typeInfo == null) {
                this.typeInfo = this.buildTypeInfo(false);
            }
            if ((edType = this.typeInfo.getType()) == null) {
                throw new EdmException("Cannot find type with name: " + this.typeInfo.getFullQualifiedName());
            }
            this.type = edType;
        }
        return this.type;
    }

    @Override
    public EdmType getTypeWithAnnotations() {
        if (this.typeWithAnnotations == null) {
            EdmType edType;
            if (this.typeInfoWithAnnotations == null) {
                this.typeInfoWithAnnotations = this.buildTypeInfo(true);
            }
            if ((edType = this.typeInfoWithAnnotations.getType()) == null) {
                throw new EdmException("Cannot find type with name: " + this.typeInfoWithAnnotations.getFullQualifiedName());
            }
            this.typeWithAnnotations = edType;
        }
        return this.typeWithAnnotations;
    }

    private EdmTypeInfo buildTypeInfo(boolean withAnnotations) {
        if (this.property.getType() == null) {
            throw new EdmException("Property " + this.property.getName() + " must hava a full qualified type.");
        }
        return new EdmTypeInfo.Builder().setEdm(this.edm).setIncludeAnnotations(withAnnotations).setTypeExpression(this.property.getType()).build();
    }

    @Override
    public boolean isCollection() {
        return this.property.isCollection();
    }

    @Override
    public EdmMapping getMapping() {
        return this.property.getMapping();
    }

    @Override
    public String getMimeType() {
        return this.property.getMimeType();
    }

    @Override
    public boolean isNullable() {
        return this.property.isNullable();
    }

    @Override
    public Integer getMaxLength() {
        return this.property.getMaxLength();
    }

    @Override
    public Integer getPrecision() {
        return this.property.getPrecision();
    }

    @Override
    public Integer getScale() {
        return this.property.getScale();
    }

    @Override
    public String getScaleAsString() {
        return this.property.getScaleAsString();
    }

    @Override
    public SRID getSrid() {
        return this.property.getSrid();
    }

    @Override
    public boolean isUnicode() {
        return this.property.isUnicode();
    }

    @Override
    public String getDefaultValue() {
        return this.property.getDefaultValue();
    }

    @Override
    public boolean isPrimitive() {
        if (this.typeInfo == null) {
            this.typeInfo = this.buildTypeInfo(false);
        }
        return this.typeInfo.isPrimitiveType();
    }
}

