/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.validator;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class UriValidator {
    private static final boolean[][] decisionMatrix = new boolean[][]{{true, true, true, false, true, true, true, true, true, true, true, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, false, true, true, true, true, true, true, true, true, true}, {false, true, true, true, false, false, false, true, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, false, true, true, true, true, true, true, true, true, true}, {true, false, false, false, false, false, true, false, false, false, false, true, true}, {false, true, true, false, false, false, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, true, true, true, false, true, true, true, false, true}, {false, true, false, false, false, false, false, false, false, false, false, false, false}, {false, true, true, false, false, false, false, true, false, false, false, false, false}, {true, true, true, false, true, true, false, true, true, true, true, true, true}, {true, false, false, false, false, false, false, false, false, false, false, true, false}, {false, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, true, true, false, false, true, true, true, false, true}, {true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false, false}};
    private static final Map<SystemQueryOptionKind, Integer> OPTION_INDEX;

    public void validate(UriInfo uriInfo, HttpMethod httpMethod) throws UriValidationException {
        UriType uriType = this.getUriType(uriInfo);
        if (HttpMethod.GET == httpMethod) {
            this.validateReadQueryOptions(uriType, uriInfo.getSystemQueryOptions());
        } else {
            this.validateNonReadQueryOptions(uriType, this.isAction(uriInfo), uriInfo.getSystemQueryOptions(), httpMethod);
            this.validatePropertyOperations(uriInfo, httpMethod);
        }
    }

    private UriType getUriType(UriInfo uriInfo) throws UriValidationException {
        return switch (uriInfo.getKind()) {
            case UriInfoKind.all -> UriType.all;
            case UriInfoKind.batch -> UriType.batch;
            case UriInfoKind.crossjoin -> UriType.crossjoin;
            case UriInfoKind.entityId -> UriType.entityId;
            case UriInfoKind.metadata -> UriType.metadata;
            case UriInfoKind.resource -> this.getUriTypeForResource(uriInfo.getUriResourceParts());
            case UriInfoKind.service -> UriType.service;
            default -> throw new UriValidationException("Unsupported uriInfo kind: " + uriInfo.getKind(), UriValidationException.MessageKeys.UNSUPPORTED_URI_KIND, uriInfo.getKind().toString());
        };
    }

    private UriType getUriTypeForResource(List<UriResource> segments) throws UriValidationException {
        UriResource lastPathSegment = segments.get(segments.size() - 1);
        return switch (lastPathSegment.getKind()) {
            case UriResourceKind.count -> this.getUriTypeForCount(segments.get(segments.size() - 2));
            case UriResourceKind.action -> this.getUriTypeForAction(lastPathSegment);
            case UriResourceKind.complexProperty -> this.getUriTypeForComplexProperty(lastPathSegment);
            case UriResourceKind.entitySet, UriResourceKind.navigationProperty -> this.getUriTypeForEntitySet(lastPathSegment);
            case UriResourceKind.function -> this.getUriTypeForFunction(lastPathSegment);
            case UriResourceKind.primitiveProperty -> this.getUriTypeForPrimitiveProperty(lastPathSegment);
            case UriResourceKind.ref -> this.getUriTypeForRef(segments.get(segments.size() - 2));
            case UriResourceKind.singleton -> UriType.entity;
            case UriResourceKind.value -> this.getUriTypeForValue(segments.get(segments.size() - 2));
            default -> throw new UriValidationException("Unsupported uriResource kind: " + lastPathSegment.getKind(), UriValidationException.MessageKeys.UNSUPPORTED_URI_RESOURCE_KIND, lastPathSegment.getKind().toString());
        };
    }

    private UriType getUriTypeForValue(UriResource secondLastPathSegment) throws UriValidationException {
        return switch (secondLastPathSegment.getKind()) {
            case UriResourceKind.primitiveProperty -> UriType.propertyPrimitiveValue;
            case UriResourceKind.entitySet, UriResourceKind.navigationProperty, UriResourceKind.singleton -> UriType.mediaStream;
            case UriResourceKind.function -> {
                UriResourceFunction uriFunction = (UriResourceFunction)secondLastPathSegment;
                EdmFunction function = uriFunction.getFunction();
                yield function.getReturnType().getType().getKind() == EdmTypeKind.ENTITY ? UriType.mediaStream : UriType.propertyPrimitiveValue;
            }
            default -> throw new UriValidationException("Unexpected kind in path segment before $value: " + secondLastPathSegment.getKind(), UriValidationException.MessageKeys.UNALLOWED_KIND_BEFORE_VALUE, secondLastPathSegment.toString());
        };
    }

    private UriType getUriTypeForRef(UriResource secondLastPathSegment) throws UriValidationException {
        return this.isCollection(secondLastPathSegment) ? UriType.references : UriType.reference;
    }

    private boolean isCollection(UriResource pathSegment) throws UriValidationException {
        if (pathSegment instanceof UriResourcePartTyped) {
            return ((UriResourcePartTyped)pathSegment).isCollection();
        }
        throw new UriValidationException("Path segment is not an instance of UriResourcePartTyped but " + pathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, pathSegment.toString());
    }

    private UriType getUriTypeForPrimitiveProperty(UriResource lastPathSegment) throws UriValidationException {
        return this.isCollection(lastPathSegment) ? UriType.propertyPrimitiveCollection : UriType.propertyPrimitive;
    }

    private UriType getUriTypeForFunction(UriResource lastPathSegment) throws UriValidationException {
        UriResourceFunction uriFunction = (UriResourceFunction)lastPathSegment;
        boolean isCollection = uriFunction.isCollection();
        EdmTypeKind typeKind = uriFunction.getFunction().getReturnType().getType().getKind();
        return switch (typeKind) {
            case EdmTypeKind.ENTITY -> isCollection ? UriType.entitySet : UriType.entity;
            case EdmTypeKind.PRIMITIVE, EdmTypeKind.ENUM, EdmTypeKind.DEFINITION -> isCollection ? UriType.propertyPrimitiveCollection : UriType.propertyPrimitive;
            case EdmTypeKind.COMPLEX -> isCollection ? UriType.propertyComplexCollection : UriType.propertyComplex;
            default -> throw new UriValidationException("Unsupported function return type: " + typeKind, UriValidationException.MessageKeys.UNSUPPORTED_FUNCTION_RETURN_TYPE, typeKind.toString());
        };
    }

    private UriType getUriTypeForEntitySet(UriResource lastPathSegment) throws UriValidationException {
        return this.isCollection(lastPathSegment) ? UriType.entitySet : UriType.entity;
    }

    private UriType getUriTypeForComplexProperty(UriResource lastPathSegment) throws UriValidationException {
        return this.isCollection(lastPathSegment) ? UriType.propertyComplexCollection : UriType.propertyComplex;
    }

    private UriType getUriTypeForAction(UriResource lastPathSegment) throws UriValidationException {
        EdmReturnType rt = ((UriResourceAction)lastPathSegment).getAction().getReturnType();
        if (rt == null) {
            return UriType.none;
        }
        return switch (rt.getType().getKind()) {
            case EdmTypeKind.ENTITY -> rt.isCollection() ? UriType.entitySet : UriType.entity;
            case EdmTypeKind.PRIMITIVE, EdmTypeKind.ENUM, EdmTypeKind.DEFINITION -> rt.isCollection() ? UriType.propertyPrimitiveCollection : UriType.propertyPrimitive;
            case EdmTypeKind.COMPLEX -> rt.isCollection() ? UriType.propertyComplexCollection : UriType.propertyComplex;
            default -> throw new UriValidationException("Unsupported action return type: " + rt.getType().getKind(), UriValidationException.MessageKeys.UNSUPPORTED_ACTION_RETURN_TYPE, rt.getType().getKind().toString());
        };
    }

    private UriType getUriTypeForCount(UriResource secondLastPathSegment) throws UriValidationException {
        return switch (secondLastPathSegment.getKind()) {
            case UriResourceKind.entitySet, UriResourceKind.navigationProperty -> UriType.entitySetCount;
            case UriResourceKind.complexProperty -> UriType.propertyComplexCollectionCount;
            case UriResourceKind.primitiveProperty -> UriType.propertyPrimitiveCollectionCount;
            case UriResourceKind.function -> {
                UriResourceFunction uriFunction = (UriResourceFunction)secondLastPathSegment;
                EdmFunction function = uriFunction.getFunction();
                EdmType returnType = function.getReturnType().getType();
                switch (returnType.getKind()) {
                    case ENTITY: {
                        yield UriType.entitySetCount;
                    }
                    case COMPLEX: {
                        yield UriType.propertyComplexCollectionCount;
                    }
                    case PRIMITIVE: 
                    case ENUM: 
                    case DEFINITION: {
                        yield UriType.propertyPrimitiveCollectionCount;
                    }
                }
                throw new UriValidationException("Unsupported return type: " + returnType.getKind(), UriValidationException.MessageKeys.UNSUPPORTED_FUNCTION_RETURN_TYPE, returnType.getKind().toString());
            }
            default -> throw new UriValidationException("Illegal path part kind before $count: " + secondLastPathSegment.getKind(), UriValidationException.MessageKeys.UNALLOWED_KIND_BEFORE_COUNT, secondLastPathSegment.toString());
        };
    }

    private void validateReadQueryOptions(UriType uriType, List<SystemQueryOption> options) throws UriValidationException {
        for (SystemQueryOption option : options) {
            SystemQueryOptionKind kind = option.getKind();
            if (OPTION_INDEX.containsKey((Object)kind)) {
                int columnIndex = OPTION_INDEX.get((Object)kind);
                if (decisionMatrix[uriType.getIndex()][columnIndex]) continue;
                throw new UriValidationException("System query option not allowed: " + option.getName(), UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED, option.getName());
            }
            throw new UriValidationException("Unsupported option: " + kind, UriValidationException.MessageKeys.UNSUPPORTED_QUERY_OPTION, kind.toString());
        }
    }

    private void validateNonReadQueryOptions(UriType uriType, boolean isAction, List<SystemQueryOption> options, HttpMethod httpMethod) throws UriValidationException {
        if (httpMethod == HttpMethod.POST && isAction) {
            this.validateReadQueryOptions(uriType, options);
        } else if (httpMethod == HttpMethod.DELETE && uriType == UriType.references) {
            for (SystemQueryOption option : options) {
                if (SystemQueryOptionKind.ID == option.getKind()) continue;
                throw new UriValidationException("System query option " + option.getName() + " is not allowed for method " + httpMethod, UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED_FOR_HTTP_METHOD, option.getName(), httpMethod.toString());
            }
        } else if (!options.isEmpty() && !this.checkIfSelectOrExpand(options, httpMethod)) {
            StringBuilder optionsString = new StringBuilder();
            for (SystemQueryOption option : options) {
                optionsString.append(option.getName()).append(' ');
            }
            throw new UriValidationException("System query option(s) " + optionsString.toString() + "not allowed for method " + httpMethod, UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED_FOR_HTTP_METHOD, optionsString.toString(), httpMethod.toString());
        }
    }

    private boolean checkIfSelectOrExpand(List<SystemQueryOption> options, HttpMethod httpMethod) {
        boolean isSelectOrExpand = false;
        for (SystemQueryOption queryOption : options) {
            isSelectOrExpand = !(queryOption.getKind() != SystemQueryOptionKind.EXPAND && queryOption.getKind() != SystemQueryOptionKind.SELECT || httpMethod != HttpMethod.PUT && httpMethod != HttpMethod.PATCH && httpMethod != HttpMethod.POST);
        }
        return isSelectOrExpand;
    }

    private boolean isAction(UriInfo uriInfo) {
        List<UriResource> uriResourceParts = uriInfo.getUriResourceParts();
        return !uriResourceParts.isEmpty() && UriResourceKind.action == uriResourceParts.get(uriResourceParts.size() - 1).getKind();
    }

    private void validatePropertyOperations(UriInfo uriInfo, HttpMethod method) throws UriValidationException {
        UriResource previous;
        List<UriResource> parts = uriInfo.getUriResourceParts();
        UriResource last = !parts.isEmpty() ? parts.get(parts.size() - 1) : null;
        UriResource uriResource = previous = parts.size() > 1 ? parts.get(parts.size() - 2) : null;
        if (last != null && (last.getKind() == UriResourceKind.primitiveProperty || last.getKind() == UriResourceKind.complexProperty || last.getKind() == UriResourceKind.value && previous != null && previous.getKind() == UriResourceKind.primitiveProperty)) {
            EdmProperty property = ((UriResourceProperty)(last.getKind() == UriResourceKind.value ? previous : last)).getProperty();
            if (method == HttpMethod.PATCH && property.isCollection()) {
                throw new UriValidationException("Attempt to patch collection property.", UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, method.toString());
            }
            if (method == HttpMethod.DELETE && !property.isNullable() && !property.isCollection()) {
                throw new UriValidationException("Attempt to delete non-nullable property.", UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, method.toString());
            }
        }
    }

    static {
        EnumMap<SystemQueryOptionKind, Integer> temp = new EnumMap<SystemQueryOptionKind, Integer>(SystemQueryOptionKind.class);
        temp.put(SystemQueryOptionKind.FILTER, 0);
        temp.put(SystemQueryOptionKind.FORMAT, 1);
        temp.put(SystemQueryOptionKind.EXPAND, 2);
        temp.put(SystemQueryOptionKind.ID, 3);
        temp.put(SystemQueryOptionKind.COUNT, 4);
        temp.put(SystemQueryOptionKind.ORDERBY, 5);
        temp.put(SystemQueryOptionKind.SEARCH, 6);
        temp.put(SystemQueryOptionKind.SELECT, 7);
        temp.put(SystemQueryOptionKind.SKIP, 8);
        temp.put(SystemQueryOptionKind.SKIPTOKEN, 9);
        temp.put(SystemQueryOptionKind.TOP, 10);
        temp.put(SystemQueryOptionKind.APPLY, 11);
        temp.put(SystemQueryOptionKind.DELTATOKEN, 12);
        OPTION_INDEX = Collections.unmodifiableMap(temp);
    }

    private static enum UriType {
        all(0),
        batch(1),
        crossjoin(2),
        entityId(3),
        metadata(4),
        service(5),
        entitySet(6),
        entitySetCount(7),
        entity(8),
        mediaStream(9),
        references(10),
        reference(11),
        propertyComplex(12),
        propertyComplexCollection(13),
        propertyComplexCollectionCount(14),
        propertyPrimitive(15),
        propertyPrimitiveCollection(16),
        propertyPrimitiveCollectionCount(17),
        propertyPrimitiveValue(18),
        none(19);

        private final int idx;

        private UriType(int i) {
            this.idx = i;
        }

        public int getIndex() {
            return this.idx;
        }
    }
}

