/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.olingo.server.core.uri.queryoption.apply;

import static java.util.Collections.unmodifiableList;

import java.util.List;

import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.apply.HierarchicalSubsetTransformation;

public abstract class AbstractHierarchicalSubsetTransformation implements
        HierarchicalSubsetTransformation {

    private final List<UriResource> hierarchyReference;
    private final String hierarchyQualifier;
    private final List<UriResource> nodeProperty;
    private final List<ApplyItem> transformations;
    private final Integer distanceFromStart;
    private final Boolean keepStart;

    public AbstractHierarchicalSubsetTransformation(List<UriResource> hierarchyReference, String hierarchyQualifier,
            List<UriResource> hierarchyPropertyPath, List<ApplyItem> transformations,
            Integer distanceFromStart, Boolean keepStart) {
        this.hierarchyReference = hierarchyReference;
        this.hierarchyQualifier = hierarchyQualifier;
        this.nodeProperty = hierarchyPropertyPath;
        this.transformations = transformations;
        this.distanceFromStart = distanceFromStart;
        this.keepStart = keepStart;
    }

    @Override
    public List<UriResource> getHierarchyReference() {
        return unmodifiableList(hierarchyReference);
    };

    @Override
    public String getHierarchyQualifier() {
        return hierarchyQualifier;
    }

    @Override
    public List<UriResource> getNodeProperty() {
        return unmodifiableList(nodeProperty);
    }

    @Override
    public List<ApplyItem> getTransformations() {
        return transformations;
    }

    @Override
    public Integer getDistanceFromStart() {
        return distanceFromStart;
    }

    @Override
    public Boolean isKeepStart() {
        return keepStart;
    }

}
