/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.streamed;

import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.streamed.MediaEntityCreateStreamManager;
import org.apache.olingo.client.api.communication.request.streamed.ODataMediaEntityCreateRequest;
import org.apache.olingo.client.api.communication.response.ODataMediaEntityCreateResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.AbstractODataStreamManager;
import org.apache.olingo.client.core.communication.request.Wrapper;
import org.apache.olingo.client.core.communication.request.streamed.AbstractODataStreamedEntityRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataMediaEntityCreateRequestImpl<E extends ClientEntity>
extends AbstractODataStreamedEntityRequest<ODataMediaEntityCreateResponse<E>, MediaEntityCreateStreamManager<E>>
implements ODataMediaEntityCreateRequest<E> {
    private final InputStream media;

    public ODataMediaEntityCreateRequestImpl(ODataClient odataClient, URI targetURI, InputStream media) {
        super(odataClient, HttpMethod.POST, targetURI);
        this.media = media;
    }

    @Override
    protected MediaEntityCreateStreamManager<E> getPayloadManager() {
        if (this.payloadManager == null) {
            this.payloadManager = new MediaEntityCreateStreamManagerImpl(this.media);
        }
        return (MediaEntityCreateStreamManager)this.payloadManager;
    }

    public class MediaEntityCreateStreamManagerImpl
    extends AbstractODataStreamManager<ODataMediaEntityCreateResponse<E>>
    implements MediaEntityCreateStreamManager<E> {
        private MediaEntityCreateStreamManagerImpl(InputStream input) {
            super((Wrapper<Future<HttpResponse>>)ODataMediaEntityCreateRequestImpl.this.futureWrapper, input);
        }

        @Override
        public ODataMediaEntityCreateResponse<E> getResponse(long timeout, TimeUnit unit) {
            this.finalizeBody();
            return new ODataMediaEntityCreateResponseImpl(ODataMediaEntityCreateRequestImpl.this.odataClient, ODataMediaEntityCreateRequestImpl.this.httpClient, this.getHttpResponse(timeout, unit));
        }
    }

    private class ODataMediaEntityCreateResponseImpl
    extends AbstractODataResponse
    implements ODataMediaEntityCreateResponse<E> {
        private E entity;

        private ODataMediaEntityCreateResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.entity = null;
        }

        @Override
        public E getBody() {
            if (this.entity == null) {
                try {
                    ResWrap<Entity> resource = this.odataClient.getDeserializer(ODataMediaEntityCreateRequestImpl.this.getFormat()).toEntity(this.getRawResponse());
                    this.entity = this.odataClient.getBinder().getODataEntity(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.entity;
        }
    }
}

