/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.EdmFacetValuesParserHelper;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlDynamicExpression;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCast;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;

@JsonDeserialize(using=CastDeserializer.class)
class ClientCsdlCast
extends CsdlCast
implements Serializable {
    private static final long serialVersionUID = 3312415984116005313L;

    ClientCsdlCast() {
    }

    static class CastDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlCast> {
        CastDeserializer() {
        }

        @Override
        protected ClientCsdlCast doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlCast cast = new ClientCsdlCast();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Type".equals(jp.getCurrentName())) {
                        cast.setType(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        cast.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        cast.setMaxLength(EdmFacetValuesParserHelper.parseMaxLength(jp.nextTextValue()));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        cast.setPrecision(EdmFacetValuesParserHelper.parsePrecision(jp.nextTextValue()));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        cast.setScale(EdmFacetValuesParserHelper.parseScale(jp.nextTextValue()));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        cast.setSrid(EdmFacetValuesParserHelper.parseSrid(jp.nextTextValue()));
                    } else {
                        cast.setValue((CsdlExpression)jp.readValueAs(ClientCsdlDynamicExpression.class));
                    }
                }
                jp.nextToken();
            }
            return cast;
        }
    }
}

