/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataDeltaRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientDelta;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataDeltaRequestImpl
extends AbstractODataRetrieveRequest<ClientDelta>
implements ODataDeltaRequest {
    public ODataDeltaRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public ODataRetrieveResponse<ClientDelta> execute() {
        HttpResponse res = this.doExecute();
        return new ODataDeltaResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataDeltaResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private ClientDelta delta;

        private ODataDeltaResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.delta = null;
        }

        @Override
        public ClientDelta getBody() {
            if (this.delta == null) {
                try {
                    InputStream content = this.res == null ? this.payload : this.getRawResponse();
                    ResWrap<Delta> resource = this.odataClient.getDeserializer(ContentType.parse(this.getContentType())).toDelta(content);
                    this.delta = this.odataClient.getBinder().getODataDelta(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.delta;
        }
    }
}

