/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.core.edm.AbstractEdmAnnotatable;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmExpression;

public class EdmAnnotationImpl
extends AbstractEdmAnnotatable
implements EdmAnnotation {
    private final CsdlAnnotation annotation;
    private EdmTerm term;
    private EdmExpression expression;

    public EdmAnnotationImpl(Edm edm, CsdlAnnotation annotation) {
        super(edm, annotation);
        this.annotation = annotation;
    }

    @Override
    public EdmTerm getTerm() {
        if (this.term == null) {
            if (this.annotation.getTerm() == null) {
                throw new EdmException("Term must not be null for an annotation.");
            }
            this.term = this.edm.getTerm(new FullQualifiedName(this.annotation.getTerm()));
        }
        return this.term;
    }

    @Override
    public String getQualifier() {
        return this.annotation.getQualifier();
    }

    @Override
    public EdmExpression getExpression() {
        if (this.expression == null && this.annotation.getExpression() != null) {
            this.expression = AbstractEdmExpression.getExpression(this.edm, this.annotation.getExpression());
        }
        return this.expression;
    }
}

