/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.data.ServiceDocumentItem;

public final class ServiceDocumentImpl
implements ServiceDocument {
    private String title;
    private final List<ServiceDocumentItem> entitySets = new ArrayList<ServiceDocumentItem>();
    private final List<ServiceDocumentItem> functionImports = new ArrayList<ServiceDocumentItem>();
    private final List<ServiceDocumentItem> singletons = new ArrayList<ServiceDocumentItem>();
    private final List<ServiceDocumentItem> relatedServiceDocuments = new ArrayList<ServiceDocumentItem>();
    private String metadata;

    @Override
    public URI getBaseURI() {
        URI baseURI = null;
        if (this.metadata != null) {
            String metadataURI = this.getMetadata();
            baseURI = URI.create(metadataURI.substring(0, metadataURI.indexOf("$metadata")));
        }
        return baseURI;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected ServiceDocumentItem getByName(List<ServiceDocumentItem> elements, String name) {
        ServiceDocumentItem result = null;
        for (ServiceDocumentItem element : elements) {
            if (!name.equals(element.getName())) continue;
            result = element;
        }
        return result;
    }

    @Override
    public List<ServiceDocumentItem> getEntitySets() {
        return this.entitySets;
    }

    @Override
    public ServiceDocumentItem getEntitySetByName(String name) {
        return this.getByName(this.getEntitySets(), name);
    }

    @Override
    public List<ServiceDocumentItem> getFunctionImports() {
        return this.functionImports;
    }

    @Override
    public ServiceDocumentItem getFunctionImportByName(String name) {
        return this.getByName(this.getFunctionImports(), name);
    }

    @Override
    public List<ServiceDocumentItem> getSingletons() {
        return this.singletons;
    }

    @Override
    public ServiceDocumentItem getSingletonByName(String name) {
        return this.getByName(this.getSingletons(), name);
    }

    @Override
    public List<ServiceDocumentItem> getRelatedServiceDocuments() {
        return this.relatedServiceDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDocumentImpl that = (ServiceDocumentImpl)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (!this.entitySets.equals(that.entitySets)) {
            return false;
        }
        if (!this.functionImports.equals(that.functionImports)) {
            return false;
        }
        if (!this.singletons.equals(that.singletons)) {
            return false;
        }
        if (!this.relatedServiceDocuments.equals(that.relatedServiceDocuments)) {
            return false;
        }
        return !(this.metadata == null ? that.metadata != null : !this.metadata.equals(that.metadata));
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + this.entitySets.hashCode();
        result = 31 * result + this.functionImports.hashCode();
        result = 31 * result + this.singletons.hashCode();
        result = 31 * result + this.relatedServiceDocuments.hashCode();
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceDocumentImpl{title='" + this.title + "', entitySets=" + String.valueOf(this.entitySets) + ", functionImports=" + String.valueOf(this.functionImports) + ", singletons=" + String.valueOf(this.singletons) + ", relatedServiceDocuments=" + String.valueOf(this.relatedServiceDocuments) + ", metadata='" + this.metadata + "'}";
    }
}

