/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

final class TypeUtil {
    static final String MEDIA_TYPE_WILDCARD = "*";
    static final String PARAMETER_Q = "q";
    static final char WHITESPACE_CHAR = ' ';
    static final String PARAMETER_SEPARATOR = ";";
    static final String PARAMETER_KEY_VALUE_SEPARATOR = "=";
    static final String TYPE_SUBTYPE_SEPARATOR = "/";
    static final String TYPE_SUBTYPE_WILDCARD = "*";

    private TypeUtil() {
    }

    static Map<String, String> createParameterMap() {
        return new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
    }

    static void parseParameters(String parameters, Map<String, String> parameterMap) {
        if (parameters != null) {
            for (String parameter : parameters.split(PARAMETER_SEPARATOR)) {
                String[] keyValue = TypeUtil.parseParameter(parameter);
                parameterMap.put(keyValue[0], keyValue[1]);
            }
        }
    }

    static String[] parseParameter(String parameter) {
        if (parameter.isEmpty()) {
            throw new IllegalArgumentException("An empty parameter is not allowed.");
        }
        String[] keyValue = parameter.trim().split(PARAMETER_KEY_VALUE_SEPARATOR);
        if (keyValue.length != 2) {
            throw new IllegalArgumentException("Parameter '" + parameter + "' must have exactly one '=' that separates the name and the value.");
        }
        TypeUtil.validateParameterNameAndValue(keyValue[0], keyValue[1]);
        keyValue[0] = keyValue[0].toLowerCase(Locale.ENGLISH);
        return keyValue;
    }

    static void validateParameterNameAndValue(String parameterName, String parameterValue) throws IllegalArgumentException {
        if (parameterName == null || parameterName.isEmpty() || parameterName.indexOf(32) >= 0) {
            throw new IllegalArgumentException("Illegal parameter name '" + parameterName + "'.");
        }
        if (parameterValue == null || parameterValue.isEmpty()) {
            throw new IllegalArgumentException("Value parameter is NULL or empty.");
        }
        if (Character.isWhitespace(parameterValue.charAt(0))) {
            throw new IllegalArgumentException("Value of parameter '" + parameterName + "' starts with whitespace.");
        }
    }
}

