/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.core.edm.AbstractEdmStructuredType;

public class EdmComplexTypeImpl
extends AbstractEdmStructuredType
implements EdmComplexType {
    public EdmComplexTypeImpl(Edm edm, FullQualifiedName name, CsdlComplexType complexType) {
        super(edm, name, EdmTypeKind.COMPLEX, complexType);
    }

    @Override
    protected EdmStructuredType buildBaseType(FullQualifiedName baseTypeName) {
        EdmComplexType baseType = null;
        if (baseTypeName != null && (baseType = this.edm.getComplexType(baseTypeName)) == null) {
            throw new EdmException("Can't find base type with name: " + String.valueOf(baseTypeName) + " for complex type: " + this.getName());
        }
        return baseType;
    }

    @Override
    public EdmComplexType getBaseType() {
        this.checkBaseType();
        return (EdmComplexType)this.baseType;
    }

    @Override
    protected void checkBaseType() {
        if (this.baseTypeName != null && this.baseType == null) {
            this.baseType = this.buildBaseType(this.baseTypeName);
        }
    }
}

