/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public abstract class AbstractGeospatialType<T extends Geospatial>
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("([a-z]+)'SRID=([0-9]+);([a-zA-Z]+)\\((.*)\\)'");
    private static final Pattern COLLECTION_PATTERN = Pattern.compile("([a-z]+)'SRID=([0-9]+);Collection\\(([a-zA-Z]+)\\((.*)\\)\\)'");
    private final Class<T> reference;
    protected final Geospatial.Dimension dimension;
    protected final Geospatial.Type type;

    protected AbstractGeospatialType(Class<T> reference, Geospatial.Dimension dimension, Geospatial.Type type) {
        this.reference = reference;
        this.dimension = dimension;
        this.type = type;
    }

    @Override
    public Class<?> getDefaultType() {
        return this.reference;
    }

    private Matcher getMatcher(Pattern pattern, String value) throws EdmPrimitiveTypeException {
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        Geospatial.Dimension _dimension = null;
        Geospatial.Type _type = null;
        try {
            _dimension = Geospatial.Dimension.valueOf(matcher.group(1).toUpperCase());
            _type = Geospatial.Type.valueOf(matcher.group(3).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", e);
        }
        if (_dimension != this.dimension || !pattern.equals(COLLECTION_PATTERN) && _type != this.type) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        return matcher;
    }

    private Point newPoint(SRID srid, String point, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        List<String> pointCoo = this.split(point, ' ');
        if (pointCoo == null || pointCoo.size() != 2) {
            throw new EdmPrimitiveTypeException("The literal '" + point + "' has illegal content.");
        }
        Point result = new Point(this.dimension, srid);
        result.setX(EdmDouble.getInstance().valueOfString(pointCoo.get(0), isNullable, maxLength, precision, scale, isUnicode, Double.class));
        result.setY(EdmDouble.getInstance().valueOfString(pointCoo.get(1), isNullable, maxLength, precision, scale, isUnicode, Double.class));
        return result;
    }

    protected Point stringToPoint(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        Matcher matcher = this.getMatcher(PATTERN, value);
        return this.newPoint(SRID.valueOf(matcher.group(2)), matcher.group(4), isNullable, maxLength, precision, scale, isUnicode);
    }

    protected MultiPoint stringToMultiPoint(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        Matcher matcher = this.getMatcher(PATTERN, value);
        ArrayList<Point> points = new ArrayList<Point>();
        for (String pointCoo : this.split(matcher.group(4), ',')) {
            points.add(this.newPoint(null, pointCoo.substring(1, pointCoo.length() - 1), isNullable, maxLength, precision, scale, isUnicode));
        }
        return new MultiPoint(this.dimension, SRID.valueOf(matcher.group(2)), points);
    }

    private LineString newLineString(SRID srid, String lineString, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        ArrayList<Point> points = new ArrayList<Point>();
        for (String pointCoo : this.split(lineString, ',')) {
            points.add(this.newPoint(null, pointCoo, isNullable, maxLength, precision, scale, isUnicode));
        }
        return new LineString(this.dimension, srid, points);
    }

    protected LineString stringToLineString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        Matcher matcher = this.getMatcher(PATTERN, value);
        return this.newLineString(SRID.valueOf(matcher.group(2)), matcher.group(4), isNullable, maxLength, precision, scale, isUnicode);
    }

    protected MultiLineString stringToMultiLineString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        String[] stringArray;
        Matcher matcher = this.getMatcher(PATTERN, value);
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        if (matcher.group(4).contains("),(")) {
            stringArray = matcher.group(4).split("\\),\\(");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = matcher.group(4);
        }
        for (String coo : stringArray) {
            String lineString = coo;
            if (lineString.charAt(0) == '(') {
                lineString = lineString.substring(1);
            }
            if (lineString.endsWith(")")) {
                lineString = lineString.substring(0, lineString.length() - 1);
            }
            lineStrings.add(this.newLineString(null, lineString, isNullable, maxLength, precision, scale, isUnicode));
        }
        return new MultiLineString(this.dimension, SRID.valueOf(matcher.group(2)), lineStrings);
    }

    private Polygon newPolygon(SRID srid, String polygon, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        String[] first = polygon.split("\\),\\(");
        ArrayList<Point> interior = new ArrayList<Point>();
        for (String pointCoo : this.split(first[0].substring(1, first[0].length()), ',')) {
            interior.add(this.newPoint(null, pointCoo, isNullable, maxLength, precision, scale, isUnicode));
        }
        ArrayList<Point> exterior = new ArrayList<Point>();
        for (String pointCoo : this.split(first[1].substring(0, first[1].length() - 1), ',')) {
            exterior.add(this.newPoint(null, pointCoo, isNullable, maxLength, precision, scale, isUnicode));
        }
        return new Polygon(this.dimension, srid, interior, exterior);
    }

    protected Polygon stringToPolygon(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        Matcher matcher = this.getMatcher(PATTERN, value);
        return this.newPolygon(SRID.valueOf(matcher.group(2)), matcher.group(4), isNullable, maxLength, precision, scale, isUnicode);
    }

    protected MultiPolygon stringToMultiPolygon(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        String[] stringArray;
        Matcher matcher = this.getMatcher(PATTERN, value);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        if (matcher.group(4).contains(")),((")) {
            stringArray = matcher.group(4).split("\\)\\),\\(\\(");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = matcher.group(4);
        }
        for (String coo : stringArray) {
            Object polygon = coo;
            if (((String)polygon).startsWith("((")) {
                polygon = ((String)polygon).substring(1);
            }
            if (((String)polygon).endsWith("))")) {
                polygon = ((String)polygon).substring(0, ((String)polygon).length() - 1);
            }
            if (((String)polygon).charAt(0) != '(') {
                polygon = "(" + (String)polygon;
            }
            if (!((String)polygon).endsWith(")")) {
                polygon = (String)polygon + ")";
            }
            polygons.add(this.newPolygon(null, (String)polygon, isNullable, maxLength, precision, scale, isUnicode));
        }
        return new MultiPolygon(this.dimension, SRID.valueOf(matcher.group(2)), polygons);
    }

    protected GeospatialCollection stringToCollection(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        Matcher matcher = this.getMatcher(COLLECTION_PATTERN, value);
        Geospatial item = null;
        switch (Geospatial.Type.valueOf(matcher.group(3).toUpperCase())) {
            case POINT: {
                item = this.newPoint(SRID.valueOf(matcher.group(2)), matcher.group(4), isNullable, maxLength, precision, scale, isUnicode);
                break;
            }
            case MULTIPOINT: {
                ArrayList<Point> points = new ArrayList<Point>();
                for (String pointCoo : this.split(matcher.group(4), ',')) {
                    points.add(this.newPoint(null, pointCoo.substring(1, pointCoo.length() - 1), isNullable, maxLength, precision, scale, isUnicode));
                }
                item = new MultiPoint(this.dimension, SRID.valueOf(matcher.group(2)), points);
                break;
            }
            case LINESTRING: {
                item = this.newLineString(SRID.valueOf(matcher.group(2)), matcher.group(4), isNullable, maxLength, precision, scale, isUnicode);
                break;
            }
            case MULTILINESTRING: {
                ArrayList<LineString> lineStrings = new ArrayList<LineString>();
                for (String coo : this.split(matcher.group(4), ',')) {
                    lineStrings.add(this.newLineString(null, coo.substring(1, coo.length() - 1), isNullable, maxLength, precision, scale, isUnicode));
                }
                item = new MultiLineString(this.dimension, SRID.valueOf(matcher.group(2)), lineStrings);
                break;
            }
            case POLYGON: {
                item = this.newPolygon(SRID.valueOf(matcher.group(2)), matcher.group(4), isNullable, maxLength, precision, scale, isUnicode);
                break;
            }
            case MULTIPOLYGON: {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                for (String coo : this.split(matcher.group(4), ',')) {
                    polygons.add(this.newPolygon(null, coo.substring(1, coo.length() - 1), isNullable, maxLength, precision, scale, isUnicode));
                }
                item = new MultiPolygon(this.dimension, SRID.valueOf(matcher.group(2)), polygons);
                break;
            }
        }
        return new GeospatialCollection(this.dimension, SRID.valueOf(matcher.group(2)), Collections.singletonList(item));
    }

    private StringBuilder toStringBuilder(SRID srid) {
        return new StringBuilder(this.dimension.name().toLowerCase()).append('\'').append("SRID=").append(srid).append(';');
    }

    private String point(Point point, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        return EdmDouble.getInstance().valueToString(point.getX(), isNullable, maxLength, precision, scale, isUnicode) + ' ' + EdmDouble.getInstance().valueToString(point.getY(), isNullable, maxLength, precision, scale, isUnicode);
    }

    protected String toString(Point point, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (this.dimension != point.getDimension()) {
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(point) + "' is not valid.");
        }
        return this.toStringBuilder(point.getSrid()).append(this.reference.getSimpleName()).append('(').append(this.point(point, isNullable, maxLength, precision, scale, isUnicode)).append(")'").toString();
    }

    protected String toString(MultiPoint multiPoint, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (this.dimension != multiPoint.getDimension()) {
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(multiPoint) + "' is not valid.");
        }
        StringBuilder result = this.toStringBuilder(multiPoint.getSrid()).append(this.reference.getSimpleName()).append('(');
        Iterator itor = multiPoint.iterator();
        while (itor.hasNext()) {
            result.append('(').append(this.point((Point)itor.next(), isNullable, maxLength, precision, scale, isUnicode)).append(')');
            if (!itor.hasNext()) continue;
            result.append(',');
        }
        return result.append(")'").toString();
    }

    private String lineString(LineString lineString, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        StringBuilder result = new StringBuilder();
        Iterator itor = lineString.iterator();
        while (itor.hasNext()) {
            result.append(this.point((Point)itor.next(), isNullable, maxLength, precision, scale, isUnicode));
            if (!itor.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }

    protected String toString(LineString lineString, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (this.dimension != lineString.getDimension()) {
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(lineString) + "' is not valid.");
        }
        return this.toStringBuilder(lineString.getSrid()).append(this.reference.getSimpleName()).append('(').append(this.lineString(lineString, isNullable, maxLength, precision, scale, isUnicode)).append(")'").toString();
    }

    protected String toString(MultiLineString multiLineString, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (this.dimension != multiLineString.getDimension()) {
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(multiLineString) + "' is not valid.");
        }
        StringBuilder result = this.toStringBuilder(multiLineString.getSrid()).append(this.reference.getSimpleName()).append('(');
        Iterator itor = multiLineString.iterator();
        while (itor.hasNext()) {
            result.append('(').append(this.lineString((LineString)itor.next(), isNullable, maxLength, precision, scale, isUnicode)).append(')');
            if (!itor.hasNext()) continue;
            result.append(',');
        }
        return result.append(")'").toString();
    }

    private String polygon(Polygon polygon, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        StringBuilder result = new StringBuilder();
        result.append('(');
        Iterator<Point> itor = polygon.getInterior().iterator();
        while (itor.hasNext()) {
            result.append(this.point(itor.next(), isNullable, maxLength, precision, scale, isUnicode));
            if (!itor.hasNext()) continue;
            result.append(',');
        }
        result.append("),(");
        itor = polygon.getExterior().iterator();
        while (itor.hasNext()) {
            result.append(this.point(itor.next(), isNullable, maxLength, precision, scale, isUnicode));
            if (!itor.hasNext()) continue;
            result.append(',');
        }
        return result.append(')').toString();
    }

    protected String toString(Polygon polygon, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (this.dimension != polygon.getDimension()) {
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(polygon) + "' is not valid.");
        }
        return this.toStringBuilder(polygon.getSrid()).append(this.reference.getSimpleName()).append('(').append(this.polygon(polygon, isNullable, maxLength, precision, scale, isUnicode)).append(")'").toString();
    }

    protected String toString(MultiPolygon multiPolygon, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (this.dimension != multiPolygon.getDimension()) {
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(multiPolygon) + "' is not valid.");
        }
        StringBuilder result = this.toStringBuilder(multiPolygon.getSrid()).append(this.reference.getSimpleName()).append('(');
        Iterator itor = multiPolygon.iterator();
        while (itor.hasNext()) {
            result.append('(').append(this.polygon((Polygon)itor.next(), isNullable, maxLength, precision, scale, isUnicode)).append(')');
            if (!itor.hasNext()) continue;
            result.append(',');
        }
        return result.append(")'").toString();
    }

    protected String toString(GeospatialCollection collection, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (this.dimension != collection.getDimension()) {
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(collection) + "' is not valid.");
        }
        StringBuilder result = this.toStringBuilder(collection.getSrid()).append("Collection(");
        if (collection.iterator().hasNext()) {
            Geospatial item = (Geospatial)collection.iterator().next();
            result.append(item.getClass().getSimpleName()).append('(');
            switch (item.getEdmPrimitiveTypeKind()) {
                case GeographyPoint: 
                case GeometryPoint: {
                    result.append(this.point((Point)item, isNullable, maxLength, precision, scale, isUnicode));
                    break;
                }
                case GeographyMultiPoint: 
                case GeometryMultiPoint: {
                    Iterator itor = ((MultiPoint)item).iterator();
                    while (itor.hasNext()) {
                        result.append('(').append(this.point((Point)itor.next(), isNullable, maxLength, precision, scale, isUnicode)).append(')');
                        if (!itor.hasNext()) continue;
                        result.append(',');
                    }
                    break;
                }
                case GeographyLineString: 
                case GeometryLineString: {
                    result.append(this.lineString((LineString)item, isNullable, maxLength, precision, scale, isUnicode));
                    break;
                }
                case GeographyMultiLineString: 
                case GeometryMultiLineString: {
                    Iterator itor = ((MultiLineString)item).iterator();
                    while (itor.hasNext()) {
                        result.append('(').append(this.lineString((LineString)itor.next(), isNullable, maxLength, precision, scale, isUnicode)).append(')');
                        if (!itor.hasNext()) continue;
                        result.append(',');
                    }
                    break;
                }
                case GeographyPolygon: 
                case GeometryPolygon: {
                    result.append(this.polygon((Polygon)item, isNullable, maxLength, precision, scale, isUnicode));
                    break;
                }
                case GeographyMultiPolygon: 
                case GeometryMultiPolygon: {
                    Iterator itor = ((MultiPolygon)item).iterator();
                    while (itor.hasNext()) {
                        result.append('(').append(this.polygon((Polygon)itor.next(), isNullable, maxLength, precision, scale, isUnicode)).append(')');
                        if (!itor.hasNext()) continue;
                        result.append(',');
                    }
                    break;
                }
            }
            result.append(')');
        }
        return result.append(")'").toString();
    }

    private List<String> split(String input, char separator) {
        int end;
        if (input == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        while ((end = input.indexOf(separator, start)) >= 0) {
            list.add(input.substring(start, end));
            start = end + 1;
        }
        if (start < input.length()) {
            list.add(input.substring(start));
        }
        return list;
    }
}

