/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmDate
extends SingletonPrimitiveType {
    private static final EdmDate INSTANCE = new EdmDate();

    public static EdmDate getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        LocalDate date;
        try {
            date = LocalDate.parse(value);
        }
        catch (DateTimeParseException ex) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        if (returnType.isAssignableFrom(LocalDate.class)) {
            return (T)date;
        }
        if (returnType.isAssignableFrom(java.sql.Date.class)) {
            return (T)java.sql.Date.valueOf(date);
        }
        ZonedDateTime zdt = LocalDateTime.of(date, LocalTime.MIDNIGHT).atZone(ZoneId.systemDefault());
        if (returnType.isAssignableFrom(Calendar.class)) {
            return (T)GregorianCalendar.from(zdt);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return (T)Long.valueOf(zdt.toInstant().toEpochMilli());
        }
        if (returnType.isAssignableFrom(java.sql.Date.class)) {
            throw new EdmPrimitiveTypeException("The value type " + String.valueOf(returnType) + " is not supported.");
        }
        if (returnType.isAssignableFrom(Timestamp.class)) {
            return (T)Timestamp.from(zdt.toInstant());
        }
        if (returnType.isAssignableFrom(Date.class)) {
            return (T)Date.from(zdt.toInstant());
        }
        throw new EdmPrimitiveTypeException("The value type " + String.valueOf(returnType) + " is not supported.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        long millis;
        if (value instanceof LocalDate) {
            return value.toString();
        }
        if (value instanceof java.sql.Date) {
            return value.toString();
        }
        if (value instanceof GregorianCalendar) {
            GregorianCalendar calendar = (GregorianCalendar)value;
            return calendar.toZonedDateTime().toLocalDate().toString();
        }
        if (value instanceof Long) {
            millis = (Long)value;
        } else if (value instanceof Date) {
            millis = ((Date)value).getTime();
        } else {
            throw new EdmPrimitiveTypeException("The value type " + String.valueOf(value.getClass()) + " is not supported.");
        }
        ZonedDateTime zdt = Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault());
        return zdt.toLocalDate().toString();
    }
}

