/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;

public final class EdmGeographyPoint
extends AbstractGeospatialType<Point> {
    private static final EdmGeographyPoint INSTANCE = new EdmGeographyPoint();

    public static EdmGeographyPoint getInstance() {
        return INSTANCE;
    }

    public EdmGeographyPoint() {
        super(Point.class, Geospatial.Dimension.GEOGRAPHY, Geospatial.Type.POINT);
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Point point = this.stringToPoint(value, isNullable, maxLength, precision, scale, isUnicode);
        if (returnType.isAssignableFrom(Point.class)) {
            return returnType.cast(point);
        }
        throw new EdmPrimitiveTypeException("The value type " + String.valueOf(returnType) + " is not supported.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Point) {
            return this.toString((Point)value, isNullable, maxLength, precision, scale, isUnicode);
        }
        throw new EdmPrimitiveTypeException("The value type " + String.valueOf(value.getClass()) + " is not supported.");
    }
}

