/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmSingle
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("(?:\\+|-)?\\p{Digit}{1,9}(?:\\.\\p{Digit}{1,9})?(?:(?:E|e)(?:\\+|-)?\\p{Digit}{1,2})?");
    private static final EdmSingle INSTANCE = new EdmSingle();

    public static EdmSingle getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return primitiveType instanceof EdmByte || primitiveType instanceof EdmSByte || primitiveType instanceof EdmInt16 || primitiveType instanceof EdmInt32 || primitiveType instanceof EdmInt64 || primitiveType instanceof EdmSingle;
    }

    @Override
    public Class<?> getDefaultType() {
        return Float.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Float result = null;
        BigDecimal bigDecimalValue = null;
        if (value.equals("-INF")) {
            result = Float.valueOf(Float.NEGATIVE_INFINITY);
        } else if (value.equals("INF")) {
            result = Float.valueOf(Float.POSITIVE_INFINITY);
        } else if (value.equals("NaN")) {
            result = Float.valueOf(Float.NaN);
        } else {
            if (!PATTERN.matcher(value).matches()) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
            bigDecimalValue = new BigDecimal(value);
            result = Float.valueOf(bigDecimalValue.floatValue());
            if (result.isInfinite()) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
        }
        if (returnType.isAssignableFrom(Float.class)) {
            return returnType.cast(result);
        }
        if (result.isInfinite() || result.isNaN()) {
            if (returnType.isAssignableFrom(Double.class)) {
                return returnType.cast(result.doubleValue());
            }
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + String.valueOf(returnType) + ".");
        }
        try {
            return EdmDecimal.convertDecimal(bigDecimalValue, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + String.valueOf(returnType) + ".", e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + String.valueOf(returnType) + " is not supported.", e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Long || value instanceof Integer) {
            if (Math.abs(((Number)value).longValue()) < 0x400000L) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(value) + "' is not valid.");
        }
        if (value instanceof Short || value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite()) {
                return (Double)value == Double.NEGATIVE_INFINITY ? "-INF" : "INF";
            }
            String floatString = Float.toString(((Double)value).floatValue());
            if (floatString.equals(value.toString())) {
                return floatString;
            }
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(value) + "' is not valid.");
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() == Float.NEGATIVE_INFINITY ? "-INF" : (((Float)value).floatValue() == Float.POSITIVE_INFINITY ? "INF" : value.toString());
        }
        if (value instanceof BigDecimal) {
            float floatValue = ((BigDecimal)value).floatValue();
            if (!Float.isInfinite(floatValue) && BigDecimal.valueOf(floatValue).compareTo((BigDecimal)value) == 0) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(value) + "' is not valid.");
        }
        throw new EdmPrimitiveTypeException("The value type " + String.valueOf(value.getClass()) + " is not supported.");
    }
}

