/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotatable;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmMember;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.TargetType;
import org.apache.olingo.commons.api.edm.annotation.EdmConstantExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmDynamicExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmLogicalOrComparisonExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmNot;
import org.apache.olingo.commons.api.edm.annotation.EdmPropertyValue;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.edmx.EdmxReferenceInclude;
import org.apache.olingo.commons.api.edmx.EdmxReferenceIncludeAnnotation;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;

public class MetadataDocumentXmlSerializer {
    private static final String TRUE = "true";
    private static final String XML_EXTENDS = "Extends";
    private static final String XML_TARGET = "Target";
    private static final String XML_PATH = "Path";
    private static final String XML_NAVIGATION_PROPERTY_BINDING = "NavigationPropertyBinding";
    private static final String XML_VALUE = "Value";
    private static final String XML_MEMBER = "Member";
    private static final String XML_UNDERLYING_TYPE = "UnderlyingType";
    private static final String XML_IS_FLAGS = "IsFlags";
    private static final String XML_ENUM_TYPE = "EnumType";
    private static final String XML_PROPERTY_REF = "PropertyRef";
    private static final String XML_KEY = "Key";
    private static final String XML_SCALE = "Scale";
    private static final String XML_SRID = "SRID";
    private static final String XML_PRECISION = "Precision";
    private static final String XML_MAX_LENGTH = "MaxLength";
    private static final String XML_DEFAULT_VALUE = "DefaultValue";
    private static final String XML_UNICODE = "Unicode";
    private static final String XML_PROPERTY = "Property";
    private static final String XML_PARTNER = "Partner";
    private static final String XML_NULLABLE = "Nullable";
    private static final String XML_NAVIGATION_PROPERTY = "NavigationProperty";
    private static final String XML_HAS_STREAM = "HasStream";
    private static final String XML_BASE_TYPE = "BaseType";
    private static final String XML_COMPLEX_TYPE = "ComplexType";
    private static final String XML_RETURN_TYPE = "ReturnType";
    private static final String XML_TYPE = "Type";
    private static final String XML_PARAMETER = "Parameter";
    private static final String XML_IS_COMPOSABLE = "IsComposable";
    private static final String XML_IS_BOUND = "IsBound";
    private static final String XML_ENTITY_TYPE = "EntityType";
    private static final String XML_SINGLETON_TYPE = "Type";
    private static final String XML_SINGLETON = "Singleton";
    private static final String XML_ACTION = "Action";
    private static final String XML_ACTION_IMPORT = "ActionImport";
    private static final String XML_INCLUDE_IN_SERVICE_DOCUMENT = "IncludeInServiceDocument";
    private static final String XML_ENTITY_SET = "EntitySet";
    private static final String XML_FUNCTION = "Function";
    private static final String XML_FUNCTION_IMPORT = "FunctionImport";
    private static final String XML_NAME = "Name";
    private static final String XML_ENTITY_CONTAINER = "EntityContainer";
    private static final String XML_ALIAS = "Alias";
    private static final String XML_NAMESPACE = "Namespace";
    private static final String XML_TYPE_DEFINITION = "TypeDefinition";
    private static final String XML_ANNOTATION = "Annotation";
    private static final String REFERENCE = "Reference";
    private static final String INCLUDE = "Include";
    private static final String INCLUDE_ANNOTATIONS = "IncludeAnnotations";
    private static final String XML_TERM_NAMESPACE = "TermNamespace";
    private static final String XML_TARGET_NAMESPACE = "TargetNamespace";
    private static final String XML_QUALIFIER = "Qualifier";
    private static final String URI = "Uri";
    private static final String SCHEMA = "Schema";
    private static final String DATA_SERVICES = "DataServices";
    private static final String ABSTRACT = "Abstract";
    private static final String XML_ANNOTATIONS = "Annotations";
    private static final String OPEN_TYPE = "OpenType";
    private static final String EDMX = "Edmx";
    private static final String PREFIX_EDMX = "edmx";
    private static final String NS_EDMX = "http://docs.oasis-open.org/odata/ns/edmx";
    private static final String NS_EDM = "http://docs.oasis-open.org/odata/ns/edm";
    private static final String XML_ENTITY_SET_PATH = "EntitySetPath";
    private static final String XML_CONTAINS_TARGET = "ContainsTarget";
    private static final String XML_TERM_ATT = "Term";
    private static final String XML_QUALIFIER_ATT = "Qualifier";
    private static final String XML_PROPERTY_VALUE = "PropertyValue";
    private static final String XML_BASE_TERM = "BaseTerm";
    private static final String XML_APPLIES_TO = "AppliesTo";
    private static final String XML_ON_DELETE = "OnDelete";
    private static final String XML_ON_DELETE_PROPERTY = "Action";
    private final ServiceMetadata serviceMetadata;
    private final Map<String, String> namespaceToAlias = new HashMap<String, String>();

    public MetadataDocumentXmlSerializer(ServiceMetadata serviceMetadata) throws SerializerException {
        if (serviceMetadata == null || serviceMetadata.getEdm() == null) {
            throw new SerializerException("Service Metadata and EDM must not be null for a service.", SerializerException.MessageKeys.NULL_METADATA_OR_EDM, new String[0]);
        }
        this.serviceMetadata = serviceMetadata;
    }

    public void writeMetadataDocument(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
        writer.setPrefix(PREFIX_EDMX, NS_EDMX);
        writer.setDefaultNamespace(NS_EDMX);
        writer.writeStartElement(PREFIX_EDMX, EDMX, NS_EDMX);
        writer.writeAttribute("Version", "4.0");
        writer.writeNamespace(PREFIX_EDMX, NS_EDMX);
        this.appendReference(writer);
        this.appendDataServices(writer);
        writer.writeEndDocument();
    }

    private void appendDataServices(XMLStreamWriter writer) throws XMLStreamException {
        writer.setDefaultNamespace(NS_EDM);
        writer.writeStartElement(NS_EDMX, DATA_SERVICES);
        for (EdmSchema schema : this.serviceMetadata.getEdm().getSchemas()) {
            this.appendSchema(writer, schema);
        }
        writer.writeEndElement();
    }

    private void appendSchema(XMLStreamWriter writer, EdmSchema schema) throws XMLStreamException {
        writer.writeStartElement(NS_EDM, SCHEMA);
        writer.writeDefaultNamespace(NS_EDM);
        writer.writeAttribute(XML_NAMESPACE, schema.getNamespace());
        if (schema.getAlias() != null) {
            writer.writeAttribute(XML_ALIAS, schema.getAlias());
            this.namespaceToAlias.put(schema.getNamespace(), schema.getAlias());
        }
        this.appendEnumTypes(writer, schema.getEnumTypes());
        this.appendTypeDefinitions(writer, schema.getTypeDefinitions());
        this.appendEntityTypes(writer, schema.getEntityTypes());
        this.appendComplexTypes(writer, schema.getComplexTypes());
        this.appendActions(writer, schema.getActions());
        this.appendFunctions(writer, schema.getFunctions());
        this.appendTerms(writer, schema.getTerms());
        this.appendEntityContainer(writer, schema.getEntityContainer());
        this.appendAnnotationGroups(writer, schema.getAnnotationGroups());
        this.appendAnnotations(writer, schema);
        writer.writeEndElement();
    }

    private void appendTerms(XMLStreamWriter writer, List<EdmTerm> terms) throws XMLStreamException {
        for (EdmTerm term : terms) {
            writer.writeStartElement(XML_TERM_ATT);
            writer.writeAttribute(XML_NAME, term.getName());
            writer.writeAttribute("Type", this.getAliasedFullQualifiedName(term.getType(), false));
            if (term.getBaseTerm() != null) {
                writer.writeAttribute(XML_BASE_TERM, this.getAliasedFullQualifiedName(term.getBaseTerm().getFullQualifiedName(), false));
            }
            if (term.getAppliesTo() != null && !term.getAppliesTo().isEmpty()) {
                Object appliesToString = "";
                boolean first = true;
                for (TargetType target : term.getAppliesTo()) {
                    if (first) {
                        first = false;
                        appliesToString = target.toString();
                        continue;
                    }
                    appliesToString = (String)appliesToString + " " + target.toString();
                }
                writer.writeAttribute(XML_APPLIES_TO, (String)appliesToString);
            }
            if (!term.isNullable()) {
                writer.writeAttribute(XML_NULLABLE, "" + term.isNullable());
            }
            if (term.getDefaultValue() != null) {
                writer.writeAttribute(XML_DEFAULT_VALUE, term.getDefaultValue());
            }
            if (term.getMaxLength() != null) {
                writer.writeAttribute(XML_MAX_LENGTH, "" + term.getMaxLength());
            }
            if (term.getPrecision() != null) {
                writer.writeAttribute(XML_PRECISION, "" + term.getPrecision());
            }
            if (term.getScale() != null) {
                writer.writeAttribute(XML_SCALE, "" + term.getScale());
            }
            this.appendAnnotations(writer, term);
            writer.writeEndElement();
        }
    }

    private void appendAnnotationGroups(XMLStreamWriter writer, List<EdmAnnotations> annotationGroups) throws XMLStreamException {
        for (EdmAnnotations annotationGroup : annotationGroups) {
            this.appendAnnotationGroup(writer, annotationGroup);
        }
    }

    private void appendAnnotationGroup(XMLStreamWriter writer, EdmAnnotations annotationGroup) throws XMLStreamException {
        writer.writeStartElement(XML_ANNOTATIONS);
        writer.writeAttribute(XML_TARGET, annotationGroup.getTargetPath());
        if (annotationGroup.getQualifier() != null) {
            writer.writeAttribute("Qualifier", annotationGroup.getQualifier());
        }
        this.appendAnnotations(writer, annotationGroup);
        writer.writeEndElement();
    }

    private void appendAnnotations(XMLStreamWriter writer, EdmAnnotatable annotatable) throws XMLStreamException {
        List<EdmAnnotation> annotations = annotatable.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (EdmAnnotation annotation : annotations) {
                writer.writeStartElement(XML_ANNOTATION);
                if (annotation.getTerm() != null) {
                    writer.writeAttribute(XML_TERM_ATT, this.getAliasedFullQualifiedName(annotation.getTerm().getFullQualifiedName(), false));
                }
                if (annotation.getQualifier() != null) {
                    writer.writeAttribute("Qualifier", annotation.getQualifier());
                }
                this.appendExpression(writer, annotation.getExpression());
                this.appendAnnotations(writer, annotation);
                writer.writeEndElement();
            }
        }
    }

    private void appendExpression(XMLStreamWriter writer, EdmExpression expression) throws XMLStreamException {
        if (expression == null) {
            return;
        }
        if (expression.isConstant()) {
            this.appendConstantExpression(writer, expression.asConstant());
        } else if (expression.isDynamic()) {
            this.appendDynamicExpression(writer, expression.asDynamic());
        } else {
            throw new IllegalArgumentException("Unkown expressiontype in metadata");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void appendDynamicExpression(XMLStreamWriter writer, EdmDynamicExpression dynExp) throws XMLStreamException {
        writer.writeStartElement(dynExp.getExpressionName());
        switch (1.$SwitchMap$org$apache$olingo$commons$api$edm$annotation$EdmExpression$EdmExpressionType[dynExp.getExpressionType().ordinal()]) {
            case 1: {
                this.appendLogicalOrComparisonExpression(writer, dynExp.asAnd());
                break;
            }
            case 2: {
                this.appendLogicalOrComparisonExpression(writer, dynExp.asOr());
                break;
            }
            case 3: {
                this.appendNotExpression(writer, dynExp.asNot());
                break;
            }
            case 4: {
                this.appendLogicalOrComparisonExpression(writer, dynExp.asEq());
                break;
            }
            case 5: {
                this.appendLogicalOrComparisonExpression(writer, dynExp.asNe());
                break;
            }
            case 6: {
                this.appendLogicalOrComparisonExpression(writer, dynExp.asGt());
                break;
            }
            case 7: {
                this.appendLogicalOrComparisonExpression(writer, dynExp.asGe());
                break;
            }
            case 8: {
                this.appendLogicalOrComparisonExpression(writer, dynExp.asLt());
                break;
            }
            case 9: {
                this.appendLogicalOrComparisonExpression(writer, dynExp.asLe());
                break;
            }
            case 10: {
                writer.writeCharacters(dynExp.asAnnotationPath().getValue());
                break;
            }
            case 11: {
                asApply = dynExp.asApply();
                writer.writeAttribute("Function", asApply.getFunction());
                for (EdmExpression parameter : asApply.getParameters()) {
                    this.appendExpression(writer, parameter);
                }
                this.appendAnnotations(writer, asApply);
                break;
            }
            case 12: {
                asCast = dynExp.asCast();
                writer.writeAttribute("Type", this.getAliasedFullQualifiedName(asCast.getType(), false));
                if (asCast.getMaxLength() != null) {
                    writer.writeAttribute("MaxLength", "" + asCast.getMaxLength());
                }
                if (asCast.getPrecision() != null) {
                    writer.writeAttribute("Precision", "" + asCast.getPrecision());
                }
                if (asCast.getScale() != null) {
                    writer.writeAttribute("Scale", "" + asCast.getScale());
                }
                this.appendExpression(writer, asCast.getValue());
                this.appendAnnotations(writer, asCast);
                break;
            }
            case 13: {
                for (EdmExpression item : dynExp.asCollection().getItems()) {
                    this.appendExpression(writer, item);
                }
                break;
            }
            case 14: {
                asIf = dynExp.asIf();
                this.appendExpression(writer, asIf.getGuard());
                this.appendExpression(writer, asIf.getThen());
                this.appendExpression(writer, asIf.getElse());
                this.appendAnnotations(writer, asIf);
                break;
            }
            case 15: {
                asIsOf = dynExp.asIsOf();
                writer.writeAttribute("Type", this.getAliasedFullQualifiedName(asIsOf.getType(), false));
                if (asIsOf.getMaxLength() != null) {
                    writer.writeAttribute("MaxLength", "" + asIsOf.getMaxLength());
                }
                if (asIsOf.getPrecision() != null) {
                    writer.writeAttribute("Precision", "" + asIsOf.getPrecision());
                }
                if (asIsOf.getScale() != null) {
                    writer.writeAttribute("Scale", "" + asIsOf.getScale());
                }
                this.appendExpression(writer, asIsOf.getValue());
                this.appendAnnotations(writer, asIsOf);
                break;
            }
            case 16: {
                asLabeledElement = dynExp.asLabeledElement();
                writer.writeAttribute("Name", asLabeledElement.getName());
                this.appendExpression(writer, asLabeledElement.getValue());
                this.appendAnnotations(writer, asLabeledElement);
                break;
            }
            case 17: {
                asLabeledElementReference = dynExp.asLabeledElementReference();
                writer.writeCharacters(asLabeledElementReference.getValue());
                break;
            }
            case 18: {
                this.appendAnnotations(writer, dynExp.asNull());
                break;
            }
            case 19: {
                asNavigationPropertyPath = dynExp.asNavigationPropertyPath();
                writer.writeCharacters(asNavigationPropertyPath.getValue());
                break;
            }
            case 20: {
                asPath = dynExp.asPath();
                writer.writeCharacters(asPath.getValue());
                break;
            }
            case 21: {
                asPropertyPath = dynExp.asPropertyPath();
                writer.writeCharacters(asPropertyPath.getValue());
                break;
            }
            case 22: {
                asRecord = dynExp.asRecord();
                try {
                    structuredType = asRecord.getType();
                    if (structuredType != null) {
                        writer.writeAttribute("Type", this.getAliasedFullQualifiedName(structuredType, false));
                    }
                }
                catch (EdmException e) {
                    type = asRecord.getTypeFQN();
                    if (type == null) ** GOTO lbl113
                    writer.writeAttribute("Type", this.getAliasedFullQualifiedName(type, false));
                }
lbl113:
                // 4 sources

                for (EdmPropertyValue propValue : asRecord.getPropertyValues()) {
                    writer.writeStartElement("PropertyValue");
                    writer.writeAttribute("Property", propValue.getProperty());
                    this.appendExpression(writer, propValue.getValue());
                    this.appendAnnotations(writer, propValue);
                    writer.writeEndElement();
                }
                this.appendAnnotations(writer, asRecord);
                break;
            }
            case 23: {
                asUrlRef = dynExp.asUrlRef();
                this.appendExpression(writer, asUrlRef.getValue());
                this.appendAnnotations(writer, asUrlRef);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown ExpressionType for dynamic expression: " + String.valueOf((Object)dynExp.getExpressionType()));
            }
        }
        writer.writeEndElement();
    }

    private void appendNotExpression(XMLStreamWriter writer, EdmNot exp) throws XMLStreamException {
        this.appendExpression(writer, exp.getLeftExpression());
        this.appendAnnotations(writer, exp);
    }

    private void appendLogicalOrComparisonExpression(XMLStreamWriter writer, EdmLogicalOrComparisonExpression exp) throws XMLStreamException {
        this.appendExpression(writer, exp.getLeftExpression());
        this.appendExpression(writer, exp.getRightExpression());
        this.appendAnnotations(writer, exp);
    }

    private void appendConstantExpression(XMLStreamWriter writer, EdmConstantExpression constExp) throws XMLStreamException {
        writer.writeStartElement(constExp.getExpressionName());
        writer.writeCharacters(constExp.getValueAsString());
        writer.writeEndElement();
    }

    private void appendTypeDefinitions(XMLStreamWriter writer, List<EdmTypeDefinition> typeDefinitions) throws XMLStreamException {
        for (EdmTypeDefinition definition : typeDefinitions) {
            writer.writeStartElement(XML_TYPE_DEFINITION);
            writer.writeAttribute(XML_NAME, definition.getName());
            writer.writeAttribute(XML_UNDERLYING_TYPE, this.getFullQualifiedName(definition.getUnderlyingType(), false));
            if (definition.getMaxLength() != null) {
                writer.writeAttribute(XML_MAX_LENGTH, "" + definition.getMaxLength());
            }
            if (definition.getPrecision() != null) {
                writer.writeAttribute(XML_PRECISION, "" + definition.getPrecision());
            }
            if (definition.getScale() != null) {
                writer.writeAttribute(XML_SCALE, "" + definition.getScale());
            }
            this.appendAnnotations(writer, definition);
            writer.writeEndElement();
        }
    }

    private void appendEntityContainer(XMLStreamWriter writer, EdmEntityContainer container) throws XMLStreamException {
        if (container != null) {
            writer.writeStartElement(XML_ENTITY_CONTAINER);
            writer.writeAttribute(XML_NAME, container.getName());
            FullQualifiedName parentContainerName = container.getParentContainerName();
            if (parentContainerName != null) {
                Object parentContainerNameString = this.namespaceToAlias.get(parentContainerName.getNamespace()) != null ? this.namespaceToAlias.get(parentContainerName.getNamespace()) + "." + parentContainerName.getName() : parentContainerName.getFullQualifiedNameAsString();
                writer.writeAttribute(XML_EXTENDS, (String)parentContainerNameString);
            }
            this.appendEntitySets(writer, container.getEntitySets());
            this.appendActionImports(writer, container.getActionImports());
            String containerNamespace = this.namespaceToAlias.get(container.getNamespace()) != null ? this.namespaceToAlias.get(container.getNamespace()) : container.getNamespace();
            this.appendFunctionImports(writer, container.getFunctionImports(), containerNamespace);
            this.appendSingletons(writer, container.getSingletons());
            this.appendAnnotations(writer, container);
            writer.writeEndElement();
        }
    }

    private void appendFunctionImports(XMLStreamWriter writer, List<EdmFunctionImport> functionImports, String containerNamespace) throws XMLStreamException {
        for (EdmFunctionImport functionImport : functionImports) {
            writer.writeStartElement(XML_FUNCTION_IMPORT);
            writer.writeAttribute(XML_NAME, functionImport.getName());
            FullQualifiedName functionFqn = functionImport.getFunctionFqn();
            Object functionFQNString = this.namespaceToAlias.get(functionFqn.getNamespace()) != null ? this.namespaceToAlias.get(functionFqn.getNamespace()) + "." + functionFqn.getName() : functionFqn.getFullQualifiedNameAsString();
            writer.writeAttribute(XML_FUNCTION, (String)functionFQNString);
            EdmEntitySet returnedEntitySet = functionImport.getReturnedEntitySet();
            if (returnedEntitySet != null) {
                String returnedEntitySetNamespace = returnedEntitySet.getEntityContainer().getNamespace();
                if (null != returnedEntitySetNamespace && returnedEntitySetNamespace.equals(containerNamespace) || this.namespaceToAlias.get(returnedEntitySetNamespace) != null && this.namespaceToAlias.get(returnedEntitySetNamespace).equals(containerNamespace)) {
                    writer.writeAttribute(XML_ENTITY_SET, returnedEntitySet.getName());
                } else {
                    writer.writeAttribute(XML_ENTITY_SET, containerNamespace + "." + returnedEntitySet.getName());
                }
            }
            if (functionImport.isIncludeInServiceDocument()) {
                writer.writeAttribute(XML_INCLUDE_IN_SERVICE_DOCUMENT, "" + functionImport.isIncludeInServiceDocument());
            }
            this.appendAnnotations(writer, functionImport);
            writer.writeEndElement();
        }
    }

    private void appendActionImports(XMLStreamWriter writer, List<EdmActionImport> actionImports) throws XMLStreamException {
        for (EdmActionImport actionImport : actionImports) {
            writer.writeStartElement(XML_ACTION_IMPORT);
            writer.writeAttribute(XML_NAME, actionImport.getName());
            writer.writeAttribute("Action", this.getAliasedFullQualifiedName(actionImport.getUnboundAction(), false));
            EdmEntitySet returnedEntitySet = actionImport.getReturnedEntitySet();
            if (returnedEntitySet != null) {
                String fullQualifiedName = returnedEntitySet.getEntityContainer().getFullQualifiedName().getFullQualifiedNameAsString();
                if (!actionImport.getEntityContainer().getFullQualifiedName().getFullQualifiedNameAsString().equalsIgnoreCase(fullQualifiedName)) {
                    writer.writeAttribute(XML_ENTITY_SET, fullQualifiedName + "/" + returnedEntitySet.getName());
                } else {
                    writer.writeAttribute(XML_ENTITY_SET, returnedEntitySet.getName());
                }
            }
            this.appendAnnotations(writer, actionImport);
            writer.writeEndElement();
        }
    }

    private void appendSingletons(XMLStreamWriter writer, List<EdmSingleton> singletons) throws XMLStreamException {
        for (EdmSingleton singleton : singletons) {
            writer.writeStartElement(XML_SINGLETON);
            writer.writeAttribute(XML_NAME, singleton.getName());
            writer.writeAttribute("Type", this.getAliasedFullQualifiedName(singleton.getEntityType(), false));
            this.appendNavigationPropertyBindings(writer, singleton);
            this.appendAnnotations(writer, singleton);
            writer.writeEndElement();
        }
    }

    private void appendNavigationPropertyBindings(XMLStreamWriter writer, EdmBindingTarget bindingTarget) throws XMLStreamException {
        if (bindingTarget.getNavigationPropertyBindings() != null) {
            for (EdmNavigationPropertyBinding binding : bindingTarget.getNavigationPropertyBindings()) {
                writer.writeEmptyElement(XML_NAVIGATION_PROPERTY_BINDING);
                writer.writeAttribute(XML_PATH, binding.getPath());
                writer.writeAttribute(XML_TARGET, binding.getTarget());
            }
        }
    }

    private void appendEntitySets(XMLStreamWriter writer, List<EdmEntitySet> entitySets) throws XMLStreamException {
        for (EdmEntitySet entitySet : entitySets) {
            writer.writeStartElement(XML_ENTITY_SET);
            writer.writeAttribute(XML_NAME, entitySet.getName());
            writer.writeAttribute(XML_ENTITY_TYPE, this.getAliasedFullQualifiedName(entitySet.getEntityType(), false));
            if (!entitySet.isIncludeInServiceDocument()) {
                writer.writeAttribute(XML_INCLUDE_IN_SERVICE_DOCUMENT, "" + entitySet.isIncludeInServiceDocument());
            }
            this.appendNavigationPropertyBindings(writer, entitySet);
            this.appendAnnotations(writer, entitySet);
            writer.writeEndElement();
        }
    }

    private void appendFunctions(XMLStreamWriter writer, List<EdmFunction> functions) throws XMLStreamException {
        for (EdmFunction function : functions) {
            writer.writeStartElement(XML_FUNCTION);
            writer.writeAttribute(XML_NAME, function.getName());
            if (function.getEntitySetPath() != null) {
                writer.writeAttribute(XML_ENTITY_SET_PATH, function.getEntitySetPath());
            }
            if (function.isBound()) {
                writer.writeAttribute(XML_IS_BOUND, "" + function.isBound());
            }
            if (function.isComposable()) {
                writer.writeAttribute(XML_IS_COMPOSABLE, "" + function.isComposable());
            }
            this.appendOperationParameters(writer, function);
            this.appendOperationReturnType(writer, function);
            this.appendAnnotations(writer, function);
            writer.writeEndElement();
        }
    }

    private void appendOperationReturnType(XMLStreamWriter writer, EdmOperation operation) throws XMLStreamException {
        EdmReturnType returnType = operation.getReturnType();
        if (returnType != null) {
            writer.writeEmptyElement(XML_RETURN_TYPE);
            String returnTypeFqnString = EdmTypeKind.PRIMITIVE.equals((Object)returnType.getType().getKind()) ? this.getFullQualifiedName(returnType.getType(), returnType.isCollection()) : this.getAliasedFullQualifiedName(returnType.getType(), returnType.isCollection());
            writer.writeAttribute("Type", returnTypeFqnString);
            this.appendReturnTypeFacets(writer, returnType);
        }
    }

    private void appendOperationParameters(XMLStreamWriter writer, EdmOperation operation) throws XMLStreamException {
        for (String parameterName : operation.getParameterNames()) {
            EdmParameter parameter = operation.getParameter(parameterName);
            writer.writeStartElement(XML_PARAMETER);
            writer.writeAttribute(XML_NAME, parameterName);
            String typeFqnString = EdmTypeKind.PRIMITIVE.equals((Object)parameter.getType().getKind()) ? this.getFullQualifiedName(parameter.getType(), parameter.isCollection()) : this.getAliasedFullQualifiedName(parameter.getType(), parameter.isCollection());
            writer.writeAttribute("Type", typeFqnString);
            this.appendParameterFacets(writer, parameter);
            this.appendAnnotations(writer, parameter);
            writer.writeEndElement();
        }
    }

    private void appendActions(XMLStreamWriter writer, List<EdmAction> actions) throws XMLStreamException {
        for (EdmAction action : actions) {
            writer.writeStartElement("Action");
            writer.writeAttribute(XML_NAME, action.getName());
            if (action.getEntitySetPath() != null) {
                writer.writeAttribute(XML_ENTITY_SET_PATH, action.getEntitySetPath());
            }
            writer.writeAttribute(XML_IS_BOUND, "" + action.isBound());
            this.appendOperationParameters(writer, action);
            this.appendOperationReturnType(writer, action);
            this.appendAnnotations(writer, action);
            writer.writeEndElement();
        }
    }

    private void appendReturnTypeFacets(XMLStreamWriter writer, EdmReturnType returnType) throws XMLStreamException {
        if (!returnType.isNullable()) {
            writer.writeAttribute(XML_NULLABLE, "" + returnType.isNullable());
        }
        if (returnType.getMaxLength() != null) {
            writer.writeAttribute(XML_MAX_LENGTH, "" + returnType.getMaxLength());
        }
        if (returnType.getPrecision() != null) {
            writer.writeAttribute(XML_PRECISION, "" + returnType.getPrecision());
        }
        if (returnType.getScale() != null) {
            writer.writeAttribute(XML_SCALE, "" + returnType.getScale());
        }
    }

    private void appendParameterFacets(XMLStreamWriter writer, EdmParameter parameter) throws XMLStreamException {
        if (!parameter.isNullable()) {
            writer.writeAttribute(XML_NULLABLE, "" + parameter.isNullable());
        }
        if (parameter.getMaxLength() != null) {
            writer.writeAttribute(XML_MAX_LENGTH, "" + parameter.getMaxLength());
        }
        if (parameter.getPrecision() != null) {
            writer.writeAttribute(XML_PRECISION, "" + parameter.getPrecision());
        }
        if (parameter.getScale() != null) {
            writer.writeAttribute(XML_SCALE, "" + parameter.getScale());
        }
    }

    private void appendComplexTypes(XMLStreamWriter writer, List<EdmComplexType> complexTypes) throws XMLStreamException {
        for (EdmComplexType complexType : complexTypes) {
            writer.writeStartElement(XML_COMPLEX_TYPE);
            writer.writeAttribute(XML_NAME, complexType.getName());
            if (complexType.getBaseType() != null) {
                writer.writeAttribute(XML_BASE_TYPE, this.getAliasedFullQualifiedName(complexType.getBaseType(), false));
            }
            if (complexType.isAbstract()) {
                writer.writeAttribute(ABSTRACT, TRUE);
            }
            if (complexType.isOpenType()) {
                writer.writeAttribute(OPEN_TYPE, TRUE);
            }
            this.appendProperties(writer, complexType);
            this.appendNavigationProperties(writer, complexType);
            this.appendAnnotations(writer, complexType);
            writer.writeEndElement();
        }
    }

    private void appendEntityTypes(XMLStreamWriter writer, List<EdmEntityType> entityTypes) throws XMLStreamException {
        for (EdmEntityType entityType : entityTypes) {
            writer.writeStartElement(XML_ENTITY_TYPE);
            writer.writeAttribute(XML_NAME, entityType.getName());
            if (entityType.hasStream()) {
                writer.writeAttribute(XML_HAS_STREAM, "" + entityType.hasStream());
            }
            if (entityType.getBaseType() != null) {
                writer.writeAttribute(XML_BASE_TYPE, this.getAliasedFullQualifiedName(entityType.getBaseType(), false));
            }
            if (entityType.isAbstract()) {
                writer.writeAttribute(ABSTRACT, TRUE);
            }
            if (entityType.isOpenType()) {
                writer.writeAttribute(OPEN_TYPE, TRUE);
            }
            this.appendKey(writer, entityType);
            this.appendProperties(writer, entityType);
            this.appendNavigationProperties(writer, entityType);
            this.appendAnnotations(writer, entityType);
            writer.writeEndElement();
        }
    }

    private void appendNavigationProperties(XMLStreamWriter writer, EdmStructuredType type) throws XMLStreamException {
        ArrayList<String> navigationPropertyNames = new ArrayList<String>(type.getNavigationPropertyNames());
        if (type.getBaseType() != null) {
            navigationPropertyNames.removeAll(type.getBaseType().getNavigationPropertyNames());
        }
        for (String navigationPropertyName : navigationPropertyNames) {
            EdmNavigationProperty navigationProperty = type.getNavigationProperty(navigationPropertyName);
            writer.writeStartElement(XML_NAVIGATION_PROPERTY);
            writer.writeAttribute(XML_NAME, navigationPropertyName);
            writer.writeAttribute("Type", this.getAliasedFullQualifiedName(navigationProperty.getType(), navigationProperty.isCollection()));
            if (!navigationProperty.isNullable()) {
                writer.writeAttribute(XML_NULLABLE, "" + navigationProperty.isNullable());
            }
            if (navigationProperty.getPartner() != null) {
                EdmNavigationProperty partner = navigationProperty.getPartner();
                writer.writeAttribute(XML_PARTNER, partner.getName());
            }
            if (navigationProperty.containsTarget()) {
                writer.writeAttribute(XML_CONTAINS_TARGET, "" + navigationProperty.containsTarget());
            }
            if (navigationProperty.getReferentialConstraints() != null) {
                for (EdmReferentialConstraint constraint : navigationProperty.getReferentialConstraints()) {
                    writer.writeStartElement("ReferentialConstraint");
                    writer.writeAttribute(XML_PROPERTY, constraint.getPropertyName());
                    writer.writeAttribute("ReferencedProperty", constraint.getReferencedPropertyName());
                    this.appendAnnotations(writer, constraint);
                    writer.writeEndElement();
                }
            }
            if (navigationProperty.getOnDelete() != null) {
                writer.writeStartElement(XML_ON_DELETE);
                writer.writeAttribute("Action", navigationProperty.getOnDelete().getAction());
                this.appendAnnotations(writer, navigationProperty.getOnDelete());
                writer.writeEndElement();
            }
            this.appendAnnotations(writer, navigationProperty);
            writer.writeEndElement();
        }
    }

    private void appendProperties(XMLStreamWriter writer, EdmStructuredType type) throws XMLStreamException {
        ArrayList<String> propertyNames = new ArrayList<String>(type.getPropertyNames());
        if (type.getBaseType() != null) {
            propertyNames.removeAll(type.getBaseType().getPropertyNames());
        }
        for (String propertyName : propertyNames) {
            EdmProperty property = type.getStructuralProperty(propertyName);
            writer.writeStartElement(XML_PROPERTY);
            writer.writeAttribute(XML_NAME, propertyName);
            String fqnString = property.isPrimitive() ? this.getFullQualifiedName(property.getType(), property.isCollection()) : this.getAliasedFullQualifiedName(property.getType(), property.isCollection());
            writer.writeAttribute("Type", fqnString);
            if (!property.isNullable()) {
                writer.writeAttribute(XML_NULLABLE, "" + property.isNullable());
            }
            if (!property.isUnicode()) {
                writer.writeAttribute(XML_UNICODE, "" + property.isUnicode());
            }
            if (property.getDefaultValue() != null) {
                writer.writeAttribute(XML_DEFAULT_VALUE, property.getDefaultValue());
            }
            if (property.getMaxLength() != null) {
                writer.writeAttribute(XML_MAX_LENGTH, "" + property.getMaxLength());
            }
            if (property.getPrecision() != null) {
                writer.writeAttribute(XML_PRECISION, "" + property.getPrecision());
            }
            if (property.getScaleAsString() != null) {
                writer.writeAttribute(XML_SCALE, property.getScaleAsString());
            } else if (property.getScale() != null) {
                writer.writeAttribute(XML_SCALE, "" + property.getScale());
            }
            if (property.getSrid() != null) {
                writer.writeAttribute(XML_SRID, String.valueOf(property.getSrid()));
            }
            this.appendAnnotations(writer, property);
            writer.writeEndElement();
        }
    }

    private void appendKey(XMLStreamWriter writer, EdmEntityType entityType) throws XMLStreamException {
        List<EdmKeyPropertyRef> keyPropertyRefs = entityType.getKeyPropertyRefs();
        if (keyPropertyRefs != null && !keyPropertyRefs.isEmpty()) {
            EdmEntityType baseType = entityType.getBaseType();
            if (baseType != null && baseType.getKeyPropertyRefs() != null && !baseType.getKeyPropertyRefs().isEmpty()) {
                return;
            }
            writer.writeStartElement(XML_KEY);
            for (EdmKeyPropertyRef keyRef : keyPropertyRefs) {
                writer.writeEmptyElement(XML_PROPERTY_REF);
                writer.writeAttribute(XML_NAME, keyRef.getName());
                if (keyRef.getAlias() == null) continue;
                writer.writeAttribute(XML_ALIAS, keyRef.getAlias());
            }
            writer.writeEndElement();
        }
    }

    private void appendEnumTypes(XMLStreamWriter writer, List<EdmEnumType> enumTypes) throws XMLStreamException {
        for (EdmEnumType enumType : enumTypes) {
            writer.writeStartElement(XML_ENUM_TYPE);
            writer.writeAttribute(XML_NAME, enumType.getName());
            writer.writeAttribute(XML_IS_FLAGS, Boolean.toString(enumType.isFlags()));
            writer.writeAttribute(XML_UNDERLYING_TYPE, this.getFullQualifiedName(enumType.getUnderlyingType(), false));
            for (String memberName : enumType.getMemberNames()) {
                writer.writeStartElement(XML_MEMBER);
                writer.writeAttribute(XML_NAME, memberName);
                EdmMember member = enumType.getMember(memberName);
                if (member.getValue() != null) {
                    writer.writeAttribute(XML_VALUE, member.getValue());
                }
                this.appendAnnotations(writer, member);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private String getFullQualifiedName(EdmType type, boolean isCollection) {
        String name = type.getFullQualifiedName().getFullQualifiedNameAsString();
        return isCollection ? "Collection(" + name + ")" : name;
    }

    private String getAliasedFullQualifiedName(EdmType type, boolean isCollection) {
        FullQualifiedName fqn = type.getFullQualifiedName();
        return this.getAliasedFullQualifiedName(fqn, isCollection);
    }

    private String getAliasedFullQualifiedName(FullQualifiedName fqn, boolean isCollection) {
        Object name = this.namespaceToAlias.get(fqn.getNamespace()) != null ? this.namespaceToAlias.get(fqn.getNamespace()) + "." + fqn.getName() : fqn.getFullQualifiedNameAsString();
        return isCollection ? "Collection(" + (String)name + ")" : name;
    }

    private void appendReference(XMLStreamWriter writer) throws XMLStreamException {
        for (EdmxReference reference : this.serviceMetadata.getReferences()) {
            writer.writeStartElement(PREFIX_EDMX, REFERENCE, NS_EDMX);
            writer.writeAttribute(URI, reference.getUri().toASCIIString());
            List<EdmxReferenceInclude> includes = reference.getIncludes();
            for (EdmxReferenceInclude include : includes) {
                writer.writeStartElement(PREFIX_EDMX, INCLUDE, NS_EDMX);
                writer.writeAttribute(XML_NAMESPACE, include.getNamespace());
                if (include.getAlias() != null) {
                    this.namespaceToAlias.put(include.getNamespace(), include.getAlias());
                    writer.writeAttribute(XML_ALIAS, include.getAlias());
                }
                writer.writeEndElement();
            }
            List<EdmxReferenceIncludeAnnotation> includeAnnotations = reference.getIncludeAnnotations();
            for (EdmxReferenceIncludeAnnotation includeAnnotation : includeAnnotations) {
                writer.writeStartElement(PREFIX_EDMX, INCLUDE_ANNOTATIONS, NS_EDMX);
                writer.writeAttribute(XML_TERM_NAMESPACE, includeAnnotation.getTermNamespace());
                if (includeAnnotation.getQualifier() != null) {
                    writer.writeAttribute("Qualifier", includeAnnotation.getQualifier());
                }
                if (includeAnnotation.getTargetNamespace() != null) {
                    writer.writeAttribute(XML_TARGET_NAMESPACE, includeAnnotation.getTargetNamespace());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

