/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.queryoption.expression;

import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Unary;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;

public class UnaryImpl
implements Unary {
    private final UnaryOperatorKind operator;
    private final Expression expression;
    private final EdmType type;

    public UnaryImpl(UnaryOperatorKind operator, Expression expression, EdmType type) {
        this.operator = operator;
        this.expression = expression;
        this.type = type;
    }

    @Override
    public UnaryOperatorKind getOperator() {
        return this.operator;
    }

    @Override
    public Expression getOperand() {
        return this.expression;
    }

    public EdmType getType() {
        return this.type;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws ExpressionVisitException, ODataApplicationException {
        T operand = this.expression.accept(visitor);
        return visitor.visitUnaryOperator(this.operator, operand);
    }

    public String toString() {
        return "{" + this.operator.name() + " " + String.valueOf(this.expression) + "}";
    }
}

