/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntityRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataEntityRequestImpl<E extends ClientEntity>
extends AbstractODataRetrieveRequest<E>
implements ODataEntityRequest<E> {
    public ODataEntityRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public ODataRetrieveResponse<E> execute() {
        return new ODataEntityResponseImpl(this.odataClient, this.httpClient, this.doExecute());
    }

    public class ODataEntityResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private E entity;

        private ODataEntityResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(ODataEntityRequestImpl.this, odataClient, httpClient, res);
            this.entity = null;
        }

        @Override
        public E getBody() {
            if (this.entity == null) {
                try {
                    ResWrap<Entity> resource = this.odataClient.getDeserializer(ContentType.parse(this.getContentType())).toEntity(this.getRawResponse());
                    this.entity = this.odataClient.getBinder().getODataEntity(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.entity;
        }
    }
}

