/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.geo;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class Point
extends Geospatial {
    private double x;
    private double y;
    private double z;

    public Point(Geospatial.Dimension dimension, SRID srid) {
        super(dimension, Geospatial.Type.POINT, srid);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    @Override
    public EdmPrimitiveTypeKind getEdmPrimitiveTypeKind() {
        return this.dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyPoint : EdmPrimitiveTypeKind.GeometryPoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        return this.dimension == point.dimension && (this.srid == null ? point.srid == null : this.srid.equals(point.srid)) && this.x == point.x && this.y == point.y && this.z == point.z;
    }

    public int hashCode() {
        int result = this.dimension == null ? 0 : this.dimension.hashCode();
        result = 31 * result + (this.srid == null ? 0 : this.srid.hashCode());
        result = 31 * result + Double.valueOf(this.x).hashCode();
        result = 31 * result + Double.valueOf(this.y).hashCode();
        result = 31 * result + Double.valueOf(this.z).hashCode();
        return result;
    }

    public String toString() {
        return (this.dimension == null ? "" : this.dimension.name()) + "'" + (String)(this.srid == null ? "" : "SRID=" + this.srid.toString() + ";") + "Point(" + this.x + " " + this.y + ")'";
    }
}

