/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmOnDelete;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlOnDelete;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmOnDeleteImpl;
import org.apache.olingo.commons.core.edm.EdmReferentialConstraintImpl;

public class EdmNavigationPropertyImpl
extends AbstractEdmNamed
implements EdmNavigationProperty {
    private final CsdlNavigationProperty navigationProperty;
    private List<EdmReferentialConstraint> referentialConstraints;
    private EdmEntityType typeImpl;
    private EdmNavigationProperty partnerNavigationProperty;

    public EdmNavigationPropertyImpl(Edm edm, CsdlNavigationProperty navigationProperty) {
        super(edm, navigationProperty.getName(), navigationProperty);
        this.navigationProperty = navigationProperty;
    }

    @Override
    public boolean isCollection() {
        return this.navigationProperty.isCollection();
    }

    @Override
    public boolean isNullable() {
        return this.navigationProperty.isNullable();
    }

    @Override
    public boolean containsTarget() {
        return this.navigationProperty.isContainsTarget();
    }

    @Override
    public EdmEntityType getType() {
        if (this.typeImpl == null) {
            this.typeImpl = this.edm.getEntityType(this.navigationProperty.getTypeFQN());
            if (this.typeImpl == null) {
                throw new EdmException("Cannot find type with name: " + String.valueOf(this.navigationProperty.getTypeFQN()));
            }
        }
        return this.typeImpl;
    }

    @Override
    public EdmNavigationProperty getPartner() {
        String partner;
        if (this.partnerNavigationProperty == null && (partner = this.navigationProperty.getPartner()) != null) {
            String[] split;
            EdmEntityType type = this.getType();
            EdmNavigationProperty property = null;
            for (String element : split = partner.split("/")) {
                property = type.getNavigationProperty(element);
                if (property == null) {
                    throw new EdmException("Cannot find navigation property with name: " + element + " at type " + type.getName());
                }
                type = property.getType();
            }
            this.partnerNavigationProperty = property;
        }
        return this.partnerNavigationProperty;
    }

    @Override
    public String getReferencingPropertyName(String referencedPropertyName) {
        List<CsdlReferentialConstraint> refConstraints = this.navigationProperty.getReferentialConstraints();
        if (refConstraints != null) {
            for (CsdlReferentialConstraint constraint : refConstraints) {
                if (!constraint.getReferencedProperty().equals(referencedPropertyName)) continue;
                return constraint.getProperty();
            }
        }
        return null;
    }

    @Override
    public List<EdmReferentialConstraint> getReferentialConstraints() {
        if (this.referentialConstraints == null) {
            List<CsdlReferentialConstraint> providerConstraints = this.navigationProperty.getReferentialConstraints();
            ArrayList<EdmReferentialConstraintImpl> referentialConstraintsLocal = new ArrayList<EdmReferentialConstraintImpl>();
            if (providerConstraints != null) {
                for (CsdlReferentialConstraint constraint : providerConstraints) {
                    referentialConstraintsLocal.add(new EdmReferentialConstraintImpl(this.edm, constraint));
                }
            }
            this.referentialConstraints = Collections.unmodifiableList(referentialConstraintsLocal);
        }
        return this.referentialConstraints;
    }

    @Override
    public EdmOnDelete getOnDelete() {
        CsdlOnDelete csdlOnDelete = this.navigationProperty.getOnDelete();
        return csdlOnDelete != null ? new EdmOnDeleteImpl(this.edm, csdlOnDelete) : null;
    }
}

