/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.annotation.EdmApply;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlApply;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmAnnotatableDynamicExpression;

public class EdmApplyImpl
extends AbstractEdmAnnotatableDynamicExpression
implements EdmApply {
    private CsdlApply csdlExp;
    private String function;
    private List<EdmExpression> parameters;

    public EdmApplyImpl(Edm edm, CsdlApply csdlExp) {
        super(edm, "Apply", csdlExp);
        this.csdlExp = csdlExp;
    }

    @Override
    public String getFunction() {
        if (this.function == null) {
            if (this.csdlExp.getFunction() == null) {
                throw new EdmException("An Apply expression must specify a function.");
            }
            this.function = this.csdlExp.getFunction();
        }
        return this.function;
    }

    @Override
    public List<EdmExpression> getParameters() {
        if (this.parameters == null) {
            ArrayList<EdmExpression> localParameters = new ArrayList<EdmExpression>();
            if (this.csdlExp.getParameters() != null) {
                for (CsdlExpression param : this.csdlExp.getParameters()) {
                    localParameters.add(EdmApplyImpl.getExpression(this.edm, param));
                }
            }
            this.parameters = Collections.unmodifiableList(localParameters);
        }
        return this.parameters;
    }

    @Override
    public EdmExpression.EdmExpressionType getExpressionType() {
        return EdmExpression.EdmExpressionType.Apply;
    }
}

