/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmDecimal
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("(?:\\+|-)?(?:0*(\\p{Digit}+?))(?:\\.(\\p{Digit}+?)0*)?((?:E|e)(?:\\+|-)?\\p{Digit}+)?");
    private static final EdmDecimal INSTANCE = new EdmDecimal();

    public static EdmDecimal getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return primitiveType instanceof EdmByte || primitiveType instanceof EdmSByte || primitiveType instanceof EdmInt16 || primitiveType instanceof EdmInt32 || primitiveType instanceof EdmInt64 || primitiveType instanceof EdmSingle || primitiveType instanceof EdmDouble || primitiveType instanceof EdmDecimal;
    }

    @Override
    public Class<?> getDefaultType() {
        return BigDecimal.class;
    }

    @Override
    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        return value == null ? isNullable == null || isNullable.booleanValue() : EdmDecimal.validateLiteral(value) && EdmDecimal.validatePrecisionAndScale(value, precision, scale);
    }

    private static boolean validateLiteral(String value) {
        return PATTERN.matcher(value).matches();
    }

    private static boolean validatePrecisionAndScale(String value, Integer precision, Integer scale) {
        if (precision == null && scale == Constants.VARIABLE_SCALE) {
            return true;
        }
        Matcher matcher = PATTERN.matcher(value);
        matcher.matches();
        if (matcher.group(3) != null) {
            String plainValue = new BigDecimal(value).toPlainString();
            matcher = PATTERN.matcher(plainValue);
            matcher.matches();
        }
        int integerDigits = matcher.group(1).length();
        int significantIntegerDigits = "0".equals(matcher.group(1)) ? 0 : integerDigits;
        int decimals = matcher.group(2) == null || "0".equals(matcher.group(2)) ? 0 : matcher.group(2).length();
        int scaleValue = 0;
        if (scale != null) {
            scaleValue = scale;
        }
        if (precision == null) {
            return 0 <= decimals && decimals <= scaleValue;
        }
        if (precision >= 0 && scale == Constants.VARIABLE_SCALE) {
            return significantIntegerDigits + decimals <= precision;
        }
        boolean case1 = precision > scaleValue && integerDigits >= 1 && integerDigits <= precision - scaleValue && 0 <= decimals && decimals <= scaleValue;
        boolean case2 = precision == scaleValue && "0".equals(matcher.group(1)) && 0 <= decimals && decimals <= scaleValue;
        return case1 || case2;
    }

    @Override
    public boolean validateDecimals(String value, Boolean isNullable, Integer maxLength, Integer precision, String scale, Boolean isUnicode) {
        return value == null ? isNullable == null || isNullable.booleanValue() : EdmDecimal.validateLiteral(value) && this.validatePrecisionAndScale(value, precision, scale);
    }

    private boolean validatePrecisionAndScale(String value, Integer precision, String scale) {
        Matcher matcher = PATTERN.matcher(value);
        matcher.matches();
        if (matcher.group(3) != null) {
            String plainValue = new BigDecimal(value).toPlainString();
            matcher = PATTERN.matcher(plainValue);
            matcher.matches();
        }
        int significantIntegerDigits = "0".equals(matcher.group(1)) ? 0 : matcher.group(1).length();
        int decimals = matcher.group(2) == null ? 0 : matcher.group(2).length();
        try {
            int scaleValue = scale == null ? 0 : Integer.parseInt(scale);
            return (precision == null || significantIntegerDigits >= 0 && significantIntegerDigits <= precision - scaleValue) && decimals >= 0 && decimals <= scaleValue;
        }
        catch (NumberFormatException e) {
            String scaleValue;
            String string = scaleValue = scale == null ? String.valueOf(0) : scale;
            if (scaleValue.equals("variable")) {
                return (precision == null || significantIntegerDigits >= 0 && significantIntegerDigits <= precision - decimals) && decimals >= 0 && decimals <= (precision == null ? 0 : precision);
            }
            if (scaleValue.equals("floating")) {
                Matcher matcher1 = PATTERN.matcher(value);
                matcher1.matches();
                significantIntegerDigits = "0".equals(matcher1.group(1)) ? 0 : matcher1.group(1).length();
                decimals = matcher1.group(2) == null ? 0 : matcher1.group(2).length();
                int exponents = 0;
                if (matcher1.group(3) != null) {
                    exponents = Integer.parseInt(matcher1.group(3).substring(1));
                    if ((exponents < -95 || exponents > 96) && String.valueOf(exponents).startsWith("-")) {
                        significantIntegerDigits += Integer.parseInt(String.valueOf(exponents + 95).substring(1));
                        exponents = -95;
                    }
                    return significantIntegerDigits + decimals <= 7 && exponents >= -95 && exponents <= 96;
                }
            }
            return false;
        }
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (!EdmDecimal.validateLiteral(value)) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        if (!EdmDecimal.validatePrecisionAndScale(value, precision, scale)) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' does not match the facets' constraints.");
        }
        try {
            return EdmDecimal.convertDecimal(new BigDecimal(value), returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + String.valueOf(returnType) + " without loss of data.", e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + String.valueOf(returnType) + " is not supported.", e);
        }
    }

    protected static <T> T convertDecimal(BigDecimal value, Class<T> returnType) throws IllegalArgumentException, ClassCastException {
        if (returnType.isAssignableFrom(BigDecimal.class)) {
            return returnType.cast(value);
        }
        if (returnType.isAssignableFrom(Double.class)) {
            double doubleValue = value.doubleValue();
            if (BigDecimal.valueOf(doubleValue).compareTo(value) == 0) {
                return returnType.cast(doubleValue);
            }
            throw new IllegalArgumentException();
        }
        if (returnType.isAssignableFrom(Float.class)) {
            Float floatValue = Float.valueOf(value.floatValue());
            if (BigDecimal.valueOf(floatValue.floatValue()).compareTo(value) == 0) {
                return returnType.cast(floatValue);
            }
            throw new IllegalArgumentException();
        }
        try {
            if (returnType.isAssignableFrom(BigInteger.class)) {
                return returnType.cast(value.toBigIntegerExact());
            }
            if (returnType.isAssignableFrom(Long.class)) {
                return returnType.cast(value.longValueExact());
            }
            if (returnType.isAssignableFrom(Integer.class)) {
                return returnType.cast(value.intValueExact());
            }
            if (returnType.isAssignableFrom(Short.class)) {
                return returnType.cast(value.shortValueExact());
            }
            if (returnType.isAssignableFrom(Byte.class)) {
                return returnType.cast(value.byteValueExact());
            }
            throw new ClassCastException("unsupported return type " + returnType.getSimpleName());
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        String result;
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof BigInteger) {
            int digits;
            result = value.toString();
            int n = digits = result.startsWith("-") ? result.length() - 1 : result.length();
            if (precision != null && precision < digits) {
                throw new EdmPrimitiveTypeException("The value '" + String.valueOf(value) + "' does not match the facets' constraints.");
            }
        } else if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
            BigDecimal bigDecimalValue;
            try {
                bigDecimalValue = value instanceof Double ? BigDecimal.valueOf((Double)value) : (value instanceof Float ? BigDecimal.valueOf(((Float)value).floatValue()) : (BigDecimal)value);
            }
            catch (NumberFormatException e) {
                throw new EdmPrimitiveTypeException("The value '" + String.valueOf(value) + "' is not valid.", e);
            }
            result = bigDecimalValue.toPlainString();
        } else {
            throw new EdmPrimitiveTypeException("The value type " + String.valueOf(value.getClass()) + " is not supported.");
        }
        if (!EdmDecimal.validatePrecisionAndScale(result, precision, scale)) {
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(value) + "' does not match the facets' constraints.");
        }
        return result;
    }
}

