/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;

public final class EdmGeometryMultiLineString
extends AbstractGeospatialType<MultiLineString> {
    private static final EdmGeometryMultiLineString INSTANCE = new EdmGeometryMultiLineString();

    public static EdmGeometryMultiLineString getInstance() {
        return INSTANCE;
    }

    public EdmGeometryMultiLineString() {
        super(MultiLineString.class, Geospatial.Dimension.GEOMETRY, Geospatial.Type.MULTILINESTRING);
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        MultiLineString multiLineString = this.stringToMultiLineString(value, isNullable, maxLength, precision, scale, isUnicode);
        if (returnType.isAssignableFrom(MultiLineString.class)) {
            return returnType.cast(multiLineString);
        }
        throw new EdmPrimitiveTypeException("The value type " + String.valueOf(returnType) + " is not supported.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof MultiLineString) {
            return this.toString((MultiLineString)value, isNullable, maxLength, precision, scale, isUnicode);
        }
        throw new EdmPrimitiveTypeException("The value type " + String.valueOf(value.getClass()) + " is not supported.");
    }
}

